/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Team Sprinkles",
    /* First member full name */
    "Jay Stearns",
    /* First member email address */
    "stearns+@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Benjamin Payne",
    /* Second member email address (blank if none) */
    "bpayne+@andrew.cmu.edu"
};



long int * head_ptr; //Used to store the beginning of the list



long int *find_free(long int size)
{
  
  long int *free_ptr = head_ptr + 1L;
  long int *free_prev = NULL;
  long int *temp_free = NULL;
  long int *best_free = NULL;
  long int best_size = 0;
  long int temp_size = 0;

  if (*free_ptr == NULL)
    {
      return NULL;
    }
  else
    {
      temp_free = free_ptr;
      free_prev = temp_free;
      best_free = (long int *)*free_ptr; //First free element in the free list
      best_size = (long int)*(best_free +1L);
      free_ptr = best_free;

      while (free_ptr != NULL)
	{
	  temp_size = *(free_ptr + 1L);
	  if (temp_size >= size)
	    {
	      //then we should consider it(check size for best fit)
	      if (temp_size < best_size || best_size < size)
		{
		  //then it's better than what we've seen so far
		  //update value and pointer
		  free_prev = temp_free;
		  best_size = temp_size;
		  best_free = free_ptr;
		}
	    }
	  temp_free = free_ptr;
	  //move on to next block
	  free_ptr = (long int *)(*free_ptr);	  
	}
      //remove from free list
      if(best_size >= size) {
        *free_prev = *best_free;
        return (best_free);
      }
    }
  return NULL;
}

void add_free(long int * p) 
{
  /* Function adds the pointer p to the free list in the correct location.
     If prev is NULL you must find the location, otherwise you can just
     append p to prev and adjust prev.next to be in p.next */
  long int *free_ptr = head_ptr + 1L;
  long int *close_low = NULL;
  long int *close_high = NULL;
  short int coalesce_low  = 0;
  short int coalesce_high = 0;
  
  close_low = free_ptr;
  if(*free_ptr == NULL) {
    //Base case empty free list.
    *p = *free_ptr;
    *free_ptr = (long int)p;
    return;
  }
  close_high = (long int *)(*free_ptr);
  
  
  while (free_ptr != NULL){
    if ((long int)free_ptr < (long int)p){
      if ((long int)free_ptr > (long int)close_low){
        close_low = free_ptr;
        close_high = (long int *)*free_ptr;
      }
    }
      free_ptr = (long int *)*free_ptr;
  }

  if((((long int)close_low)+8L+(long int)*(close_low+1L)) == (long int)p)
    coalesce_low  = 1;
  if(close_high != NULL) {
    if((((long int)p)+ 16L + (long int)*(p+1L)) == (long int)close_high)
      coalesce_high = 1;
  }

  if(coalesce_low && coalesce_high) {
    *(close_low + 1L) = (long int)*(close_low + 1L) + (long int)*(p + 1L) + 
                       (long int)*(close_high + 1L) + 32L;
    *(close_low) = *(close_high);
    return;
  }
  if(coalesce_low) {
    *(close_low + 1L) = (long int)*(close_low + 1L) + (long int)*(p+1L)+16L;
    return;
  }
  if(coalesce_high) {
    *(p+1L) = (long int)*(p+1L) + (long int)*(close_high+1L) + 16L;
    *p = *close_high;
    *close_low = (long int)p;
    return;
    }
  //coalesce_low & coalesce_high are 0
  
  *p = *close_low;
  *close_low = (long int)p;
  
}

int mm_init (void)
{
  /* Basic memory structure is 16-bytes, 8-byte ptr to next used block
     and a 16-byte block with <ptr to next free, size of current free>.*/
  long int * p;
  head_ptr =(long int *) mem_sbrk(mem_pagesize());
  //head_ptr = (long int *)mem_sbrk(32);
  head_ptr = (long int *)dseg_lo;
  p = head_ptr;
  if(p == NULL) return -1;
  *p = NULL;
  *(p+1L) = (long int)(p+2L);
  *(p+2L) = NULL;
  *(p+3L) = ((long int)(dseg_hi-dseg_lo)) - 31L;
  /* DEBUGGING PRINTOUT */
  /*
  printf("MM_INIT()\nAllocation of initial heap pointers:\n");
  printf("- head_ptr          : %p *head_ptr: %ld\n",p, *p);
  printf("- free_ptr          : %p *free_ptr: %ld\n",p+1L,*(p+1L));
  printf("- first free element: %p next_ptr : %ld\n",p+2L,*(p+2L));
  printf("-\t\t\t\tsize     : %ld\n",(long int)*(p + 3L));
  printf("END MM_INIT()\n\n");
  */
  return 0;
}

void *mm_malloc (size_t size)
{
  long int *p = NULL;
  long int *free_temp = NULL; //Left over free bytes go here
  long int *old_dseg_hi = NULL;
  char * old_dseg_hi_c = NULL;
  long int free_space = 0;

  size = (size + 7L)&(~0L << 3L); //8-byte align the requested memory
  p = find_free(size);

  if(p == NULL){
    //printf("find_free returned NULL\n");
    old_dseg_hi = (long int *)(dseg_hi+1L);
    old_dseg_hi_c = (dseg_hi + 1L);
    free_space = (size+16L);
      //((size+16L) + 8191L)&(~0L<<13);
    p = mem_sbrk(free_space);
    if(p == NULL) {
printf("WARNING: System out of memory.\n");
      return 0;
    }
    free_space = free_space - (size+32L);
    *old_dseg_hi = (long int)*head_ptr;
    *head_ptr = (long int)old_dseg_hi;
    if(free_space < 17L) {
      *(old_dseg_hi + 1L) = size +free_space+ 16L;
      return old_dseg_hi +2L;
    }
    *(old_dseg_hi +1L) = size + 16L;
    free_temp = (long int *)((long int)old_dseg_hi+16L+size);
    *(free_temp + 1L) = free_space;
    add_free(free_temp);

    return old_dseg_hi+2L;
  }
  free_space = *(p+1L);
  if((free_space - size) < 17L) {//No extra space for free block
    //No remaining space can be used after the datablock is assigned
    *p = (long int)*head_ptr;
    *head_ptr = (long int)p;
    return p+2L;
  }
  else {//Have extra space for alocating a free block
    *p = (long int)*head_ptr;
    *head_ptr = (long int)p;
    *(p+1L) = (long int)size;
    free_temp =(long int *)((long int)p+size);
    *(free_temp + 1L) = free_space-size-16L;
    if((free_space-size)%8) printf("FREE SPACE IS NOT 8-BYTE ALIGNED...");
    add_free(free_temp); 
    return p+2L;
  }
return NULL;
}

void mm_free (void *ptr)
{
  /* Step 1: find exact matching address in data_list to ptr.
     Step 2: If there is no match, return NULL
     Step 3: If there is a match
     - Remove this block from the data_list and relink
     - data_prev.next to, this_block.next
     - Need to add to free list ptr
     - add_free(new free block)
     Done
  */
  long int * prev = NULL;
  long int * next = NULL;
  long int * compare_to = ((long int *)ptr -2L);
  if(ptr == NULL || ((long int)ptr < (long int)dseg_lo) || 
     ((long int)ptr > (long int)dseg_hi)) return;

  if(*head_ptr == NULL) return; //Nothing is stored, so can't free anything
  else {
    prev = head_ptr;
    next = (long int *)(*head_ptr);
    if(*next == NULL) {
      // One element list
      if((long int)next == (long int)compare_to) {
        *prev = *next;
        add_free(next);
	//printf("freeing %p\n",next);
        return;
      }
      // One element list and its not the one we're looking for
      return;
    }
    while(next != NULL){ //Search for element in data list
      if((long int)next == (long int)compare_to) {
        *prev = *next;
        add_free(next);
        return; 
      }
      next = (long int *)*next;
      prev = (long int *)*prev; 
    }
  }
}

