/* $Id: malloc.c,v 1.1 1999/03/08 18:58:06 shapiro Exp $ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>
#include <string.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "garbage collectors",
    /* First member full name */
    "Abram Shapiro",
    /* First member email address */
    "shapiro@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "David Wasserstrum",
    /* Second member email address (blank if none) */
    "dw@andrew.cmu.edu"
};

struct mblock
{
  size_t prev_size;   /* Size of previous block (if free). */
  size_t size;        /* Size in bytes, including overhead. */
  size_t fwd;         /* offset double links -- used only if free. */
  size_t back;
};

typedef struct mblock* mblockptr;

#define SIZE         (sizeof(size_t))
#define MIN_OVERHEAD (SIZE + SIZE)
#define ALIGN_MASK   (MIN_OVERHEAD - 1)
#define MINSIZE      (sizeof(struct mblock))

/* extend memory requested to usable length */
#define reqToSize(req) \
 (((long)((req) + (SIZE + ALIGN_MASK)) < (long)(MINSIZE + ALIGN_MASK)) \
           ? MINSIZE : (((req) + (SIZE + ALIGN_MASK)) & ~(ALIGN_MASK)))

#define INUSE  0x1  /* | with size field */

#define FIRSTBIN ((mblockptr)(dseg_lo))
#define NUMBINS 24
#define MEM_HEAD ((mblockptr)(dseg_lo+(NUMBINS*8)))

int mm_init (void)
{
  mblockptr firstBin = FIRSTBIN;
  struct mblock doorStop = { (size_t)INUSE,
			     (size_t)INUSE,
			     (size_t)0,
			     (size_t)0 };
  mblockptr bins[NUMBINS] =
  {
    firstBin,   
    firstBin+8,
    firstBin+16,
    firstBin+24,
    firstBin+32,
    firstBin+40,
    firstBin+48,
    firstBin+56,
    firstBin+64,
    firstBin+72,
    firstBin+80,
    firstBin+88,
    firstBin+96,
    firstBin+104,
    firstBin+112,
    firstBin+120,
    firstBin+128,
    firstBin+136,
    firstBin+144,
    firstBin+152,
    firstBin+160,
    firstBin+168,
    firstBin+176,
    firstBin+184,
  };
  
  if(mem_usage() != -1)
    return -1;

  mem_sbrk(NUMBINS*8);
  memcpy((void*)dseg_lo,(void*)bins,NUMBINS*8);
  memcpy((void*)MEM_HEAD,(void*)&doorStop,sizeof(struct mblock));
  return 0;
}

int sizeToBin(size_t size)
{
  int index = 0;
  while (size >= MINSIZE)
  /* find power of 2 */
  {
    index++;
    size >>= 1;
  }
  return index;
}

/* maintain usage state of block with size field */
#define inuse(bp)     ((bp)->size &   INUSE)
#define setInuse(bp)  ((bp)->size |=  INUSE)
#define clearInuse(bp)((bp)->size &= ~INUSE)
/* returns a pointer to next physical memory block */
#define nextBlock(bp) ((mblockptr)(((char*)(bp)) + ((bp)->size & ~INUSE)))
/* returns a pointer to the previous physical memory block */
#define prevBlock(bp) ((mblockptr)(((char*)(bp)) - ((bp)->prev_size)))

/* put size in header and footer of block */
#define setSize(bp,s) ((bp)->size = \
                      ((mblockptr)((char*)(bp) + (s)))->prev_size = (s))

/* converts from memory block pointers to size offsets */
#define blockToOffset(bptr)   ((size_t)((long)(bptr) - (long)dseg_lo))
/* converts from size offsets to memory block pointers */
#define offsetToBlock(offset) ((mblockptr)(dseg_lo + offset))
/* converts from memory block pointers to user pointers */
#define blockToMem(bptr)      ((void*)((char*)(bptr) + 2*SIZE))
/* converts from user pointers to memory block pointers */
#define memToBlock(mem)       ((mblockptr)((char*)(mem) - 2*SIZE))

/* remove a memory block from its doubly linked list */
static inline void munlink(mblockptr bp)
{
  mblockptr forward = offsetToBlock(bp->fwd);
  mblockptr back    = offsetToBlock(bp->back);
  forward->back     = blockToOffset(back);
  back->fwd         = blockToOffset(forward);
}

/* split a block and place on the end of llist */
static inline void split(mblockptr bp, size_t offset)
{
  size_t leftOver = bp->size - offset;
  if (leftOver >= MINSIZE)
  {
    mblockptr bin   = FIRSTBIN + sizeToBin(leftOver);
    mblockptr head  = offsetToBlock(bin->fwd);
    mblockptr hback = offsetToBlock(head->back);
    mblockptr rest  = (mblockptr)((char*)(bp) + offset);
    
    setSize(rest,leftOver);
    /* link up */
    rest->back = blockToOffset(hback);
    rest->fwd  = blockToOffset(head);
    head->back = hback->fwd = blockToOffset(rest);
    
    /* adjust size of chunk to be returned */
    bp->size = *((int*)((char*)(bp) + offset - SIZE)) = offset;
  }
}

/* put block on end of llist, no split */
static inline void mlink(mblockptr bp)
{
  int binIndex    = sizeToBin(bp->size);
  mblockptr bin   = FIRSTBIN + (binIndex*sizeof(mblockptr));
  mblockptr head  = offsetToBlock(bin->fwd);
  mblockptr hback = offsetToBlock(head->back);

  bp->back   = blockToOffset(hback);
  bp->fwd    = blockToOffset(head);
  head->back = hback->fwd = blockToOffset(bp);
}

void *mm_malloc (size_t numBytes)
{
  /* worry about zero later */
  size_t    nb   = reqToSize(numBytes);  /* padded request size */
  int       binIndex = sizeToBin(nb);      /* index of corresponding bin */
  mblockptr bin = ((mblockptr*)FIRSTBIN)[binIndex];
  mblockptr ptr = offsetToBlock(bin->fwd);
  mblockptr tmp;

  int counter = 0;
  int coallesced = 0;

  /* Try a (near) exact match in own bin */
  /* clean out unusable but consolidatable chunks in bin while traversing */

  mblockptr nextblock = bin; /*sneaky way of making while loop work */

  while (ptr != nextblock) /* ISSUE */
  {
    if (ptr->size >= nb)
      goto found;
    else    /* attempt coallesce */
    {
      nextblock = offsetToBlock(ptr->fwd); /* save for next time */

      while (!inuse(tmp = prevBlock(ptr))) /* coallesce backward */
      {
        if (!coallesced) { coallesced = 1; munlink(ptr); }
        if (tmp == nextblock) nextblock = offsetToBlock(tmp->fwd);
        munlink(tmp);
        setSize(tmp, tmp->size + ptr->size);
        ptr = tmp;
      }
      
      while (!inuse(tmp = nextBlock(ptr))) /* coallesce forward */
      {
        if (!coallesced) { coallesced = 1; munlink(ptr); }
        if (tmp == nextblock) nextblock = offsetToBlock(tmp->fwd);
        munlink(tmp);
        setSize(ptr, ptr->size + tmp->size);
      }
      
      if (coallesced)
      {
        if (ptr->size >= nb)
        {
          /* make it ok to unlink() below */
          ptr->fwd = ptr->back = blockToOffset(ptr);
          goto found;
        }
        else
          mlink(ptr);
      }
      ptr = nextblock;
    }
  }

  while (bin+=sizeof(mblockptr) && ++counter <= NUMBINS)
  {
    if ( (ptr = offsetToBlock(bin->fwd)) != offsetToBlock(bin->back) )
      goto found;
  }

  /* Consolidate or sbrk */
  /* ptr = get more memory */
  if (ptr == 0) return 0;

 found:
  munlink(ptr);
  split(ptr,nb); 
  return blockToMem(ptr);
}

void mm_free (void *ptr)
{
  if (ptr != 0)
  {
    mblockptr p = memToBlock(ptr);
    /* frontlink(p); */
  }
}

