/*
 * test_malloc.c -- "test driver" for 15-213 Lab 2 malloc/free
 *                  implementations.
 *
 *                  Modify at will to test your implementation!
 *                  This file will not be turned in.
 */

#include <stdio.h>
#include <stdlib.h>

#include "malloc.h"

char *heap;
long int heap_size;

int main(int argc, char **argv)
{
    /* pointers to blocks allocated by L2_malloc */
    char *block_1, *block_2;

    /* create a heap to give init_malloc */
    heap_size = 256;
    heap = (char *)malloc(heap_size);

    /* have init_malloc set up the heap so we can start getting
     * blocks of memory */
    if (init_malloc(heap_size, heap) == -1) {
        fprintf(stderr, "Failed in init_malloc.\n");
        return -1;
    }

    /* L2_malloc and L2_free testing code */
    block_1 = L2_malloc(100);
    if (block_1 != NULL) {
        block_2 = L2_malloc(100);
        if (block_2 != NULL) {
            L2_free(block_2);
        }
        L2_free(block_1);
    }

    printf("Tests completed.\n");

    return 0;
}
