
/* Prototypes for the L2 routines you are writing in malloc.c */

/* (re)initialize the heap area passed in variable "heap", of length
 * "heap_size" bytes.  Also initialize any global variables used in
 * malloc.c */
int   init_malloc(unsigned long heap_size, char *heap);

/* Allocate a block of (at least) size bytes from the heap.
 * The return pointer should be a valid address aligned to 8 bytes (WDSZ),
 * or NULL */
void *L2_malloc(unsigned long size);

/* Return the allocated block starting at "block" to the pool of free blocks
 * in the heap. */
void  L2_free(void *block);


/* Possbly useful values (WDSZ == word size) */
#define WDSZ        (long)((sizeof(long int)))
#define WDSZ_MASK   (WDSZ-1)


/* team_struct -- for group identification */
typedef struct {
    char *member_1;
    char *andyid_1;
    char *member_2;
    char *andyid_2;
} team_struct;
