#!/usr/local/bin/perl5 -w
#!/usr/bin/perl

use FileHandle;

$gradelist = $ARGV[0];

sub trim_email {
    $addr = shift;
    if ($addr =~ /(.*)\@.*/) {
        return $1;
    }
    return $addr;
}

sub update_list {
    $file = shift;
    my $email1;
    my $email2;
    my $grade;

    open(MALLOCOUT, $file);
    while (<MALLOCOUT>) {
        if (/Email1: (.*)/) {
            $email1 = trim_email($1);
        }
        if (/Email2: (.*)/) {
            $email2 = trim_email($1);
        }
        if (/Total: (.*)/) {
            $grade = $1;
        }
    }
    close MALLOCOUT;

    if (!$email1 && !$email2) {
        print STDERR "MISSING EMAILS!!\n";
    }

    open(GRADELIST, ">>$gradelist");
    if ($email1) {
        print GRADELIST "$email1 $grade\n";
    }
    if ($email2) {
        print GRADELIST "$email2 $grade\n";
    }
    close(GRADELIST);
}

##
## Main program
##

$| = 1;

opendir DIR, ".";

rewinddir DIR;

while (defined($file = readdir DIR)) {
    if ($file =~ /.*\.output/) {
       update_list($file);
    }
}

closedir DIR;

