/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Mal_lock",
    /* First member full name */
    "Ameet Vaswani",
    /* First member email address */
    "anv",
    /* Second member full name (leave blank if none) */
    "Yashabh Sethi",
    /* Second member email address (blank if none) */
    "ysethi"
};


/* Strategy : Use explicit lists.
Every block of memory has the size of the block stored at the first and the last words in the block. These words also store the information whether or not the block is free by masking the left most bit in the first and the last words. The free blocks also have forward and backward pointer in the second and the third words. An explicit list of free blocks is maintained. The forward pointers in the free blocks point to the first words of the next block in the free list and the backward pointers point to the first word of the previous block in the free list.
*/



/* The initialization of the heap. The function reserves a word of memory for the pointer to the first free node and sets it to NULL. If there is insufficient memory in the heap, return value of -1 is returned, else 0 is returned */
int mm_init (void)
{
  
  
  int *p;


  if (dseg_hi - dseg_lo +1 ==0)
    {    
      p = mem_sbrk(4);    // p is the head of the free list
      *p = (int)NULL;
     
    }
  else
    return -1;

return 0;
  

}

/* This function allocated the required amount of memory from the heap. If the memory available in the heap is insufficient, appropriate message is displayed and NULL pointer is returned. Otherwise a (void *) pointer is returned, which points to the first byte of the allocated memory */
void *mm_malloc (size_t size)
{
  int * return_ptr=NULL;
  int * ptr = (int*)dseg_lo;      /* the pointer to the beginning of allocated heap memory */
  int * ptr_save;
  int size_diff ;
  int counter = 0;
  int size2;
  int size3 = 1;
  int flag =1;
  int flag2 = 0;

 if ((size != 0) && (size%8 != 0))     /* allign the size to 8 bytes */
   size2 = size+8 + (8 - size%8);  
 else
   size2 = size+8;
  
 while (1){
   counter = 0;
   if(*ptr!=(int)NULL)                 /*  => if the free list in not empty */
     {
       ptr =(int*)*ptr;
       flag=0;
       
       ptr_save = ptr;
       size_diff = ~(1<<31);     /* any comparably large value */
       
      while(ptr_save && counter < 400)   /* search the first 400 nodes in the free list for the best fit */
    {
      if ( ((*(ptr_save) - size2) < size_diff) && ( (*(ptr_save) - size2) >= 0 ))
	{
	  size_diff = *(ptr_save) - size2;
	  ptr = ptr_save;
	}
      ptr_save = (int *)*(ptr_save + 1);
      if (flag2 == 0)
	counter++;
    }
      
      /* at this stage, ptr points to the first words of the best fit block searched above */
      if((*(ptr) >= size2) &&(*(ptr) - size2<=8 ))   /* if the required size is within 513 bytes of the size of the best fit block, we allocate the entire block */
	{
	  return_ptr = (int*)(ptr);                   
	  if((int*)*(return_ptr+2)!= (int*)dseg_lo)          /* if the block is not the first node in the free list ... */
	    *((int*)*(return_ptr+2)+1) = *(return_ptr+1);    /* set the forward link of the previous block to the forward link of the current block */
	  else
	    *(int*)dseg_lo = *(return_ptr+1);    /* set the pointer to the first block in the free list to the header of the current block */
	  if((int*)*(return_ptr +1)!= NULL)        /* if the current block is not the last block in the free list .... */
	    *(((int*)*(return_ptr +1))+2) = *(return_ptr+2);   /* set the backward link of the next block to the backward link of the current block */
	  *(return_ptr + (*ptr)/4 - 1) = *ptr | 1;    /* set the footer of the current block to the size of the current block and mark it as allocated */
	  *return_ptr = *ptr | 1;       /* set the header of the current block to the size of the current block and mark it as allocated */
	  return_ptr = return_ptr + 1;  /* move the return_ptr to the next word ( where there actual data is to be stored ) */
	  return (void *)return_ptr;
	}
      else if ((*ptr)>= size2 )  /* if the difference between the required size and the size of the best fit block > 513 bytes, we split the best fit block and reinsert the remaining free space into the free list */
	{
	  *(ptr + (*ptr)/4 - 1) = size2 | 1;    /* set the footer of the new block to the size of the new block and mark it as allocated */
	  *ptr = *ptr -size2;      /* set the header of the current block to the size of the remaining free block */
	  *(ptr + (*ptr)/4 -1 ) = *ptr;  /* set the footer of the new free block to the size of the new free block */
	  *(ptr+(*ptr)/4) = size2 |1;  /* set the footer of the new block to the size of the new block and mark it as allocated */
	  return (void *) (ptr + (*ptr)/4 +1);  /* return the pointer to the beginning of the memory allocated for the actual data */
	}
	
    }

  /* allocating from heap */
 

  if((size >=48 && size <= 64)||(size >=112 && size <= 128)|| (size >= 224 && size <= 256)||(size >= 448 && size <= 512))    /* if the size of the required block is between 3/4 the previous multiple of 2 and next mulptiple of 2,then allocate the next multiple of 2 */
    {
      size3 = 32;
      while (size3 < size)
	{
	  size3 = size3 << 1;
	}

      size = size3;      
      
      if ((size != 0) && (size%8 != 0))
	size2 = size+8 + (8 - size%8);  
      else
	size2 = size+8;
    }
      
  return_ptr = mem_sbrk(size2);    /* allocate from heap */
  if (mem_usage() == -1 || return_ptr == NULL)  /* if insufficient memory in heap, then return NULL pointer */
    {
      if (flag2 == 1)
	{
	  printf("no space in heap\n");
	  return NULL;
	}
      else
	flag2 = 1;
    }

  *return_ptr = size2 | 1;     /* set header of newly allocated block */
  *(return_ptr + size2/4 - 1) = size2 | 1;   /* set footer of newly allocated block */
  return_ptr = return_ptr + 1;
  
  if (flag2 == 0)
  return (void *)return_ptr;
 }
}

void mm_free (void *ptr2)
{ 
  int size_ptr, size_next, size_prev, size_new;
  int *ptr_prev;
  int *ptr_next;
  int *temptr = (int*)ptr2;    
  int *ptr = (int*)ptr2;
  *(ptr-1) = *(ptr-1) - 1;   /* setting the last bits of the header and footer to zero to denote 'free' blocks*/
  *((ptr-1)+ *(ptr-1)/4 -1) = *(ptr-1);  
  
  temptr = temptr - 1;   /* moving temptr to the header of the block to be freed*/
  temptr = temptr + (*temptr)/4; /* moving temptr to the header of the block next to the block to be freed */

  if ((temptr<(int*)dseg_hi) && ( ((*temptr) & 1) == 0) && (( (ptr-2) > (int*)dseg_lo) && ( ((*(ptr-2)) & 1) == 0 )))
      {                                         /* coalescing when both the previous and the next block are  free */ 
	size_ptr = *(ptr-1);                    /* get the size of block to be freed */
	size_prev = *(ptr-2);                   /* get the size of previous block */
	size_next = *( (ptr-1) + *(ptr-1)/4);   /* get the size of next block */
	size_new = size_prev + size_ptr + size_next;   /* get the size of the coalesced block */
	ptr_next = ptr - 1  + size_ptr/4;              /* get the pointer to the header of the next block */
	ptr_prev = ptr - 1 - size_prev/4;              /* get the pointer to the header of the previous block */
	*ptr_prev = size_new;                          /* store header for the coalesced block */ 
	*( ptr_prev + size_new/4 - 1) = size_new;      /* store footer for the coalesced block */ 
	if ((int*)*(ptr_next + 1) != NULL)             /* if next block was not the last entry into the free list */
	  {
	   *( (int *)(* (ptr_next + 1)) + 2) = *(ptr_next + 2);  /* make the backward link of the block as the forward link of the next block to the backward link of the next block */ 
	  }
	if ((int*)*(ptr_next + 2) > (int *)dseg_lo)  /* if the backward link of the next block is not the first entry in the free list */
	  {
	    *( (int *)(* (ptr_next + 2)) + 1) = *(ptr_next + 1); /* make the forward link of the backward link of the next block as the forward link of the next block */
	  }
	else
	  {
	    * (int *)dseg_lo = *(ptr_next + 1); /* otherwise.... make the forward link of the next block as the first free block in the free list */
	  }
      }
	
	
  else if ( (temptr<(int*)dseg_hi) && ( ((*temptr) & 1) == 0))   /* checking that the next block is not out of heap, and the next block is free .... so that front coalescing is possible */
    {
      *(ptr-1) = *(ptr-1) + *(temptr) ;  /* set size to new free and sub 1 to remove the lsb flag */
      *ptr = *(temptr+1);     /* set forward link of new free */
      *(temptr + *(temptr)/4 - 1) = *(ptr-1);   /* set footer to new free */
      if((int*)*(temptr+1)!=NULL)
	*((int*)*(temptr+1)+2) =(int)(ptr-1);    /* set back pointer of front link of old free */
      temptr = (int *)*(temptr + 2); /* go to back link of old free */
      *(ptr+1) = (int)temptr;  /* set back link to new free */
      if(temptr ==(int*)dseg_lo)  
	*(temptr) = (int)(ptr-1);  
      else
	*(temptr+1) = (int)(ptr-1);
    }
  else
    {
      temptr = ptr;
      temptr = temptr - 2;
      if((temptr > (int*)dseg_lo) && ( ((*temptr) & 1) == 0 ))  /* checking that the previous block is not out of heap, and the previous block is free .... so that back coalescing is possible */
	{
	  temptr = temptr - *(temptr)/4 + 1;   /* move temptr to the head of previous block */
	  *temptr = *temptr + *(ptr-1) ;       /* set the new size to the header of the coalesced block */
	  *((ptr-1)+ *(ptr-1)/4 -1) = *temptr; /* set the new size to the footer of the coalesced block */ 
	}
      
      else                 /* if both the previous and next blocks were not free */
	{
	  *ptr = *(int*)dseg_lo;       /* add the freed block to the beginning of the free list */
	  if((int*)(*(int*)dseg_lo)!=NULL)    /* if there is something in the free list... the block is not the first entry to the list*/
	    *((int*)(*(int*)dseg_lo) + 2) = (int)(ptr-1); /* set the backward link of the first block of the list to the block to be inserted */
	  *(int*)(dseg_lo) = (int)(ptr-1);   /* add the freed block to the beginning of the free list */
	  *(ptr+1) = (int)(int*)dseg_lo; /* set the forward link of the block to dseg_lo*/
	}
    }
}
  
  

