/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

/* initial pages to request   */
#define NUM_PAGES 8

/* max position in leading pointers to heads of linked lists   */
#define ARRAY_MAX 32

#define PAGE_SIZE  mem_pagesize()

/* provides array-like access to heads of the linked lists  
Segregated List Implementation */
#define memarray(x) ((int*)(dseg_lo) + x )

/* masks out the "is allocated" bit of a sizeword */ 
#define sizemask(x) (x & 0xfffffffe) 

/* given a sizeword checks whether a the associated block is free */
#define isfree(x) (!(x & 1))

/* performs log2(x) to get memarray position */ 
#define cellpos(x) ((x>>30) + 30 + ~( !(x>>29) + !(x>>28) + !(x>>27) + !(x>>26) + !(x>>25) + !(x>>24) + !(x>>23) + !(x>>22) + !(x>>21) + !(x>>20) + !(x>>19) + !(x>>18) + !(x>>17) + !(x>>16) + !(x>>15) + !(x>>14) + !(x>>13) + !(x>>12) + !(x>>11) + !(x>>10) + !(x>>9) + !(x>>8) + !(x>>7) + !(x>>6) + !(x>>5) + !(x>>4) + !(x>>3) + !(x>>2) + !(x>>1) ))

team_t team = {
    /* Team name to be displayed on webpage */
    "Team 74",
    /* First member full name */
    "Paul Scheiblich",
    /* First member email address */
    "pauls",
    /* Second member full name (leave blank if none) */
    "Chang W Kim",
    /* Second member email address (blank if none) */
    "cwkim"
};

int *GetNonNull(int* pn);


int mm_init (void)
{
  int *tmp = NULL;
  int psize = 0;
  int i = 0;

  /* just a check in case of re-initialization */
  int getmem = NUM_PAGES * PAGE_SIZE - (dseg_hi - dseg_lo);

  /* if we can't get memory return -1 */
  
  if (getmem > 0)
    if( !mem_sbrk(getmem)) return -1;
  
  /* size of free memory */
  /* size always refers to size of allocatable memory plus the sizewords*/
  psize = (PAGE_SIZE * NUM_PAGES) - (ARRAY_MAX * 4);
  
  /*initialize to null */
  for (i=0; i<ARRAY_MAX; i++) 
    (int *)(*memarray(i)) = NULL;
  
  /* points to leading sizeword of giant free block */
  tmp = memarray(ARRAY_MAX);
  *tmp = sizemask(psize);
  
  /*setting pointers */
 (int *)(*(tmp+1)) = NULL;
 (int *)(*(tmp+2)) = NULL;

 /*sets tmp to trailing sizeword & initializes */
 tmp = ((int*)(dseg_lo + PAGE_SIZE*NUM_PAGES)) - 1;
 *tmp = sizemask(psize);

 /* puts block in appropriate memory location */
 (int *)(*memarray(cellpos( psize ))) = memarray(ARRAY_MAX);
   
 /* everything A-OK  */
 return 0;
}

/* starts at size category pn
   finds the first non-null memarry position, incrementing pn   */
int *GetNonNull(int* pn)
{
  int n = *pn;
  int *tmp = ((int *)*memarray(n));

  while (tmp == NULL) 
    {
      n++;
      if (n >= ARRAY_MAX) {
	*pn = n;
	return NULL;
      }
      tmp = ((int *)*memarray(n));
    }
  *pn = n;
  return tmp;
}

void *mm_malloc (size_t size)
{
  /* will hold the size of remainder of the block */ 
  int smallsize = 0;
  
  /* we fool around with these */
  int *tmp = memarray(0);
  int *foo = NULL;

  /* size plus 2 words for the size words, and 1 word for 8 byte alignment  */
  int newsize = size + 12;

  /* will point to the 1st size word of the block which we will allocate */
  int *retptr = NULL;

  /* a position in memarray */
  int pn = 0;
 
  /* number of new pages to add, if any */
  int newpages;

  /* combined size of those pages */
  int newpagesize;
 
  /* current dseg_hi */
  int *old_dseg_hi = (int *)dseg_hi;

 
  /* insures 8 byte alignment by rounding up */
  if ((newsize % 8) != 0) newsize += (8 - (newsize % 8)); 
  
  /* initialize pn */
  pn = cellpos(newsize);

  /* gets the first non-null position in memarray greater or equal the equivalence class for newsize  */
  tmp = GetNonNull(&pn);

  /* steps down that list, hopefully finds one */
  while (tmp != NULL) 
    {
      if (*tmp >= newsize) 
	{
	  retptr = tmp;
	  break;
	}
      tmp = ((int *)(*(tmp + 1)));
    } 
  
  /*if none was found, then any greater size will work */
  if (retptr == NULL) 
    {
      pn++;
      if (pn < ARRAY_MAX)  tmp = GetNonNull(&pn);
 
      

      if (tmp == NULL)     
	/* we didn't find a free block that was large enough */
	{
	  /* get new page(s) , make into a big block */
	 
	  /*  see how many pages we need   */
	  newpages = (newsize / PAGE_SIZE);
	  if ((newsize % PAGE_SIZE) != 0) newpages++;
	  
	  /* total new memory  */
	  newpagesize = newpages * PAGE_SIZE;

	  /* if we can't get enough return NULL */
	  if(! mem_sbrk(newpagesize) ) return NULL;

	  /* beginning of new memory  */
	  tmp = old_dseg_hi; 

	  /* set sizewords */
	  *tmp = (*(tmp + (newpagesize / 4) - 1)) = sizemask(newpagesize);
	
	  /* initialize internal pointers to NULL  */
	  (int *)(*(tmp + 1)) = (int *)(*(tmp + 2)) = NULL;	  
	}
      /* if we got one */
      retptr = tmp;
    } 

  
  if (retptr != NULL) 
    {
      tmp = retptr;
      
      /* if tmp is big enough to hold pointers */
      if ((*tmp) >= 16)
	{
	  
	  /* If previous data, previous data's forward equals this forward. */
	  if( (int *)(*(tmp +2)) != NULL) 
	    ((int *)*( ( (int*)(*(tmp + 2)) ) + 1)) = (int *)(*(tmp +1));
	  
	  /* If next data, next data's previous equals this previous. */
	  if( (int *)(*(tmp +1)) != NULL) 
	    ((int *)*( ( (int*)(*(tmp + 1)) ) + 2)) = (int *)(*(tmp +2));

	  /* if this data was in the memarray 
	     then next data goes into the array instead. */
	  if (tmp == ((int *)(*memarray(cellpos(*tmp))))) 
	   (int*)(*memarray(cellpos(*tmp))) = (int*)(*(tmp + 1));
	}

     /* smallsize contains the size of the leftover of current block 
	after allocating the requested amount. */
      smallsize = *tmp - newsize; 

      /* if there is a leftover */
      if (smallsize != 0) 
       {     
	 /* move the tmp pointer to the beginning of the leftover memory */
	 tmp = (tmp + (newsize / 4)); 
	 
	 /* set sizewords */
	 *tmp = *(tmp + (smallsize / 4) - 1) = sizemask(smallsize);
	 if (smallsize >= 16) 
	   {
	     /* the foo pointer holds the value in the memarray position */
	     foo = (int *)*(memarray(cellpos(*tmp)));
	     
	     /* if this was a head, and not NULL */
	     if (foo != NULL) 
	       /* old head's backpointer points to the new remainder */
	       (int *)*(foo + 2) = tmp;
	     
	     /* new's forward points to the old block*/
	     ((int*)(*(tmp+1))) = foo;

	     /* head is now tmp */
	     ((int*)(*memarray(cellpos(smallsize)))) = tmp;

	     /* backpointer of head should be NULL */
	     ((int*)(*(tmp+2))) = NULL;
	   }
       }
      /* set sizewords of return pointer, 
	 make sure to set "is allocated" bit */
     *retptr = *(retptr + (newsize / 4) - 1) = (newsize | 1);
     
     /* point to where the user can write */
     retptr += 2;
    }

  /* let them have the pointer */
  return retptr;
}


void mm_free (void *ptr)
{ 
  /* point head to the sizeword */
  int* head = ((int*) ptr) - 2;

  int* tmp = NULL;
  int pn = 0;

  /* datasize holds the size of the block */
  int datasize = sizemask(*head);

  /* point tail to end sizeword */
  int* tail = head +(datasize/4)-1;

  int smallsize = 0;
  int *foo = NULL;

  /* set "is allocated" bits to 0 */
  *head = sizemask(datasize); 
  *tail = sizemask(datasize);

  /* coalescing */
  if(head != memarray(ARRAY_MAX))
    {
      /* tmp points to previous sizeword */
      tmp = head - 1;
      if(isfree(*tmp))
	{
	  /* set size of block to be coalesced
	     increment datasize */
	  smallsize = (*tmp);
	  datasize += smallsize;
	  
	  /* set tmp to first sizeword */
	  tmp = tmp - (smallsize/4) + 1;
	  
	  /* if block to be assimilated has pointers */
	  if (smallsize >= 16)
	  {
	    /* splice out of list, see mm_malloc if curious */
	    foo = (int *)(*memarray(cellpos(smallsize)));
	    if (tmp == foo)  {
	      (int *)(*memarray(cellpos(smallsize)))  = (int*)(*(tmp + 1));
	    }
	    foo = (int *)(*(tmp + 2));
	    if( foo != NULL)  {
	      (int *)(*(foo + 1)) = (int *)(*(tmp + 1));
	    }
	    foo = (int *)(*(tmp + 1));
	    if(foo != NULL) {
	      (int *)(*(foo + 2)) = (int *)(*(tmp + 2));
	    }
	  }
	  /* set new starting sizeword */
	  head = tmp;
	}
    }

  if(tail != (int *) dseg_lo - 1)
    {
      /*look at first sizeword of previous block */
      tmp = tail + 1;
      if(isfree(*tmp))
	{
	  /* set size of block to be assimilated & increment total size */
	  smallsize = (*tmp);
	  datasize += smallsize;
	  
	  /* if it contains pointers */
	  if (smallsize >= 16)
	  {
	    /* splice it out*/
	    foo = (int *)(*memarray(cellpos(smallsize)));
	    if (tmp == foo)  {
	      (int *)(*memarray(cellpos(smallsize)))  = (int*)(*(tmp + 1));
	    }
	    foo = (int *)(*(tmp + 2));
	    if( foo != NULL)  {
	      (int *)(*(foo + 1)) = (int *)(*(tmp + 1));
	    }
	    foo = (int *)(*(tmp + 1));
	    if(foo != NULL) {
	      (int *)(*(foo + 2)) = (int *)(*(tmp + 2));
	    }
	  }

	  /* point tmp to new ending sizeword */
	  tmp = tmp + (smallsize/4) - 1;
	  tail = tmp;
	}
    }
  
  /* set sizewords */
  *head = *tail = datasize;

  /* stop if no pointers to set */
  if (datasize < 16) return;  

  /* set position */
  pn = cellpos(datasize);
  
  /* put at head of appropriate list, clean up pointers */
  foo = ((int*)(*memarray(pn)));
  ((int*)(*(head+1))) = foo;
  if(foo != NULL)   
    (int *)(*(foo+2)) = head;
  ((int*)(*(head+2))) = NULL;
  (int *)(*(memarray(pn))) = head;


  return;
}


