/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Wanderer",
    /* First member full name */
    "Nick Jong",
    /* First member email address */
    "nkj@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/* Implementation details:
 * The entire heap is partitioned into blocks, all at least four words in size,
 * with larger blocks containing four words plus a nonnegative even number of
 * words. Each block begins four bytes before an eight byte boundary. The first
 * and last word of each block contains the number of bytes between blocks. If
 * the block is allocated, the value is the negative of the true size.
 *
 * Note that the first and last words of the heap are not a part of any block.
 * The first word contains a pointer to the the head of a linked list of all
 * unallocated nodes. This linked list is maintained as a cyclical, doubly
 * linked list. The placement policy is next fit: mm_malloc finds the next
 * block in the list that is large enough to contain the requested amount of
 * memory, allocates the appropriate number of words, and sets the pointer to
 * the next block in the list. Whenever coalescing takes place, the coalesced
 * block becomes the new head of the list of unallocated blocks.
 */

/* pre-cond: heap has been initialized
 * post-cond: returns a pointer to the last block in the heap, unless the last
 *  block is allocated, in which case returns NULL
 */
char *tail_block() {
  int lastBlockSize = *(int *) ( dseg_hi - 7 );
  if( lastBlockSize < 0 )
    return NULL;
  else
    return dseg_hi - 7 - lastBlockSize;
}

/* pre-cond: last - first + 1 >= 8; last is on an eight byte boundary plus
 *  three; first is on a four byte boundary but not on an eight byte boundary
 * post-cond: creates a block spanning the memory from first to last
 */
char *create_block( char *first, char *last ) {
  /* size = (int) last - (int) first + 1 */
  /* space = size - 8  (for header and footer) */
  int space = last - first - 7;
  *(int *) first = space;                   /* set header */
  *(int *) ( last - 3 ) = space;            /* set footer */
  return first + 4;
}

/* pre-cond: block points to a block in the heap
 * post-cond: returns size of block if unallocated, 0 otherwise
 */
int block_size( char *block ) {
  int size;
  if(!block)
    return 0;
  size = *(int *) ( block - 4 );
  if( size > 0 )
    return size;
  else
    return 0;
}

/* pre-cond: block points to an unallocated block
 * post-cond: block is the new head of the free list
 */
void add_block(char *block) {
  char **head = (char **) dseg_lo;
  if(!block)                          /* adding null block */
    return;
  if(!(*head)) {                      /* free-list is empty */
    *(char **) block = block;         /* next pointer points to self */
    *(char **) ( block + 4 ) = block; /* prev pointer points to self */
    *head = block;
  }
  *(char **) block = *head;                            /* next = head */
  *(char **) ( block + 4 ) = *(char **) ( *head + 4 ); /* prev = head->prev */
  *(char **) ( *head + 4 ) = block;                    /* head->prev = block */
  *(char **) ( *(char **) ( block + 4 ) ) = block;     /* block->prev->next =*/
  *head = block;                                       /*              block */
}

/* pre-cond: block points to a member of a free list
 * post-cond: the block following the removed block is the head of the list
 */
void remove_block(char *block) {
  char **head = (char **) dseg_lo;
  if( *(char **) block == block ) {    /* singleton list */
    *head = NULL;
    return;
  }
  *(char **) ( *(char **) block + 4 ) = *(char **) ( block + 4 ); /* set next*/
  *(char **) ( *(char **) ( block + 4 ) ) = *(char **) block;     /* set prev*/
  *head = *(char **) block;
}

/* pre-cond: block is an unallocated block at least as large as size
 * post-cond: block points to an allocated block at least as large as size;
 *  returns a pointer to the remaining free space, or returns NULL if not
 *  enougn space remained to create another free block
 */
char *split_block( char *block, int size ) {
  int oldSize = block_size(block);
  if( oldSize - size < 16 )  /* not enough leftover space for a free block */
    size = oldSize;
  *(int *) ( block - 4 ) = -size;                       /* allocated header */
  *(int *) ( block + size ) = -size;                    /* allocated footer */
  if( oldSize != size ) {
    *(int *) ( block + size + 4 ) = oldSize - size - 8; /* leftover header */
    *(int *) ( block + oldSize ) = oldSize - size - 8;  /* leftover footer */
    return block + size + 8;
  } else
    return NULL;
}

/* pre-cond: block is an unallocated block not in the free list
 * post-cond: block is absorbed into the list; coalesced block is head of list
 */
void coalesce_block( char *block ) {
  int size = block_size(block);
  char **head = (char **) dseg_lo;

  /* coalesce right */
  if( block + size < dseg_hi - 7 ) {
    char *rightBlock = block + size + 8;
    int rightSize = *(int *) ( rightBlock - 4 );
    if( rightSize > 0 ) {
      remove_block(rightBlock);
      size += rightSize + 8;
      *(int *) ( block - 4 ) = size;
      *(int *) ( block + size ) = size;
    }
  }

  /* coalesce left */
  if( block > dseg_lo + 8 ) {
    int leftSize = *(int *) ( block - 8 );
    if( leftSize > 0 ) {
      block -= leftSize + 8;
      size += leftSize + 8;
      *(int *) ( block - 4 ) = size;
      *(int *) ( block + size ) = size;
      *head = block;
      return;
    }
  }
  
  add_block(block);
}

int mm_init ()
{
  if(!mem_sbrk(mem_pagesize()))
    return -1;
  /* Something has gone horribly wrong. */

  *(char **) dseg_lo = NULL;
  add_block(create_block( dseg_lo + 4, dseg_hi - 4 ));
  return 0;
}

void *mm_malloc(size_t size)
{
  char **head = (char **) dseg_lo;
  char *current = *head;
  int pgSz;
  int spaceNeeded;

  if( size == 0 )
    return NULL;

  size = ( size + 7 ) >> 3 << 3; /* round up to next multiple of 8 */

  if( current ) {
    do {
      /* search free-list for large enough block */
      if( block_size(current) >= size ) {
	remove_block(current);
	add_block(split_block( current, size ));
	return (void *) current;
      }
      current = *(char **) current;  /* goto next node */
    } while( current != *head );
  }
  
  /* get more room */
  current = dseg_hi - 3;
  pgSz = mem_pagesize();

  spaceNeeded= size - block_size(tail_block()) + 8;
  /* We need less space if there's already some space at end of heap. We need
     eight bytes more space, since we lose the last two words of the the last
     page requested to header and footer space. */
  spaceNeeded += pgSz - 1;  /* For rounding purposes. */
  spaceNeeded = spaceNeeded / pgSz * pgSz;

  if(!mem_sbrk( spaceNeeded ))
    return NULL;
  coalesce_block(create_block( current, dseg_hi - 4 ));
  current = *head; /* head of list is now coalesced block */
  remove_block(current);
  add_block(split_block( current, size ));
  return (void *) current;
}

void mm_free(void *ptr) {
  int size;
  if(!ptr)
    return;
  size = -( *(int *) ( ptr - 4 ) );
  *(int *) ( ptr - 4 ) = size;
  *(int *) ( ptr + size ) = size;
  coalesce_block(ptr);
  return;
}
