/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "the ubiquitous state of foobar",
    /* First member full name */
    "Lee Sheng",
    /* First member email address */
    "lsheng",
    /* Second member full name (leave blank if none) */
    "Matt McGrath",
    /* Second member email address (blank if none) */
    "mmcgrath"
};


int mm_init (void)
{
    /* get initial page */
    if (mem_sbrk(mem_pagesize()) == NULL) return -1;

    /* point the value in dseg_lo to first possibly available memory */
    *((int*)dseg_lo) = (int) dseg_lo + 4;

    /* set boundary tags on initial page */
    *((int*)(dseg_lo + 4)) = *((int*)(dseg_hi - 7)) = (mem_pagesize() - 16);

    return 0;
}

void *mm_malloc (size_t size)
{
    int ps = mem_pagesize();

    if (size == 0) return NULL;

    /* 8-align size */
    size = ((size + 7) / 8) * 8;

    /* point the value in dseg_lo to first possibly available memory */
    *((int*)dseg_lo) = (int) dseg_lo + 4;

    /* while looking within allocated heap */
    while (*((int*)dseg_lo) < (((int)dseg_hi) - 7))
      {
        /* look for a free block that's big enough */
        if (!(*((int*)(*((int*)(dseg_lo)))) & 1) && (size <= *((int*)(*((int*)(dseg_lo)))) )) {
          if (size != (*((int*)(*((int*)(dseg_lo)))))) {
            *((int*)(*((int*)(dseg_lo)) + (*((int*)(*((int*)(dseg_lo))))) + 4)) = *((int*)(*((int*)(dseg_lo)))) - size - 8;
            *((int*)(*((int*)(dseg_lo)) + size + 8)) = *((int*)(*((int*)(dseg_lo)))) - size - 8; 
            }
            *((int*)(*((int*)(dseg_lo)) + size + 4)) = size + 1;
            *((int*)(*((int*)(dseg_lo)))) = size + 1;
          return((void*)(*((int*)(dseg_lo)) + 4));
        }

        /* move to the next block */
        *((int*)dseg_lo) += ((*((int*)(*((int*)(dseg_lo))))) & -2) +8;
      }

    /* 
     * not enough space in current heap pages, 
     * so allocate an integer number of them if possible
     */
    *((int*)dseg_lo) = (int) dseg_hi - 3;

    /* if out of memory, return NULL */
    if (mem_sbrk((size / ps + 1) * ps) == NULL) return NULL;

    /* put a 0-byte free space across the boundary */
    *((int*)(*(((int*)dseg_lo)))) = *((int*)(*(((int*)dseg_lo))) + 1) = 0;

    /* fill in the tags on the new space */
    if (((size + 16) % ps) != 0) {
    *((int*)(dseg_hi - 7)) = (size / ps + 1) * ps - 24 - size;
    *((int*)(dseg_hi - 3 - ((size / ps + 1) * ps - size) + 16)) =
      (size / ps + 1) * ps - 24 - size;
    }
    *((int*)(dseg_hi - 3 - ((size / ps + 1) * ps - size) + 12)) = size + 1;
    *((int*)(dseg_hi - 3 - ((size / ps + 1) * ps) + 8)) = size + 1;
    return((void*)(*((int*)dseg_lo) + 12));
}

/* please, for the love of God, don't free unallocated memory! */
void mm_free (void *ptr)
{
  /* mark the block free */
  *((int*)(ptr - 4)) = *((int*)(ptr - 4)) & -2;
  *(((int*)(ptr - 4)) + (*((int*)(ptr - 4)) -1) / 4 + 2) = *((int*)(ptr - 4));
  
}

