
/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define NUM_OF_BIN 110 
#define INIT_HEAP_SIZE 484


/*****************************************************
	         Team Information					    
*****************************************************/
team_t team = {
    /* Team name to be displayed on webpage */
    "Whatever",
    /* First member full name */
    "Xin Zhao",
    /* First member email address */
    "xin",
    /* Second member full name (leave blank if none) */
    "Hiu Yu Lo",
    /* Second member email address (blank if none) */
    "hlo"
};


/******************************************************
						     
Brief explanation for the datastructure in our program:

The following diagram is the basic structure of a free block:
 (Notataion: s - size of the current block
             pa - last bit of integer size which is used to indicate if 
	          the previous block are free (0)/allocated (1)
	     fa - last bit of integer size which is used to indicate if 
	          the following block are free (0)/allocated (1)
	     f - forward pointer points to the next free block in the same class
	     b - backward pointer points to the previous free block in the same class
	     d - memory return to user to use

  | s + pa | f | b |     d     | s + fa |

The following diagram is the basic structure of an allocated block:
  | s + pa |         d         | s + fa |

  * Note that the allocated block don't have any memory for the forward and backward
  pointers, so that more memory can be used to store data. Forward and backward
  pointers is set only when an allocated block is freed
  ** Note that the user heap is defined as the memory allocated excluding the part
  allocated for management purpose (Total memory - INIT_HEAP_SIZE)

Brief explanation for the function:

mm_initial: Initializing 
getRange: Free blocks are classified into different classes
add: A newly created block is added to free list and the forward and backward
     pointers are set at this function
search: Search for availble free block from free lists for allocating 
        memory for the user
split: If a larger free block is found for allocating memory,
       a splitting operation is need, so that one part of the splitted
       memory is returned to the user, and the other part is returned 
       to free list
mm_malloc: By using search, split, and add functions, return a pointer of
           memory which the user can use
mm_free: Free an allocated memory by coalescing the previous or following 
         blocks if they are free. Insert the newly created free block to 
	 an appropiate free list by using add function

******************************************************/



/******************************** mm_init * ******************************/

/******************************************************
Required Initializing function used to request memory
and allocate the free list head pointers 
******************************************************/
int mm_init (void)
{
  int **head = (int **) dseg_lo;
  int i = 0;

  if (mem_sbrk(INIT_HEAP_SIZE) == NULL)   
    return -1;

  for (i=0; i <= NUM_OF_BIN; i++)
      head[i] = NULL;

  /* indicating the end of the management area */
  *((int *)(dseg_hi-3)) = 1;   
   
  return 0;
}



/******************************** mm_malloc ******************************/

/******************************************************
Input an integer (the requested size of memory by user), and 
return the class number of the free block 					
******************************************************/
inline int getRange(int n)
{
  if (n <= 512)
    return n/8;
  else if (n <= 2048)
    return (n-512)/64 + 65;
  else if (n <= 8192)
    return (n-2048)/512 + 89;
  else if (n <= 32768)
    return (n-8192)/4096 + 101;
  else if (n <= 131072)
    return (n-32768)/32768 + 107;
  else 
    return 110;
}


/******************************************************
add is used to insert a free block into its appropriate
class free list 
******************************************************/
void add(int * add_block)
{
  int block_size = *add_block & 0xfffffffe;
  int index = getRange(block_size);
  int ** head_ptr = (int **)dseg_lo+index;

  *((int **)add_block+1) = *head_ptr;
  *((int **)add_block+2) = (int *)head_ptr;
  
  if (*head_ptr != NULL)
    *((int **) *head_ptr + 2) = add_block;
  *head_ptr = add_block;
}


/******************************************************
delete removes a free block from a free list 
******************************************************/
void delete(int * block_head)
{
  int * prev = *((int **) block_head + 2);
  int * next = *((int **) block_head + 1);
  int dist_from_head = ((int) prev -(int)dseg_lo)/4;

  /* Special case:
     the block is at the beginning of the list */
  if (dist_from_head <= NUM_OF_BIN)
    {
      *((int **) dseg_lo + dist_from_head) = next;
      if (next != NULL)
	  *((int **) next + 2) = (int *) dseg_lo + dist_from_head;
    }     
  /* Normal cases */
  else
    {
      *((int **) prev + 1) = next;
      if (next != NULL)
	*((int **) next + 2) = prev;
    }
}


/****************************************************** 
Split a block into two smaller blocks if its size is larger than 
(16+user_request).  it returns a pointer to the desired block, and
adds the other one to the free lists.
******************************************************/
int * split (int size, int * block_head)
{
  int block_size = *block_head;
  int isHead;
  int isLast = (((int) (block_head + block_size/4 - 1) + 3) >= (int) dseg_hi); 
  int * end = block_head + *block_head/4 - 1;
  int * split_block;
  int split_size = (*block_head & 0xfffffffe) - size;

  /* remove this block from the free lists */
  delete(block_head);  
  
  if (split_size < 16)        
    /* equal size block found || split block too small */
    {
      *(block_head-1) = *(block_head-1) | 1;
      if (!isLast)
	*(block_head+*block_head/4) = *(block_head+*block_head/4) | 1;

      return block_head;   
    }
  else                        
    /* else, split needed */
    {

      /* divide the big block into two smaller blocks 
	 set the size fields of each new block */

      isHead = ((int) ((char *) block_head - 1)) < ((int) dseg_lo + INIT_HEAP_SIZE);

      if (!isHead && !isLast)                       /* the block is not the first block nor the */	           
	{                                           /* the last block of the user heap.         */

	  /* set bits, and adjust pointers */
							 
	  split_block = block_head + size/4;        
	  *split_block = split_size | 1;
	  *(split_block-1) = size;
	  *end = split_size | 1;
	  *block_head = *block_head - split_size; 
	  *(block_head-1) = *(block_head-1) | 1;
	}
      else
	if (isHead && isLast)                       /* the block is the first and the last block */
	  {                                         /* of the user heap.                         */

	    /* set bits, and adjust pointers */	    

	    split_block = block_head + size/4;
	    *split_block = split_size | 1;
	    *(split_block-1) = size;
	    *end = split_size | 1;
	    *block_head = *block_head - split_size; 
	  }
      else
	{
	  if (isHead)                               /* the block is the head, but not the end */
	    {

	      /* set bits, and adjust pointers */

	      split_block = block_head + size/4;
	      *split_block = split_size | 1;
	      *(split_block-1) = size;
	      *end = split_size | 1;
	      *block_head = *block_head - split_size; 
	      *(block_head-1) = *(block_head-1) | 1;
	    }
	  if (isLast)                                /* the block is the end, not the head */
	    {

	      /* set bits, and adjust pointers */

	      split_block = block_head + size/4;
	      *split_block = split_size | 1;
	      *(split_block-1) = size;
	      *end = split_size | 1;
	      *block_head = *block_head - split_size; 
	      *(block_head-1) = *(block_head-1) | 1;
	    }
	}

      /* add the extra block to the free block list */
      add(split_block);

      return block_head;
    }
}


/****************************************************** 
Search for a free block of size >= adjusted size in list[index]
it returns the pointer to the head address if it found a free block, 
NULL otherwise.  the pointer returned by split is pointing to the boundary
tag instead of the user_allowed_starting_point.
******************************************************/
inline int * search(int size, int index)
{
  int *cHead = *((int **)dseg_lo + index);

  while (cHead != NULL)
    {
      if (*cHead >= size)
	return cHead;
      else
	cHead = *((int **) cHead + 1);
    }
  return NULL;
}


/******************************************************
mm_malloc:
1. adjust the size given by the user.
2. search for a free block that is able to satisfy the request.
3. if such block is found, it gets processed; otherwise, we increase the heap size.
4. return the pointer
******************************************************/   
void *mm_malloc (size_t size)
{
  int index = 0;
  int * result = NULL;
  int adjusted_size = size + 8;
  int * new_block;
  int prev_size, prev_is_alloc;
  char * old_hi = dseg_hi;
  int * prev;


  /* pad to 8 && add 8 bytes for information storage */
  if (adjusted_size % 8 != 0) 
    adjusted_size = adjusted_size + 8 - adjusted_size % 8;

  /* find an appropriate index */
  index = getRange(adjusted_size);
  
  /* search for a free block of size = adjusted_size */
  while(index <= NUM_OF_BIN)
    {
      result = search(adjusted_size, index);
      if (result != NULL)
	break;
      index++;
    }

  /* process a block - split if necessary */
  if (result != NULL)
      return split(adjusted_size, result)+1;  
  else
    {

      /* failed to find a block that is big enough */

      prev_size = (*((int *)(old_hi-3))) & 0xfffffffe;
      prev_is_alloc = (*((int*)(old_hi-3) - prev_size/4)) % 2;

      if (!prev_is_alloc)            /* previous block is free, do coalescing */
	{
	  /* delete last block */
	  prev = (int *) (old_hi - 3) - prev_size/4 + 1;
	  delete(prev);

	  /* allocate new memory, and set the bits of the new block */
	  if (!mem_sbrk(adjusted_size - prev_size)) return NULL;
	  new_block = (int *) (old_hi - 3)-prev_size/4+1; 
	  *(new_block-1) = *(new_block-1) | 1;
	  *new_block = adjusted_size | 1;
	  *(new_block+*new_block/4-1) = *new_block;

	  return (void *)(new_block+1);
	}                           
      else                           /* previous block is not free */ 
	{
	  /* allocate new memory, and set the bits of the new block */ 
	  if (!mem_sbrk(adjusted_size)) return NULL;
	  new_block = (int *) (old_hi+1);
	  *new_block = adjusted_size | 1;
	  *((int *)(dseg_hi-3)) = *new_block;

	  return (void *)(new_block+1);
	}
    }

  return NULL;
}


/************************* mm_free ****************************************/

/******************************************************
Function mm_free does the following tasks:
1. If the previous block is free, 
   Coalescing the previous free block with the current block
2. If the following block is free, 
   Coalescing the following block with the current block
3. Adjusting the new pointer, and the size of the block
4. Insert the block into the appropiate class free list by using 
   function add.
******************************************************/
void mm_free (void *ptr)
{

  int * block_head = (int *) ptr - 1;
  int block_size = *block_head & 0xfffffffe;
  int isHead = ((int) ((char *) block_head - 1)) < ((int) dseg_lo + INIT_HEAP_SIZE);
  int isLast = (((int) (block_head + *block_head/4 - 1) + 3) >= (int) dseg_hi);
  int *prev, *next;
  int prev_size, next_size;
  int prevAlloc, nextAlloc;

  if (!isHead && !isLast)                          /* the block is not the first nor the last block */
    {                                              /* of the user heap                              */
      prevAlloc = *block_head % 2;
      nextAlloc = *(block_head + *block_head/4 - 1) % 2;

      prev_size = *(block_head-1) & 0xfffffffe;
      next_size = *(block_head+*block_head/4) & 0xfffffffe;

      if (!prevAlloc)   /* its previous is free, do coalescing & update info */
	{
	  prev = block_head - prev_size/4;
	  delete(prev);
	  block_head = prev;   /* the head has changed */
	  *block_head += block_size;
	  *(block_head + *block_head/4 - 1) = *block_head | 1;
	  *(block_head-1) = *(block_head-1) & 0xfffffffe;
	  *(block_head + *block_head/4) = *(block_head + *block_head/4) & 0xffffffffe;
	}               
      else             /* its previous is not free, update info only */  
	{	  
	  *(block_head + block_size/4) = *(block_head + block_size/4) & 0xffffffffe;
	  *(block_head) = *(block_head) | 1;
	  *(block_head-1) = *(block_head-1) & 0xfffffffe;
	}

      if (!nextAlloc)  /* its next is free, do coalescing & update info */
	{	  
	  next = (block_head + *block_head/4);
	  delete(next);
	  *block_head += next_size;
	  *(block_head + *block_head/4 - 1) = *block_head | 1;
	}

      /* 
	 unneccesary to update info if next is not free since we assumed the next is 
	 not free at the beginning                                                
      */
    }
  else 
    if (isHead && isLast)                           /* the block is the head and the end of the user heap */
      {
	/* update info */
	*(block_head-1) = *(block_head-1) & 0xfffffffe;       	
      }
  else
    if (isHead)                                     /* the block is the head, but not the end */ 
      {
	nextAlloc = *(block_head + *block_head/4 - 1) % 2;
	*(block_head-1) = *(block_head-1) & 0xfffffffe;       		
	if (!nextAlloc)     /* if next is free, do coalescing */
	  {
	    next = (block_head + *block_head/4);
	    delete(next);
	    next_size = *(block_head+*block_head/4) & 0xfffffffe;
	    
	    *block_head += next_size;
	    *(block_head + *block_head/4 - 1) = *block_head | 1;
	  }
	else
	    *(block_head+*block_head/4) = *(block_head+*block_head/4) & 0xfffffffe;
      }
    else 
      if (isLast)                                   /* the block is the end, but not the head */
	{
	  prevAlloc = *block_head % 2;
	  if (!prevAlloc)   /* if previous is free, do coalescing */
	    {
	      prev = block_head - *(block_head-1)/4;
	      delete(prev);
	      block_size = *(block_head) & 0xfffffffe;
	      block_head = prev;
	      *block_head = (*block_head+block_size) | 1;
	      *(block_head + *block_head/4 - 1) = *block_head | 1;
	    }
	  else
	      *(block_head-1) = *(block_head-1) & 0xfffffffe;
	}

  /* add the block back to the free lists */
  add(block_head);
}
