/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *


 The data structure for this program is very simple.
 We have a list of blocks, each block has a header and a 
 footer each of size 8 bytes. The first in both
 the header and footer holds the size of the block. The
 next 4 bytes in the header and footer holds the allocated
 flag. Malloc traverses through the whole list in linear time
 checking all blocks. When it finds a block of equal or greater
 size, it allocates it (first fit). It then uses backward and
 forward coalescing to free a block. The linear search is
 VERY slow...but that's what we got to work. I had a
 version that used doubly linked lists and only traversed
 through allocated blocks, but it never worked quite right.
 
 */



#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"
 
team_t team = {
    /* Team name to be displayed on webpage */
    "kill -9 15213",
    /* First member full name */
    "Lev Shvarts",
    /* First member email address */
    "lshvarts",
    /* Second member full name (leave blank if none) */
    "Ed Neto",
    /* Second member email address (blank if none) */
    "eneto"
};


/* Initializes malloc */
int mm_init (void)
{

  void *head;
  int pagesize = mem_pagesize();

  /* Allocates an initial block of size pagesize */
  if (mem_usage() != 0) {
    head = mem_sbrk(pagesize);
    if (head == NULL) {return -1;}
    else {
      
      /* Set allocated header flag to 0 (not allocated) */
      *(long *)(head + 4) = 0;
      
      /* Set block size in header */
      *(long *)(head) = pagesize;

      /* Set block size in footer */
      *(long *)(head + pagesize - 8) = pagesize;

      /* Set allocated footer flag to 0 (not allocated) */
      *(long *)(head + pagesize - 4) = 0;
    }
  }

  return 0;
}

/* Given a pointer to a block, return its size */
long getblocksize(void *p)
{
  return (*(long *)(p - 8));
}

/* Sets the size field in the header and footer */
void setblocksize(void *p, long size)
{
  *(long *)(p - 8) = size;
  *(long *)(p + size - 16) = size;
}

/* Checks whether block is allocated or not */
long isalloc(void *p)
{
  return ((*(long *)(p - 4)) == 1);
}

/* Sets allocated flag in header and footer */
void setalloc(void *p, long a)
{
  *(long *)(p - 4) = a;
  *(long *)(p + getblocksize(p) - 12) = a;
}

/* Returns a pointer to a block given its size.
   If it fails, it returns 0 */
void *mm_malloc (size_t size)
{

  int pagesize = mem_pagesize();
  long a, oldsize;
  int newblock = 0;

  /* Initialize current pointer to first block */
  char *cp = dseg_lo + 8;
  
  /* If user enters 0 for size, return 0 */
  if (size == 0) return 0;


  /* Take care of byte alignment. 
     If size not a multiple of 8, make it so.
     Also adds 16 bytes: 8 for header, 8 for footer
   */
  a = size - (size % 8);

  if (size % 8) 
    a = a + 8;
  
  a = a + 16;

  /* Loops through whole list and allocates the first block that
     fits. */
  while (1) {

    /* Get size of current block */
    oldsize = getblocksize(cp);

    /* If block size >= size we want and it is free,
       allocate it */
    if ((oldsize >= a) && (!isalloc(cp))) {
      setalloc(cp, 1);

      /* If difference in size div. by 8 is greater than 2,
	 then we have at least 24 bytes left over, which we
	 can create a free block out of.
      */
      if (((oldsize - a) / 8) > 2) {
	/* Set allocated block to size a */
	setblocksize(cp, a);
	setalloc(cp,1);
	
	/* Make new free block of size oldsize - a */
	setblocksize(cp + a, oldsize - a);
	setalloc(cp + a, 0);
      }

      /*
      printf("allc - cp=%p, a=%d, dhi=%p ca=%d pa=%d na=%d d2=%d\n"
	     , cp, a, dseg_hi, *(long *)(cp-4), 
	     ((long)(cp-8) > (long)dseg_lo) ? *(long *)(cp - 12) : -1,
	     ((long)(cp+a-8) < (long)dseg_hi) ? *(long *)(cp + a - 4) : -1,
	     newblock);
	     */

      return cp;
    }
    else
      /* If block is no good, try the next one */
      cp = cp + oldsize; 
    
    newblock = 0;    
    /* If we hit the heap boundary at this point, there is not
       enough space in heap for block of requested size. Increase
       the heap accordingly */
    if ( ((((long)cp - 8)) >= (long)dseg_hi)  )

      /* Keep increasing heap until new block is of at least
         size a */
      while (newblock < a){
	
	if (mem_sbrk(pagesize)) {
	  newblock = newblock + pagesize;
	}
	else
	  /* return 0 if sbrk fails to allocate more memory */
	  return 0; 
	
	/* create new free block with the added heap space */
	setblocksize(cp, newblock);
	setalloc(cp,0);
      }
  }
}

/* Checks the block immediately behind and in front of
   a given block. If either is free, it combines them */
void coalesce(void *p)
{

  long prevsize, nextsize, psize;

  psize = getblocksize(p);
    
  /* If this isn't the last block on the heap,
     check to see if block in front is free */
  if ((long)(p + psize - 8) < (long)dseg_hi)

    /* If block is free, combine them */
    if (*(long *)(p + psize - 4) == 0) {
      nextsize = *(long *)(p + psize - 8);
      psize = psize + nextsize;
      setblocksize(p,psize);
      setalloc(p,0);
    }  

  /* If this isn't the first block on the heap,
     check to see if block behind is free */
  if ((long)(p - 8) > (long)dseg_lo)

    /* If block is free, combine them */
    if (*(long *)(p - 12) == 0) {
      prevsize = *(long *)(p - 16);
      (long)p = (long)(p - prevsize);
      psize = prevsize + psize;
      setblocksize(p,psize);
      setalloc(p,0);
    }
}

/* Calls coalesce to free a block */
void mm_free (void *ptr)
{
 
  /* First free the block in case both blocks
     behind and in front are allocated */
  setalloc(ptr, 0);

  /* Try to coalesce */
  coalesce(ptr);

}

