/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Jesiatha",
    /* First member full name */
    "Eric Heutchy",
    /* First member email address */
    "eheutchy",
    /* Second member full name (leave blank if none) */
    "Ethan Tira-Thompson",
    /* Second member email address (blank if none) */
    "ejt"
};

#define ASIZE 8
#define HEAD 16

#define ALIGN(n) ((n + ASIZE - 1) & (~(ASIZE - 1)))
#define MEM4(n) ((unsigned int*)n)
#define MEM1(n) ((unsigned char*)n)
#define MEMVALID(n) (((unsigned int*)n)[0])
#define MEMPREV(n) (((unsigned int*)n)[1])
#define MEMNEXT(n) (((unsigned int*)n)[2])
#define MEMSIZE(n) (((unsigned int*)n)[3])


int mm_init (void)
{
	int size;
	if ((dseg_hi < dseg_lo) || ((int)dseg_hi - (int)dseg_lo < HEAD))
	{
		size = ALIGN(HEAD);
		mem_sbrk(size + (int)dseg_lo - (int)dseg_hi);
	}
	else
	{
		size = dseg_lo - dseg_hi;
	}
	MEMVALID(dseg_lo) = ~0;
	MEMPREV(dseg_lo) = 0;
	MEMNEXT(dseg_lo) = 0;
	MEMSIZE(dseg_lo) = size;
    return 0;
}

void *mm_malloc (size_t size)
{
	void *memory;
	void *prev;
	void *best = NULL;
	void *split;

	size = ALIGN(size + HEAD);
	for (memory = dseg_lo; 0 != MEMNEXT(memory); MEM1(memory) += MEMSIZE(memory))
	{
		if ((0 == MEMVALID(memory)) && (MEMSIZE(memory) >= size))
		{
			if ((NULL == best) || (MEMSIZE(memory) < MEMSIZE(best)))
			  best = memory;
		}
	}
	if ((0 == MEMVALID(memory)) && (MEMSIZE(memory) >= size))
	{
		if ((NULL == best) || (MEMSIZE(memory) < MEMSIZE(best)))
		  best = memory;
	}

	if (NULL != best)
	{
		if (MEMSIZE(best) > size + HEAD)
		{ // split
			split = MEM1(best) + size;
			if (0 != MEMNEXT(best))	MEMPREV(MEMNEXT(best)) = split;
			MEMVALID(split) = 0;
			MEMNEXT(split) = MEMNEXT(best);
			MEMPREV(split) = best;
			MEMSIZE(split) = MEMSIZE(best) - size;
			MEMSIZE(best) = size;
			MEMNEXT(best) = split;
		} // split
		MEMVALID(best) = ~0;

		return MEM1(best) + HEAD;
	}

	prev = memory;
	memory = dseg_hi;
	size += 0;
	if (NULL == mem_sbrk(size)) return NULL;
	MEMSIZE(memory) = size;
	MEMVALID(memory) = ~0;
	MEMPREV(memory) = prev;
	MEMNEXT(prev) = memory;
	MEMNEXT(memory) = 0;
	return memory + HEAD;
}

void mm_free (void *ptr)
{

	ptr = MEM4(ptr) - 4;

	if ((0 != MEMNEXT(ptr)) && (0 == MEMVALID(MEMNEXT(ptr))))
	{
		MEMSIZE(ptr) += MEMSIZE(MEMNEXT(ptr));
		MEMNEXT(ptr) = MEMNEXT(MEMNEXT(ptr));
	}

	if ((0 != MEMPREV(ptr)) && (0 == MEMVALID(MEMPREV(ptr))))
	{
		MEMSIZE(MEMPREV(ptr)) += MEMSIZE(ptr);
		MEMNEXT(MEMPREV(ptr)) = MEMNEXT(ptr);
	}

	MEMVALID(ptr) = 0;
}

