/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Jesiatha",
    /* First member full name */
    "Eric Heutchy",
    /* First member email address */
    "eheutchy",
    /* Second member full name (leave blank if none) */
    "Ethan Tira-Thompson",
    /* Second member email address (blank if none) */
    "ejt"
};

#define ASIZE 8
#define HEAD 16

#define ALIGN(n) ((n + ASIZE - 1) & (~(ASIZE - 1)))
#define MEM4(n) ((unsigned int*)n)
#define MEM1(n) ((unsigned char*)n)
#define MEMVALID(n) (((unsigned int*)n)[0])
#define MEMPREV(n) (((unsigned int*)n)[1])
#define MEMNEXT(n) (((unsigned int*)n)[2])
#define MEMSIZE(n) (((unsigned int*)n)[3])


int mm_init (void)
{
	int size;
	printf("Init Hi, Init Lo = %x %x\n", dseg_hi, dseg_lo);
	if ((dseg_hi < dseg_lo) || ((int)dseg_hi - (int)dseg_lo < HEAD))
	{
		size = ALIGN(HEAD);
		mem_sbrk(size + (int)dseg_lo - (int)dseg_hi);
	}
	else
	{
		size = dseg_lo - dseg_hi;
	}
	MEMVALID(dseg_lo) = ~0;
	MEMPREV(dseg_lo) = 0;
	MEMNEXT(dseg_lo) = 0;
	MEMSIZE(dseg_lo) = size;
    return 0;
}

void *mm_malloc (size_t size)
{
	void *memory = dseg_lo;
	void *prev;

	printf("Size = %x\n", size);

	size = ALIGN(size + HEAD);
	while (0 != MEMNEXT(memory))
	{
		if (0 != (MEMVALID(memory)) || (MEMSIZE(memory) < size))
		{
			if (0 == MEMSIZE(memory)) exit(0);
			MEM1(memory) += MEMSIZE(memory);
			//printf("Next\n");
		}
		else
		{
			printf("Succeeded\n");
			MEMVALID(memory) = ~0;
			return MEM1(memory) + HEAD;
		}
	}
	printf("Alloc more\n");
	prev = memory;
	memory = dseg_hi;
	if (NULL == mem_sbrk(size)) return NULL;
	MEMSIZE(memory) = size;
	MEMVALID(memory) = ~0;
	MEMPREV(memory) = prev;
	MEMNEXT(prev) = memory;
	MEMNEXT(memory) = 0;
	return memory + HEAD;
}

void mm_free (void *ptr)
{

	printf("Freeing - %x\n", ptr);

	MEMVALID(ptr) = 0;
}

