/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>


#include "memlib.h"
#include "malloc.h"

#define PAGE_SIZE 4096
#define INIT_PAGE_SIZE PAGE_SIZE
#define ALLOCFLAG 1
#define false 0
#define true 1

unsigned *last = NULL;
unsigned **array;
int last_is_active;
int just_coalesced;
int op;

team_t team = {
    /* Team name to be displayed on webpage */
    "CowPants44",
    /* First member full name */
    "Jason Liszka",
    /* First member email address */
    "jliszka",
    /* Second member full name (leave blank if none) */
    "Dave Heine",
    /* Second member email address (blank if none) */
    "dheine"
};



int log2 (unsigned x)
{
  int total = 0;
  x >>= 1;
  while (x != 0) {
    total++;
    x >>= 1;
  }
  return total;
}


int mm_init (void)
{
  int i;
  int *g;

  g = mem_sbrk(INIT_PAGE_SIZE);

  if (!g) {
    printf("***mem_sbrk() returned NULL\n");
    return -1;
  }
 
  if ((i = mem_usage()) != INIT_PAGE_SIZE-1) {
    printf("mem_usage() is not %d, is %d", INIT_PAGE_SIZE, i);
    return -1;
  }

  array = (unsigned**)dseg_lo;
  for(i=0; i < 32; i++)
    *(array+i) = NULL;
  
  *(array+log2((INIT_PAGE_SIZE-32)/4)) = (unsigned*)(array + 32);
  *(array+32) = (unsigned)NULL;
  *(array+33) = (unsigned*)(INIT_PAGE_SIZE/4 - 34);

  last = array+32;
  last_is_active = true;
  just_coalesced = false;
  op = 0;

  return 0;
}


void insert(unsigned *left)
{
  int i = log2(*(left+1));
  unsigned *temp = *(array+i);
  unsigned *prev = array+i;

  while (temp && (*(temp+1) > *(left+1))) {
    prev = temp;
    temp = *temp;
  }
  *prev = left;
  *left = temp;
}



void splice(unsigned *bad)
{
  int i = log2(*(bad+1));
  unsigned *temp = *(array+i);
  unsigned *prev = NULL;

  while (temp != bad) {
    if (temp == NULL) {
      printf("block at 0x%x of size %d not found in list %d in splice(), operation %d\n", (unsigned)bad, (unsigned)(*(bad+1)), i, op);
      exit(-1);
    }
    prev = temp;
    temp = *temp;
  }
  if (prev) 
    *prev = *temp;

  else
    *(array+i) = *temp;
  
}
  




void coalesce()
{
  int i;
  unsigned *temp = (unsigned*)(array+32);

  just_coalesced = true;

  for(i=0; i < 32; i++)
    *(array+i) = NULL;

  temp = (unsigned*)(array+32);

  while((unsigned)temp < (unsigned)dseg_hi) {
    if (*temp == ALLOCFLAG)  
      temp+= *(temp+1) + 2;
    else {
      if (temp == last) {
	insert(temp);
	return;
      }
      else if (*(temp + *(temp+1) + 2) == ALLOCFLAG) {
	insert(temp);
	temp+= *(temp+1) + 2;
      } else {
	if ((temp + *(temp+1) + 2) == last) 
	  last = temp;
	*(temp+1) += *(temp + *(temp+1) + 3) + 2;
      }
    }
  }
}
      


void check()
{
  4;
}


void *mm_malloc (size_t size)
{

  int i, j;
  unsigned *p = NULL;
  unsigned *left = NULL;
  unsigned *newpage;
  unsigned *temp;
  unsigned *prev;

  /*  printf("in malloc\n"); */

  if (size%8) 
    size = (size + (8 - size%8)) / 4;
  else
    size/= 4;
  
  if (((unsigned)last + (unsigned)*(last+1)*4 + 7) != (unsigned)dseg_hi)
    printf("BAD: last=%d, size=%d, dseg_hi=%d\n", last, *(last+1)*4, dseg_hi);

  op++;


  for (j = 0; j < 2; j++) {
    i = log2(size);
    while (i < 32) {
      if (*(array+i)) {
	if (*(*(array+i)+1) >= size) {
	  temp = *(array+i);
	  prev = array+i;
	  while (temp && (*(temp+1) >= size)) {
	    prev = temp;
	    temp = *temp;
	  }

	  splice(prev);
	
	  if (*(prev+1) == size) {
	    p = prev+2;
	    *(p-2) = ALLOCFLAG;
	    if (prev == last) {
	      last_is_active = false;
	    }
	    return p;
	  } else {
	    left = prev+size+2;
	    *(left+1) = *(prev+1) - size - 2;
	    p = prev+2;
	    *(p-2) = ALLOCFLAG;
	    *(p-1) = size;
	    if (prev == last) {
	      last = left;
	    }
	    insert(left);
	    return p;
	  }
	   
	}

	/*
	if ( (*(*(array+i)+1) == size) ) {
	  p = *(array+i) + 2;
	  temp = (unsigned*)(*(p-2));
	  if (*(array+i) == last) 
	    last_is_active = false;
	  
	  *(p-2) = ALLOCFLAG;
	  *(array+i) = temp;

	  return p;

	} else if ( *( *(array+i)+1 ) > size) {


	  p = *(array+i) + 2;
	  left = p+size;
	  if (*(array+i) == last) {	  
	    last = left;
	  }
	  *(array+i) = (unsigned*)(*(*(array+i)));
	  *(p-2) = ALLOCFLAG;
	  
	  *(left+1) = *(p-1) - size - 2; 
	  insert(left);	  
	  *(p-1) = size;
	  
	    return p;
	    
	} // end size test
	*/

      } // end list is not empty
      i++;
    } // end loop through lists

    if (!just_coalesced) coalesce(); 
    
  }
  
  if (last_is_active) splice(last);

  while (1) {
    newpage = mem_sbrk(INIT_PAGE_SIZE);
    if (!newpage) {
      printf("***mem_sbrk() returned NULL\n");
      return NULL;
    }

    if (last_is_active) {
      *(last+1) += (INIT_PAGE_SIZE/4);
    } else {
      last = newpage;
      last_is_active = true;
      *(last+1) = (INIT_PAGE_SIZE/4) - 2;
    }

    if (*(last+1) == size) {
      *last = ALLOCFLAG;
      p = last;
      last_is_active = false;
      return p+2;
    } else if (*(last+1) > size) {
      *(last+size+2) = (unsigned)NULL;
      *(last+size+3) = *(last+1) - size - 2;
      p = last + 2;
      *(p-1) = size;
      last = last+size+2;
      if ((unsigned)last == 0x40226e60)
		check();
      *(p-2) = ALLOCFLAG;

      insert(last);

      return p;
    }
    
  }
}




void mm_free (void *ptr)
{
  unsigned *temp = (unsigned*)(ptr);
  just_coalesced = false;
  temp = temp - 2;
  if (temp == last) last_is_active = true;
  insert(temp);
}





