/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Raptor",
    /* First member full name */
    "Daniel Hannum",
    /* First member email address */
    "dhannum@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Fernando Moraes",
    /* Second member email address (blank if none) */
    "fmoraes@andrew.cmu.edu"
};

/* The algorithm: It is a relatively simple explicit list of free blocks.
   Each free block has 8 bytes of header. The first 4 are size and a flag.
   The next 4 are wasted for alignment. This is repeated at the back end of
   the block. The last 4 are a footer; the second to last are wasted space.
   Free blocks also have pointers to the prev and next free blocks as the
   third and fourth dwords, respectively. The whole system has 8 bytes of
   overhead: two pointers. One to the first free block and one to the last.

   The malloc function looks through the free list _backwards_ (for speed
   reasons) The binary and binary2 traces were giving us hell, this was a 
   acceptable hack without drasitically changing the algorithm to a
   segregated list at the last minute.

   The free function behaves exactly as you'd expect. Each block checks it's
   neighbors to see if there free. If they are, they're removed from the free
   list and then the whole conglomerate block is added to the end of the list.
   
   Enjoy. 329 lines of malloc lovin'!
*/

/* Most of the time, we use uint pointers because we do most everything
   on dword boundaries. They can be dereferenced nicely, unlike void *'s */

/* ***** START IMPORTANT ROUTINES ***** */

int mm_init (void)
{
  uint page_size = mem_pagesize();
  uint *firstblock = (uint *)(dseg_lo + 8);
  /* saving four bytes for a pointer to the first free block
     and another four for a ptr to the last free block. */
  uint heap_size;

  /* get some memory, and check if we actually got it */
  if (mem_sbrk(page_size) == NULL)
    return 0;

  heap_size = page_size - 24;
  /* we subtract 24 because we keep 8 bytes of overhead on the whole system
     and 16 more bytes of overhead on the first block. */

  firstblock[0] = heap_size;                  /* front tag. Used flag is 0 */
  /* firstblock[1] is not used */
  firstblock[2] = 0;                          /* prev ptr is NULL */
  firstblock[3] = 0;                          /* next ptr is NULL */
  /* Data starts with firstblock + 4, which is really 16 bytes in. */
  
  /* firstblock[2 + (heap_size >> 2)] is not used */
  firstblock[3 + (heap_size >> 2)] = heap_size;  /* end tag */
  
  /* set the first word on the heap to the first free block
     and the second word on the heap is the last free block */
  firstblock[-2] = (uint)firstblock;
  firstblock[-1] = (uint)firstblock;
  return -1;
}

/* Delete a block from the free list */
/* Don't pass NULL to it. */
void DeleteBlock(uint *block)
{
  /* change the first and last pointers for the list */
  if (*(uint *)dseg_lo == (uint)block)
    *(uint *)dseg_lo = block[3];
  if (*(uint *)(dseg_lo + 4) == (uint)block)
    *(uint *)(dseg_lo + 4) = block[2];

  /* change the pointers to skip over the node */
  if (block[2] != 0)
    ((uint *)(block[2]))[3] = block[3];
  if (block[3] != 0)
    ((uint *)(block[3]))[2] = block[2];
}

/* splitblock splits block into two blocks. The beginning of the existing block
   becomes a block of size desired_size which is set to allocated. 
   The rest remains on the free list. The function returns a ptr to the
   alloced block. */
/* Invariant: desired_size must be <= the current size of block
   desired_size must be a multiple of 8. the size of block must also be
   a multiple of 8; */
uint *splitblock (uint *block, uint desired_size)
{
  uint wholesize = *block & -2;
  uint *start_of_second;

  if (wholesize - desired_size <= 16)  /* use the whole block */
    {
      /* We have to remove the whole block from the free list */
      DeleteBlock(block);

      /* set this block to be allocated */
      *block = wholesize | 1;
      block[3 + (wholesize >> 2)] = wholesize | 1;
    }
  else       /* split the front end off and make it the allocated part */
    {
      /* location of the second block (the free part) */
      start_of_second = block + 4 + (desired_size >> 2);

      /* header and footer tags of the free block on the end */
      *start_of_second = wholesize - desired_size - 16;
      block[3 + (wholesize >> 2)] = *start_of_second;
      
      /* move pointer references from block to start_of_second because
	 start_of_second is the free block now. */
      start_of_second[3] = block[3];
      start_of_second[2] = block[2];
      if (start_of_second[2] != 0)
	((uint *)(start_of_second[2]))[3] = (uint)start_of_second;
      if (start_of_second[3] != 0)
	((uint *)(start_of_second[3]))[2] = (uint)start_of_second;
      
      /* header and footer tags of the allocated part */
      start_of_second[-1] = desired_size | 1;
      block[0] = desired_size | 1;
      
      /* If we're allocating the first or last free block, 
	 then change the pointers in the heap header */
      if (*(uint *)dseg_lo == (uint)block)
	*(uint *)dseg_lo = (uint)start_of_second;
      if (*(uint *)(dseg_lo + 4) == (uint)block)
	*(uint *)(dseg_lo + 4) = (uint)start_of_second;
    }

  /* return the ptr */
  return block + 2;

}
  
void *mm_malloc (size_t size)
{
  uint targetsize = size;
  /* dseg_lo is a ptr to the beginning of the heap. We dereference it's second
     dword to get a ptr to the last free block. */
  uint *ptr = (uint *)(*(uint *)(dseg_lo + 4)), *newblock, *lastfreeblock;
  uint cur_blocksize, lastfooter;

  /* round up to nearest 8 bytes */
  if (size % 8 != 0)
    targetsize = size + (8 - size % 8);

  if (size == 0) return NULL;
  
  while (ptr != NULL)
    {
      cur_blocksize = (*ptr) & -2;

      if (cur_blocksize >= targetsize)
	{
	  /* we found a block. split it and return the ptr */
	  return splitblock(ptr, targetsize);
	}
      /* we're running through the free list backwards. This greatly increases
	 speed (50 -> 725), but we lose utilization 83 -> 80. The total
	 change is sufficient to add 20 points to our grade and kick us over
	 the A border */
      ptr = (uint *)(ptr[2]);
    }

  /* if we get this far, then we have no big enough block. Go get more */

  /* check the last block (free or not). If it is free, extend it with 
     the new memory */
  lastfooter = *(uint *)(dseg_hi - 3);

  if (lastfooter & 1)     /* the last block is used */
    {
      /* We're going to add on a whole new free block, so keep the
	 present last guy in the list */
      lastfreeblock = (uint *)*(uint *)(dseg_lo + 4);

      cur_blocksize = ((targetsize >> 12) + 1) << 12;
      if ((newblock = mem_sbrk(cur_blocksize)) == NULL)
	return NULL;     /* not enough memory */

      cur_blocksize = cur_blocksize - 16;     /* useful size of the new block 
						 (minus overhead) */

      /* set up the block control quadword 
	 (wasting newblock[1] and newblock[2 + (cur_blocksize >> 2)]) */
      newblock[0] = cur_blocksize;              /* front tag. Used flag is 0 */
      newblock[2] = (uint)lastfreeblock;        /* prev ptr is to prevblock */
      newblock[3] = 0;                          /* next ptr is NULL */
      newblock[3 + (cur_blocksize >> 2)] = cur_blocksize;  /* end tag */
      
      /* set the next ptr of the previous block to point to newblock */      
      if (newblock[2] != 0)        
	((uint *)newblock[2])[3] = (uint)newblock;

      /* set the ptr to the end of the free block list 
	 to point to the new block */
      *(uint *)(dseg_lo + 4) = (uint)newblock;

      /* If there are no free blocks, set the first and last ptrs here */
      /* If one is 0 then both are, so test only once */
      if (*(uint *)dseg_lo == 0)
	{
	  *(uint *)dseg_lo = (uint)newblock;
	  *(uint *)(dseg_lo + 4) = (uint)newblock;
	}

      /* now we have a new big block. Split off what we want, 
	 and return a ptr */
      return splitblock(newblock, targetsize);

    } else {       /* the last block is free */
      /* We're going to append stuff onto the end of the free block at the
	 end of the _physical_heap. So, we keep a ptr to the beginning
	 of that block. */
      lastfreeblock = (uint *)(dseg_hi - 15 - lastfooter);      

      /* use the space in the last free block, so we have to sbrk less */
      /* we hardcode the page size at 4096. */
      cur_blocksize = (((targetsize - lastfooter) >> 12) + 1) << 12;
      
      if ((newblock = mem_sbrk(cur_blocksize)) == NULL)
	return NULL;     /* not enough memory */

      /* coalesce the last free block with the new allocated memory */

      /* extend last free block */
      *lastfreeblock = *lastfreeblock + cur_blocksize ;

      /* put the footer on the end of the newly extended free block */
      *(uint *)((uint)dseg_hi - 3) = *lastfreeblock;

      return splitblock(lastfreeblock, targetsize);
    }
}

void mm_free(void *ptr)
{
  uint *startofblock = (uint *)ptr - 2;
  uint sizeofblock = *startofblock & -2;
  uint *startofnext, *startofprev;
  uint *lastblock;

  /* can't free something that's not allocated */
  if (((*startofblock) & 1) == 0) return;

  /* turn off both flags */
  *startofblock = *startofblock & -2;
  startofblock[3 + (*startofblock >> 2)] = *startofblock;
  
  /* check if previous contiguous block is used. And check if we're freeing
     the first contiguous block */
  if (((char *)startofblock - dseg_lo > 8) && (startofblock[-1] & 1) == 0)
    {
      startofprev = startofblock - 4 - (startofblock[-1] >> 2);
 
      DeleteBlock(startofprev);

      /* change tags of prev block to extend into the current one */
      *startofprev = *startofprev + sizeofblock + 16;
      startofblock[3 + (sizeofblock >> 2)] = *startofprev;

      /* ignoring pointers for now */

      /* update stuff */
      startofblock = startofprev;
      sizeofblock = *startofprev;  
    }

  /* check if next contiguous block is used. And check if we're freeing
     the last contiguous block */
  startofnext = startofblock + 4 + (sizeofblock >> 2);

  if ((dseg_hi > (char *)startofnext) && (*startofnext & 1) == 0)
    {
      DeleteBlock(startofnext);

      /* change tags to extend into the next block */
      *startofblock = *startofblock + *startofnext + 16;
      startofblock[3 + (*startofblock >> 2)] = *startofblock;
      
      /* ignoring pointers for now */

      sizeofblock = *startofblock;
    }

  /* Now we're done coalescing, so add the block to the free list */
  lastblock = (uint *)*(uint *)(dseg_lo + 4); 

  startofblock[2] = (uint)lastblock;
  startofblock[3] = 0;
  
  if (lastblock != 0)
    lastblock[3] = (uint)startofblock;
  else
    {
      /* There's nothing in the list, until now... */
      *(uint *)(dseg_lo) = (uint)startofblock;
      *(uint *)(dseg_lo + 4) = (uint)startofblock;
    }

  /* change the ptr to the last free block to reflect the fact that we
     made the new block the last one */
  *(uint *)(dseg_lo + 4) = (uint)startofblock;
}
