/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "D is for DIPLOMA",
    /* First member full name */
    "Dmitry Frumkin",
    /* First member email address */
    "ddf",
    /* Second member full name (leave blank if none) */
    "Daniel Shaykevich",
    /* Second member email address (blank if none) */
    "dan2"
};

/*
  HEADERS:
    Free block: NEXT, SIZE, PREVIOUS, __
    Used block: next, SIZE   

    (next & 1 will tell us if the buddy is in use) 

  The minimal block size: 4 words == 16 bytes = 2^4 bytes
*/

#define WORDSIZE (sizeof (size_t))
#define LOGMIN 4
#define DSEG_LO ((size_t *) dseg_lo)
#define INTPTR(x) (*(DSEG_LO + (x)))
#define OFFSET(x) ((size_t)(x) - (size_t)dseg_lo)
#define LOGM 7
#define M ((1<<LOGM)/WORDSIZE)
#define MEM_USAGE (mem_usage()+1)
#define NUMRESERVED 2

/* Uncomment if the program crashes */
#define BUDDY
//#define MYDEBUG

void print_array ()
{
  size_t  i = 0;
  size_t *ptr = NULL;

  printf ("Printing the array:\n\n");

  for (i = LOGMIN; i < M; i++)
  {
    printf ("%d:  \n", i);
    ptr = (size_t *)INTPTR (i);
    while (ptr != NULL)
      {
	printf ("     0x%x: (0x%x, %d, 0x%x)  \n", 
		(size_t)ptr, *ptr, *(ptr+1), *(ptr+2));
	if (*(ptr+1) != (1<<i))
	  {
	    exit(-1);
	  }
	ptr = (size_t *)*ptr;
      }
  }
  
  printf ("\n");
}
     
inline size_t log (size_t number)
{
  int result = -1;

  while (number)
  {
    result++;
    number /= 2;
  }

  return result;
}

/* 2^size is the actual size */
void insert (size_t *addr, size_t size)
{
  size_t *next = (size_t *)INTPTR (size);

#ifdef MYDEBUG
  printf ("In insert, addr = 0x%x, size = %d\n", (size_t) addr, size);
#endif

  /* Update the header */
  *addr = (size_t) next;        /* word 0 = next */
  *(addr + 1) = (1<<size);      /* word 1 = size */
  *(addr + 2) = 0;              /* word 2 = prev = 0*/
                                /* word 3 unused */
  
  /* Add to the linked list */
  if (next != NULL)
    *(next + 2) = (size_t) addr; /* next->back = this block */
  INTPTR (size) = (size_t) addr; /* add this block to the linked list */ 

#ifdef MYDEBUG
  print_array ();
  printf ("Exiting insert \n");
#endif
}

/* 2^size is the actual size */
void remove_node (size_t *addr, size_t size)
{
#ifdef MYDEBUG
  printf ("Entering remove_node, addr = 0x%x, size = %d\n", (size_t) addr, size);
#endif

  /* Remove from the list */
  if   (*(addr+2)) /* if it is not the first one on the list */
    *((size_t*)*(addr+2)) = *addr; /* previous->next=next */
  else
    INTPTR (size) = *addr; /* remove from the list */

  if (*addr)     /* if it is not the last one on the list */
    *((size_t*)*(addr)+2) = *(addr+2); /* next->previous=previous */

  /* Update the header */
  *addr = (*addr) | 1;

#ifdef MYDEBUG
  print_array ();
  printf ("Exiting remove_node \n");
#endif
}

/* 2^requested_size -- how much to allocate in bytes */
void split (size_t big_size, size_t requested_size)
{
  size_t *start = (size_t *) INTPTR (big_size); 

  size_t  buddy_size = 0;
  size_t *buddy_address = NULL; 

#ifdef MYDEBUG
  printf("Entering Split\n");
  printf("big_size = %d  requested_size = %d\n", big_size, requested_size);
#endif

  remove_node (start, big_size);             /* remove from the linked list */
  *(start + 1) = (1 << requested_size); /* set the correct size */

  /* Put the buddies into the free lists */

#ifdef MYDEBUG
  printf ("splitting into  buddies...\n");
#endif

  buddy_size = big_size - 1;              /* the log of the buddy size */
  while (buddy_size >= requested_size)
  {
    buddy_address = start + (1 << buddy_size)/WORDSIZE;
    insert (buddy_address, buddy_size);        /* add the buddy to the list */

    buddy_size--;
  } 

#ifdef MYDEBUG
  print_array ();
  printf ("Exiting split\n");
#endif
}


/* Initializes memory */
int mm_init (void)
{
  int result = -1;
  int i = 0;
  int init_size = mem_pagesize();
  int log_init_size = log (init_size);

  if (mem_sbrk (init_size) != NULL)
  {
    for (i = 0; i < M; i++)
      INTPTR (i) = 0;

    insert (DSEG_LO, log_init_size); /* this is OK since we do not
                                        use sizes < 16 == 2^4 */

    split (log_init_size, LOGM);
    result = 0;
  }

#ifdef MYDEBUG
  printf("Exiting Init, returning %d\n", result);
#endif
  return result;      
}

inline size_t adjust_size (size_t size)
{
  size_t result = 0;

#ifdef MYDEBUG
  printf ("Entering adjust_size, size = %d\n", size);
#endif
  if (size > 0)
  {
    size += NUMRESERVED*WORDSIZE;
    for (result = (1<<LOGMIN); result < size; result <<= 1);  
  }

#ifdef MYDEBUG
  printf ("Exiting adjust_size, new size = %d\n", result);
#endif

  return result;
}

/* Returns log(memory increase) */
inline size_t double_memory (void)
{
  size_t increase = MEM_USAGE;
  size_t result = 0;

  if (mem_sbrk (increase) != NULL)
    {
#ifdef MYDEBUG
      printf ("Doubled heap\n");
#endif

      result = log (increase);
      insert ((size_t *)(dseg_lo + increase), result);
    }
#ifdef MYDEBUG
  else
    printf ("Ran out of memory!, mem_usage = %d\n", (int)MEM_USAGE);
#endif

  return result;
}


void *mm_malloc (size_t size)
{
  void *result = NULL;
  size_t log_size = 0;
  size_t log_increase = 0;
  int i = 0;

#ifdef MYDEBUG
  static int remove_me = 0;

  printf("Entering malloc, size = %d\n", size);

  if (remove_me < 20)
    {
      printf ("size = %d\n", size);
      print_array();
      remove_me++;
    }
#endif

  size = adjust_size (size); /* adjusted size in bytes */
  if (!size)
    return NULL;

  log_size = log (size);     /* the log of the size    */
 
  for (i = log_size; i < M; i++) /* search for the first free block */
    if (INTPTR (i) != 0)
      {
	result = (void *) ((size_t *)INTPTR (i) + NUMRESERVED);
	split (i, log_size);
	break;
      }

#ifdef MYDEBUG
  if (result == NULL)
    {
      printf ("Piece of size %d not found => doubling the memory\n", log_size);
      print_array ();
    }
#endif

  /* if there is no free memory of this size, we have to double the heap */
  /* or use the last 4 Megs */
  if (result == NULL)
    do
      {
	log_increase = double_memory();
        if (log_increase == 0)
	  {
	    i = MEM_USAGE;
	    log_increase = log (DSEG_MAX - i);
#ifdef MYDEBUG
	    if (MEM_USAGE == DSEG_MAX || log_increase < log_size)
		exit (-1);
#endif
	    (void) mem_sbrk (1<<log_increase);
	    insert ((size_t *)(dseg_lo + i), log_increase);
	    split (log_increase, log_size);
	    result = (void *)(dseg_lo + i);
	    break;
	  }
	else
	  if (log_increase >= log_size)
	    {
	      split (log_increase, log_size);
	      result = (void *) (DSEG_LO + (1<<log_increase)/WORDSIZE + 
				 NUMRESERVED);
	      break;
	    }
      }
    while (log_increase > 0);

  return result; 
}

size_t *findbuddy (size_t *ptr)
{
  size_t block_size = *(ptr + 1);
  size_t *buddy_ptr = NULL;  
#ifdef BUDDY
  if (OFFSET (ptr)  & block_size)
    buddy_ptr = ptr - block_size/WORDSIZE;  /*buddy is to the left*/ 
  else
#endif
    buddy_ptr = ptr + block_size/WORDSIZE;/*buddy is to the right*/
  
  if ((*(buddy_ptr+1) != block_size) || ((*buddy_ptr) & 1))
    buddy_ptr = NULL;
  
  return buddy_ptr;
}

void mm_free (void *ptr)
{
#if 1
  size_t* block_start_ptr = ((size_t *) ptr) - NUMRESERVED;/* start of block */
  size_t log_block_size = log(*(block_start_ptr+1)); /* log of block size */

#if 0
  size_t* buddy_ptr = findbuddy (ptr);      /*Pointer 1st byte of buddy*/

  /* Loop invariants: 
       buddy_ptr = pointer to the buddy
       log_block_size = log (block_size)
       block_start_ptr = pointer to the whole block 
       buddy is not NULL */

  while (buddy_ptr != NULL)
    {
      remove_node (buddy_ptr, log_block_size);
      if (buddy_ptr < block_start_ptr)
	block_start_ptr = buddy_ptr;
      log_block_size++;
      buddy_ptr = findbuddy (block_start_ptr);
    }

  /* Add the block to the appropriate free list */
#endif
  insert (block_start_ptr, log_block_size);

#ifdef MYDEBUG
  printf ("Exiting free\n");
#endif

#endif
}
