/* $Id$ */

/* *  CS213 - Lab assignment 3 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "renegade bunny squad",
    /* First member full name */
    "daniel volkovich",
    /* First member email address */
    "danielv",
    /* Second member full name (leave blank if none) */
    "charles smart",
    /* Second member email address (blank if none) */
    "cks"
};

typedef long Align;
union node {
    struct {
        union node *ptr;
        unsigned size;
    } s;
    Align x;                    // force alignment to sizeof(Align)
};

typedef union node Node;

static Node base;
static Node *freep = NULL;

int mm_init (void)
{   if (mem_usage() < 0) {
	base.s.ptr = freep = &base; 
	base.s.size = 0;
    } 
    #ifdef BUG  
    printf("mm_init. mem_usage=%d\n",(int)mem_usage());
    printf("dseg_lo=%.2x dseg_hi=%.2x\n",(int)dseg_lo,(int)dseg_hi);
    printf("base.s.ptr=%.2x base.s.size=%.2x\n",(int)base.s.ptr,(int)base.s.size);
    #endif
    return 0;
}

void *mm_malloc (size_t size)
{   Node *p;
    Node *prev;
    unsigned n,m;

    m = n = (size+sizeof(Node)-1)/sizeof(Node) + 1;
    if (m <= getpagesize()) m=getpagesize();
    prev = freep; 

    #ifdef BUG 
    printf("mm_malloc %d bytes (%d units)\n",size,n);
    #endif

    for (p=prev->s.ptr; ;prev=p, p=p->s.ptr) {
    	#ifdef BUG 
	printf(" [%d into %d?] ",(unsigned)n,(unsigned)p->s.size);
	#endif

	if (p->s.size >= n) {
		if (p->s.size==n) {
    			#ifdef BUG 
			printf("\n\t\tp=0x%.2x\tptr=0x%.2x\tsize=[%d]  \t\tlo=0x%.2x\thi=0x%.2x\n",
			(int)p,(int)p->s.ptr,p->s.size,(int)dseg_lo,(int)dseg_hi);
			#endif

			prev->s.ptr = p->s.ptr;
		} else {
    			#ifdef BUG 
			printf("\n\t\tp=0x%.2x\tptr=0x%.2x\tsize=%d\t\tlo=0x%.2x\thi=0x%.2x\n",
			(int)p,(int)p->s.ptr,p->s.size,(int)dseg_lo,(int)dseg_hi);
			#endif

			p->s.size -= n;
			p += p->s.size;
			p->s.size = n;
		}
		freep = prev;
		return (void *)(p+1);
	}
	if (p==freep) {
    		#ifdef BUG 
		printf("[sbrking(%d units)]",m);
		#endif

		if ((p = (Node *)mem_sbrk(m*sizeof(Node)))==NULL) return NULL;
		p->s.ptr=p;
		p->s.size=m;
		mm_free((void *)(p+1));
		p = freep;
	}	
    }
}

void mm_free (void *ptr)
{	 
	Node *h,*p;
	if ( (char *)(ptr) <= dseg_lo) h = &base;
	else h = (Node *)ptr-1;	// point h at the header for ptr

	// cycle through free list
	for (p = freep; !(h > p && h < p->s.ptr); p = p->s.ptr)
		if (p >= p->s.ptr && (h > p || h < p->s.ptr))
			break;  // found a pointer pointing to the header
	if (h + h->s.size == p->s.ptr) {	// join to upper neighbor
		h->s.size += p->s.ptr->s.size;
		h->s.ptr = p->s.ptr->s.ptr;
	} else h->s.ptr = p->s.ptr;

	if (p + p->s.size == h) {		// join to lower neighbor
		p->s.size += h->s.size;
		p->s.ptr = h->s.ptr;
	} else p->s.ptr=h; 

	freep = p; 
}

