/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define HEADERSIZE 13

#define VALUESTART 1


int is_free( int * );
int max( int, int );
int getSize( int *);
int firstSlot( int, int );
void allocate( int * );
void unallocate( int * );
void tryPutFree( int *, int );
int  canPut( int *, int );
int  canNeverPut( int *, int );
int basicFree( int *);
void updatePointers();
void recursiveFree( int * );

team_t team = {
    /* Team name to be displayed on webpage */
    "Fight Club",
    /* First member full name */
    "Christopher N Raubacher",
    /* First member email address */
    "cnr@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Stephen P Opalenski",
    /* Second member email address (blank if none) */
    "stepheno@andrew.cmu.edu"
};

/* initilizes memory for mm_malloc*/
int mm_init (void)
{
  int size;
  int *start;
  int counter;

  size = mem_pagesize();

  if ( (dseg_hi - dseg_lo) < size )
    {
      if ( mem_sbrk( size ) == NULL )
	return -1;
    }
  else
    size = (dseg_hi - dseg_lo);

  size = size/4;

  start = (int *)dseg_lo;

  *start = HEADERSIZE;

  for ( counter = 1; counter < HEADERSIZE; counter++ )
    *(start + counter) = HEADERSIZE;

  *(start + *start) = size - HEADERSIZE;

  return 0;
}

void updatePointers()
{
  int pos;
  int mult = 4;
  int *start = (int *)dseg_lo;
  int i = VALUESTART;

  for ( i = VALUESTART; i < HEADERSIZE; i++ )
    {
      mult = mult*2;

      pos = *(start + i);

      while ( (pos < *start)&&( (!is_free( start + pos ) || ( is_free( start + pos ) && ( getSize( start + pos ) < mult ) ) ) ) )
	{
	  pos = pos + max( mult, getSize( start + pos ) );
	}
      
	*(start + i) = pos;
    }
}

int firstSlot( int mult, int counter )
{
  int pos;
  int *start = (int *)dseg_lo;

  pos = *(start + counter);

  while ( (pos < *start) && (!is_free( (start + pos) ) || (is_free( (start + pos) ) && (*(start + pos) < mult ))) )
      pos = pos + max( mult, getSize( (start + pos) ) );


  return pos;
}

int canPut( int *start, int length )
{
  int tempLength;

  if ( is_free( start ) && getSize( start ) >= length )
    {
      tempLength = *start;
      
      *start = length;
      *(start + length - 1) = length;

      if ( tempLength > length )
	{
	  *(start + length) = tempLength - length;
	  *(start + tempLength - 1) = tempLength - length;
	}
  
      return 1;
    }
  else
    return 0;
}

int canNeverPut( int *start, int length )
{
  if ( !is_free( start ) && getSize( start ) >= length )
    return 1;
  else
    return 0;
}

void tryPutFree( int *start, int length )
{
  if ( canPut( start, length ) == 1 )
    return;
  else
    {
      if ( canNeverPut( start, length ) == 1 )
	return;

      if ( length > 8 )
	{
	  tryPutFree( start, length/2 );
	  tryPutFree( start + length/2, length/2 );
	}
    }
}
	     
/* doubles size of heap */
int mm_double(void)
{
  
  int size;
  int shift;
  int *address;
  int *start;

  size = mem_pagesize();

  if ( mem_sbrk( size ) == NULL )
    return -1;

  size = size/4;

  start = (int *)dseg_lo;

  shift = *start;
  address = start + shift;

  *(address) = *(address) + size;
    
  return 0;
}

int is_free( int *pos )
{
  if ( ((*pos)&(1 << 31)) == 0)
    return 1;
  else
    return 0;
}

/* allocates free blocks to be filled with stuff */
void allocate( int *pos )
{
  *pos = (*pos)|(1<<31);
}

void unallocate( int *pos )
{
  *pos = (*pos)^(1<<31);
  *(pos + *pos - 1) = *pos;
}

/* returns size of a block*/
int getSize( int *pos )
{
  if ( is_free( pos ) )
    return *pos;
  else
    return (*pos)^(1<<31);
}

int max( int a, int b )
{
  if ( a > b )
    return a;
  else
    return b;
}

/* duh */

void *mm_malloc (size_t size)
{
  int pos;
  int *start = (int *)dseg_lo;
  int outerMult, mult;
  int counter;

  mult = 8;

  size = size + 8;

  if ( size%8 != 0 )
    size = size + 8-(size%8);

  size = size/4;

  counter = 1;

  while ( size > mult )
    {
      counter = counter + 1;
      mult = mult*2;
    }

  pos = firstSlot( mult, counter );

  if ( pos >= *start )
    {
      while ( (dseg_lo + 4*pos + 4*mult) > dseg_hi-1 )
	{
	  if ( mm_double() == -1 )
	    return NULL;
	}

      *(start + pos + mult) = *(start + *start) - ((pos - *start) + mult);
      *(start + pos) = mult;

      if ( pos > *start )
	{
	  *(start + *start) = pos - *start;
	  

	  *(start + pos - 1) = *(start + *start);


	  tryPutFree( (start + pos - mult), mult );
	}

      *(start + pos) = mult;
      /*     
      for ( i = VALUESTART; i < VALUEMAX; i++ )
	{
	  if ( *(start + i) == *start )
	    *(start + i) = pos + mult;
	}
	*/
      *start = pos + mult;

      *(start + pos + mult - 1) = mult;
    }
  else
    {
      outerMult = *(start + pos);

      while ( outerMult > 2*mult )
	{
	  outerMult = outerMult/2;
	  
	  *(start + pos + 2*outerMult - 1) = outerMult;
	  *(start + pos + outerMult) = outerMult;
	  *(start + pos + outerMult -1) = outerMult;
	  *(start + pos) = outerMult;
	}


    }

  allocate( start + pos );
  allocate( start + pos + mult -1);

  
  updatePointers();
  

  return start + pos + 1;

}

int basicFree( int *pos)
{
  int size;
  int counter = 1;
  int *start = (int *)dseg_lo;
  int i;
  int oldsize;

  if ( !is_free( pos - 1) )
    {
      size = getSize((pos - 1));
      unallocate( pos - 1 );
          
      if ( size == 8 )
        counter = 1;
      
      if ( size == 16 )
	counter = 2;

      if ( size == 32 )
	counter = 3;
      
      if ( size == 64 )
	counter = 4;
       
      if ( size == 128 )
	counter = 5;

      if ( size == 256 )
	counter = 6;

      if ( size == 512 )
	counter = 7;

      if ( size == 1024 )
	counter = 8;

      if ( size == 2048 )
	counter = 9;

      if ( size == 4096 )
	counter = 10;

      if ( size == 8192 )
	counter = 11;
      
      if ( size == 16384 )
	counter = 12;

      if ( *start == ((pos - 1) - start) + size )
	{
	  oldsize = *(start + *start);
	  for ( i = VALUESTART; i < HEADERSIZE; i++ )
	    {	  
	      if ( *(start + i) == *start )
		*(start + i) = ((pos-1)-start);
	    }
	  *start = ((pos-1)-start);
	  *(start + *(start) ) = size + oldsize;
	}

      if ( *(start + counter) > ((pos - 1)-start) )
	*(start + counter) = ((pos - 1)-start);
	

      return 1;
    }
  return 0;
}

void recursiveFree( int *ptr )
{
  int *start = (int *)dseg_lo;
  int size = *ptr;
  int pos = ptr - start - HEADERSIZE;

  if ( pos%(2*size) == 0 )
    {
      if ( is_free(ptr + *ptr) && getSize(ptr + *ptr) == size )
	{
	  *ptr = 2*size;
	  *(ptr + *ptr-1) = 2*size;

	  recursiveFree( ptr );
	}
    }
  else
    {
      if ( is_free(ptr - *ptr) && getSize(ptr - *ptr) == size )
	{
	  *(ptr - *ptr)= 2*size;
	  *(ptr + *ptr - 1) = 2*size;
	  
	  recursiveFree( ptr - *ptr );
	}
    }
}      

  


void mm_free (void *ptr)
{
  if ( basicFree( (int *)ptr ) == 1 )
    ;
    /*
    recursiveFree( (int *)ptr - 1 );
    */
}


