/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

int abs(int x) { return ((x < 0) ? -x : x); }

team_t team = {
    /* Team name to be displayed on webpage */
    "The Discovery Channel",
    /* First member full name */
    "Chris LaBrunda",
    /* First member email address */
    "cll",
    /* Second member full name (leave blank if none) */
    "Matt Lahut",
    /* Second member email address (blank if none) */
    "mlahut" 
};


int mm_init (void)
{
int *freelist;

  mem_sbrk(mem_pagesize());
  freelist = (int *)dseg_lo;
  *freelist = 0;
  *(freelist + 1) = 0;
  *(freelist + 2) = 0;
  *(freelist + 3) = 0;
  *(freelist + 4) = 0;
  *(freelist + 5) = 0;
  *(freelist + 6) = 0;
  *(freelist + 7) = 0;
  *(freelist + 8) = 0;
  *(freelist + 9) = 0;
  *(freelist + 10) = 0;
  *(freelist + 11) = 0;
  *(freelist + 12) = (int)(freelist + 15);
  *(freelist + 13) = 0;
  *(freelist + 14) = 0;

  return 0;
}

void remfree (int *ptr)
{
  if (*(ptr + 2)) /* if it's not the last node */
    *((int *)(*(ptr + 2)) + 1) = *(ptr + 1);

  if ((*(ptr + 1) < (int)(dseg_lo + 50)) && ( *((int *)(*(ptr + 1))) == ptr))
    /* if it's the first node in a list */
    {
      *((int *)(*(ptr + 1))) = *(ptr + 2);
    }
  else
    {
     *((int *)(*(ptr + 1)) + 2) = *(ptr + 2);
    }
}

void insert (int size, int *ptr) /* size is positive */
{
  int *pointer;
  int *freelist;
  *ptr = -(size);
  *(ptr + size - 1) = -size;

  freelist = (int *)dseg_lo;
  if (size <= 8)
    {
      pointer = freelist;
    }
  else if (size <= 16)
    {
      pointer = (freelist + 1);
    }
  else if (size <= 32)
    {
      pointer = (freelist + 2);
    }
  else if (size <= 64)
    {
      pointer = (freelist + 3);
    }
  else if (size <= 128)
    {
      pointer = (freelist + 4);
    }
  else if (size <= 256)
    {
      pointer = (freelist + 5);
    }
  else if (size <= 512)
    {
      pointer = (freelist + 6);
    }
  else if (size <= 1024)
    {
      pointer = (freelist + 7);
    }
  else if (size <= 2048)
    {
      pointer = (freelist + 8);
    }
  else if (size <= 4096)
    {
      pointer = (freelist + 9);
    }
  else if (size <= 8192)
    {
      pointer = (freelist + 10);
    }
  else
    {
      pointer = (freelist + 11);
    }
  if ((*pointer) && (*((int *)(*pointer)) < size))
    /* if there is a list and we don't become the first element */
    {
      pointer = (int *) *pointer; /* dereference it */
      while ((*(pointer + 2) != 0) && (*pointer < size))
	{
	  pointer = (int *) *(pointer + 2);
	}
      /*now we instert the new free block AFTER where we are now */
      *ptr = -size;
      *(ptr + 1) = (int)pointer;
      *(ptr + 2) = *(pointer + 2);
      *(ptr + size - 1) = -size;

      if (*(pointer + 2)) /* if we are not the last element */
	{
	  *((int *)(*(pointer + 2)) + 1) = (int)ptr;
	}
      *(pointer + 2) = (int)ptr;

    }
  else  /*we have to insert at the begining of this list */
    {
      *ptr = -size;
      *(ptr + 1) = (int)pointer;
      *(ptr + 2) = *pointer;
      *(ptr + size - 1) = -size;
      *pointer = (int)ptr;
      if (*(ptr + 2)) /* if we are not the last element */
	{
	  (int *)(*((int *)(*(ptr + 2)) + 1)) = ptr;
	}
    }

}

void allocate (size_t size, int *ptr)
{
  *ptr = size;
  ptr = ptr + size - 1;
  *ptr = size;
}

size_t round16 (size_t num)
{
  num += 7;
  num = (((num >> 4) + 1) << 2);
  return num;
}

void *mm_malloc (size_t size)
{
  int *whichlist;
  int *pointer;
  int *freelist;
  freelist = (int *)(dseg_lo);
  size = round16(size);
  if ((*freelist != 0) && (size <= 8))
    {
      pointer = freelist;
    }
  else if ((*(freelist + 1) != 0) && (size <= 16))
    {
      pointer = (freelist + 1);
    }
  else if ((*(freelist + 2) != 0) && (size <= 32))
    {
      pointer = (freelist + 2);
    }
  else if ((*(freelist + 3) != 0) && (size <= 64))
    {
      pointer = (freelist + 3);
    }
  else if ((*(freelist + 4) != 0) && (size <= 128))
    {
      pointer = (freelist + 4);
    }
  else if ((*(freelist + 5) != 0) && (size <= 256))
    {
      pointer = (freelist + 5);
    }
  else if ((*(freelist + 6) != 0) && (size <= 512))
    {
      pointer = (freelist + 6);
    }
  else if ((*(freelist + 7) != 0) && (size <= 1024))
    {
      pointer = (freelist + 7);
    }
  else if ((*(freelist + 8) != 0) && (size <= 2048))
    {
      pointer = (freelist + 8);
    }
  else if ((*(freelist + 9) != 0) && (size <= 4096))
    {
      pointer = (freelist + 9);
    }
  else if ((*(freelist + 10) != 0) && (size <= 8192))
    {
      pointer = (freelist + 10);
    }
  else if ((*(freelist + 11) != 0) && (size <= 16384))
    {
      pointer = (freelist + 11);
    }
  else
    {
      /* allocate from top */
      pointer = (int *) (*(freelist + 12));
      while ((int *)(dseg_hi - 4) < (pointer + size))
	{ /* expand the heap */
	  mem_sbrk(mem_pagesize());
	}
      allocate(size, pointer);
      *(pointer + size) = 0;
      (int *)(*(freelist + 12)) += size;
      return (pointer + 1);
      /* allocated from top */
    }
  whichlist = pointer;
  pointer = (int *)(*pointer);
  while ((*(pointer + 2) != 0) && (abs(*pointer) < size))
    pointer = (int *)(*(pointer + 2));

  if (abs(*pointer) < size) /* we failed to get one in that list */
    {
      whichlist++;
      while (*whichlist == 0)
	whichlist++;
      pointer = (int *)(*whichlist);
    }

  if (whichlist == (freelist + 12))
    {
      /* allocate from top */
      while ((int *)dseg_hi < (pointer + size + 1))
	{ /* expand the heap */
	  mem_sbrk(mem_pagesize());
	}
      allocate(size, pointer);
      *(pointer + size) = 0;
      (int *)(*(freelist + 12)) += size;
      return (pointer + 1);
      /* allocated from top */
    }

  if (size == abs(*pointer))
/*simply remove the freespace block from the list*/
    {
      remfree(pointer);
      allocate(size, pointer);
    }
  else  /* delete the block and insert what's leftover */
    {
      remfree(pointer);
      insert((abs(*pointer) - size), (pointer + size));
      allocate(size, pointer);
    }
  return (pointer + 1);
}

void mm_free (void *ptr)
{
  int *intptr;
  int *fullsize;
  int *newptr;
  newptr = ptr;
  newptr = newptr - 1;
  intptr = newptr;
  fullsize = ((int *)(dseg_lo) + 13);
  *fullsize = *intptr;
  intptr = intptr - 1;
  if (*intptr < 0)
    {
    /* coalesce left */
      *fullsize = *fullsize + abs(*intptr); /* adding a negative size */
      newptr = newptr - abs(*intptr); /* subtracting a negative size */
      remfree(newptr);
    }
  intptr = intptr + 1;
  intptr = intptr + *intptr;
  if (*intptr < 0)
    {
    /* coalesce right */
      *fullsize = *fullsize + abs(*intptr); /* adding a negative size */
      remfree(intptr);
    }
  /*fullsize is positive */
  insert(*fullsize, newptr);



}





