/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Doctor Gonzo",
    /* First member full name */
    "John Bucy",
    /* First member email address */
    "bucy@gloop.org",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

void fragment(void *start, int size);

struct HEADER {
  /* high-order bit flags whether this is an allocated or free block */
  unsigned int size;

  /* pointer to next free block */
  /* this value is only guaranteed to be good for free blocks */
  struct HEADER *next;
  /* pointer to previous free block */
  struct HEADER *prev;

  /* make it a multiple of 8 bytes */
  char pad[4];
};

/* size of header plus size of footer */
#define HEADERSIZE (sizeof(struct HEADER) + 8) 

/* same semantics of size field of HEADER */
/* typedef unsigned int FOOTER; */


#define NUMFREELISTS 14

struct TABLE {


  /* 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 
     4096, 8192, 16384, 32768, 65536 */

  /* for freeLists[n], the range is 2^(n + 3) <= size < 2^(n + 4) */

  struct HEADER *freeLists[NUMFREELISTS];

  /* roving pointers into variable-length free lists */
  struct HEADER *rovingPointers[NUMFREELISTS];

  struct HEADER *firstBlock;

};

#define Table ((struct TABLE *)dseg_lo)

/* flag on a size field that says whether the block is allocated */
#define ALLOCBIT 0x80000000

#define LEN(x) (x & (~ALLOCBIT))

#define FOOTBASE(x) \
((unsigned *)((unsigned)x + LEN(x->size) + 20))


int log2(int x) {

  /* one of our favorites from Lab 1... */
  /* return the floor of the log base 2 of the input */

  int middle = 16;

  /* this gets us x - (1 << middle) */
  int arrow = x + (~(1 << middle) + 1);

  /* this makes arrow either -1, 0 or 1 */
  arrow = (arrow >> 31) | (!!arrow) ;

  middle = middle + ((arrow) << 3);


  arrow = x + (~(1 << middle) + 1);
  arrow = (arrow >> 31) | (!!arrow);
  middle = middle + ((arrow) << 2);

  arrow = x + (~(1 << middle) + 1);
  arrow = (arrow >> 31) | (!!arrow);
  middle = middle + ((arrow) << 1);

  arrow = x + (~(1 << middle) + 1);
  arrow = (arrow >> 31) | (!!arrow);
  middle = middle + arrow;

  arrow = x + (~(1 << middle) + 1);
  /* last time through, we need this to be only 0 or -1; since we're getting
     the lower integer bound on the log, we don't want to increment arrow
     here */
  arrow = (arrow >> 31);
  middle = middle + arrow;

  return middle;
}

#define INDEX(x) (x < 65536 ? (log2(x) - 3) : (NUMFREELISTS - 1))


int mm_init (void)
{
  int c;
  int pad;
  struct HEADER *newblock;

  /* get us some space to put the free-list table into */
  if(!mem_sbrk(mem_pagesize())) {
    return -1;
  }

  for(c = 0; c < NUMFREELISTS; c++) {
    Table->freeLists[c] = 0;
    Table->rovingPointers[c] = 0;
  }

  /* make one block out of what's left of the new page */
  newblock = (struct HEADER *)((int)Table + sizeof(struct TABLE));

  pad = ((int)newblock % 8) == 0 
    ? 0 
    : 8 - ((int)newblock % 8);

  /* align newblock */
  newblock = (struct HEADER *)((unsigned)newblock + pad);
  newblock->size = (struct HEADER*)
    (1 + (unsigned)dseg_hi - (unsigned)newblock - HEADERSIZE);
  *FOOTBASE(newblock) = newblock->size;

  newblock->next = 0;
  newblock->prev = 0;

  /* assume that the page size is less than 65536 */
  Table->freeLists[log2(newblock->size) - 3] = newblock;
  Table->rovingPointers[log2(newblock->size) - 3] = newblock;

  Table->firstBlock = newblock;


  return 0;
}

void *mm_malloc (size_t size)
{
  int pagespace;
  struct HEADER *newblock, *newfrag;

  int index;
  /* round the size to a multiple of 8 */
  size += 
    ((8 - (size & 7)) == 8)
    ? HEADERSIZE % 8 
    : (8 - (size & 7)) + (HEADERSIZE % 8);


  /* look through the free-lists */
  index = INDEX(size);

  /* loop over free lists */
  for(index = index; index < NUMFREELISTS; index++) {
    struct HEADER *startPoint, *freelist;

    if(!(Table->freeLists[index])) { continue; }

    /* loop through a particular free-list */
    startPoint = 0;

    /* invariant: Table->rovingPointers[index] == 0 iff
       Table->freeLists[index] == 0 */
    freelist = Table->rovingPointers[index];

    for(;;) {
      int othersize = size;
      othersize += HEADERSIZE;
      othersize += ((sizeof(struct HEADER) % 8) == 0)
	? 0
	: 8 - (HEADERSIZE % 8);
      othersize += 8;


      /* block is exactly the right size */
      if(freelist->size == size) {
	/* mark block as allocated */
	freelist->size |= ALLOCBIT;
	*FOOTBASE(freelist) = freelist->size;

	/* splice out block */
	/* block is in middle of free list */
	if((freelist->next) && (freelist->prev)) {
	  freelist->next->prev = freelist->prev;
	  freelist->prev->next = freelist->next;
	  Table->rovingPointers[index] = freelist->next;
	} 
	/* beginning of list */
	else if(freelist->next) {
	  Table->freeLists[index] = freelist->next;
	  freelist->next->prev = 0;
	  Table->rovingPointers[index] = freelist->next;
	}
	/* end of list */
	else if(freelist->prev) {
	  freelist->prev->next = 0;
	  Table->rovingPointers[index] = Table->freeLists[index];
	}
	/* list of one element */
	else {
	  Table->freeLists[index] = 0;
	  Table->rovingPointers[index] = 0;
	}

	return (char*)((int)freelist + sizeof(struct HEADER));
      }


      /* this size restriction is funny-looking; the point is so that
	 we don't split a block and end up with a 16-byte fragment
	 that is all header and footer and no data */


      else if(freelist->size >= othersize) {
	int origsize;
	struct HEADER *block, *frag;

	block = freelist;
	origsize = block->size & (~ALLOCBIT);
	block->size = size;
	block->size |= ALLOCBIT;
	*FOOTBASE(block) = block->size;
	
	frag = 
	  (struct HEADER *)((unsigned)freelist + HEADERSIZE + size);
	
	frag->size = origsize - HEADERSIZE - size;
	*FOOTBASE(frag) = frag->size;

	/* splice block out of freelist and splice frag into freelist */
	/* Frag goes into some other freelist than the one we're in */
	if((log2(frag->size) - 3) != index) {
	  int fragindex;
	  /* splice out frag */
	  /* 4 cases as above */
	  /* middle of list */
	  if(block->prev && block->next) {
	    block->prev->next = block->next;
	    block->next->prev = block->prev;
	    Table->rovingPointers[index] = block->next;
	  }
	  /* end of list */
	  else if(block->prev) {
	    block->prev->next = 0;
	    Table->rovingPointers[index] = Table->freeLists[index];
	  }
	  /* beginning of list */
	  else if(block->next) {
	    block->next->prev = 0;
	    Table->freeLists[index] = block->next;
	    Table->rovingPointers[index] = block->next;
	  }
	  /* list of one element */
	  else {
	    Table->freeLists[index] = 0;
	    Table->rovingPointers[index] = 0;
	  }

	  /* file frag */
	  frag->prev = 0;
	  fragindex = INDEX(frag->size);
	  frag->next = Table->freeLists[fragindex];
	  Table->freeLists[fragindex] = frag;
	  Table->rovingPointers[fragindex] = frag;
	  if(frag->next)
	    frag->next->prev = frag;
	}

	/* frag goes into the current freelist */
	else {
	  /* middle of list */
	  if(block->prev && block->next) {
	    block->prev->next = frag;
	    block->next->prev = frag;
	    frag->prev = block->prev;
	    frag->next = block->next;
	    Table->rovingPointers[index] = frag;
	  }
	  /* end of list */
	  else if(block->prev) {
	    block->prev->next = frag;
	    frag->prev = block->prev;
	    frag->next = 0;
	    Table->rovingPointers[index] = frag;
	  }
	  /* beginning of list */
	  else if(block->next) {
	    frag->prev = 0;
	    frag->next = block->next;
	    Table->freeLists[index] = frag;
	    frag->next->prev = frag;
	    Table->rovingPointers[index] = frag;
	  }
	  /* list of one element */
	  else {
	    Table->freeLists[index] = frag;
	    frag->next = frag->prev = 0;
	    Table->rovingPointers[index] = frag;
	  }
	}
	
	return (char*)((unsigned)block + sizeof(struct HEADER));
      }
      
      /* could have another case here for block big enough for request
	 but not big enough to fragment ... might help utilization */

      if(freelist->size >= size) {
	/* mark block as allocated */
	freelist->size |= ALLOCBIT;
	*FOOTBASE(freelist) = freelist->size;

	/* splice out block */

	/* block is in middle of free list */
	if((freelist->next) && (freelist->prev)) {
	  freelist->next->prev = freelist->prev;
	  freelist->prev->next = freelist->next;
	  Table->rovingPointers[index] = freelist->next;
	} 
	/* beginning of list */
	else if(freelist->next) {
	  Table->freeLists[index] = freelist->next;
	  freelist->next->prev = 0;
	  Table->rovingPointers[index] = freelist->next;
	}
	/* end of list */
	else if(freelist->prev) {
	  freelist->prev->next = 0;
	  Table->rovingPointers[index] = Table->freeLists[index];
	}
	/* list of one element */
	else {
	  Table->freeLists[index] = 0;
	  Table->rovingPointers[index] = 0;
	}

	return (char*)((int)freelist + sizeof(struct HEADER));
      }



      else {
	if(!startPoint) {
	  startPoint = freelist;
	}

	freelist = freelist->next;
	if(!freelist) freelist = Table->freeLists[index];

	if(startPoint == freelist) {
	  break;
	}
      }
    } /* loop through a free list */

  } /* loop over free lists */
  



  /* no free blocks ... get some from the heap */
  
  if((size + HEADERSIZE) <= mem_pagesize()) {
    pagespace = mem_pagesize();
  }
  else {
    pagespace = (((size + HEADERSIZE) / mem_pagesize()) + 1) * mem_pagesize();
  }
  newblock = (struct HEADER*)mem_sbrk(pagespace);
  if(!newblock) return newblock;
  

  /* don't create a fragment if there is not enough extra space to
     do it with */
  if(pagespace >= (size + 2 * HEADERSIZE + 8)) {
    void *start;
    newblock->size = size;
    newblock->size |= ALLOCBIT;
    *FOOTBASE(newblock) = newblock->size;

    start = (void *)((int)newblock + size + HEADERSIZE);
    fragment(start, size);
  }
  else {
    newblock->size = pagespace - HEADERSIZE;
    newblock->size |= ALLOCBIT;
    *FOOTBASE(newblock) = newblock->size;
  }

  return (char*)((unsigned)newblock + sizeof(struct HEADER));
}

void mm_free (void *ptr)
{
  struct HEADER *block;
  struct HEADER *newtop;
  int up, down;
  int index;

  /* get the start of the header */
  block = (struct HEADER *)((unsigned)ptr - sizeof(struct HEADER));

  /* flip off the allocated flag */
  block->size &= (~ALLOCBIT);
  *FOOTBASE(block) = block->size;
  
  /* coalesce previous block */
  if((unsigned)block > (unsigned)Table->firstBlock) {
    up = *(unsigned *)((unsigned)block - 4);
    if(!(up & ALLOCBIT)) {
      int index;
      newtop = (struct HEADER*)((unsigned)block - LEN(up) - HEADERSIZE);
      index =  INDEX(newtop->size);
      newtop->size += HEADERSIZE + block->size;
      *FOOTBASE(newtop) = newtop->size;

	if((newtop->next) && (newtop->prev)) {
	  newtop->next->prev = newtop->prev;
	  newtop->prev->next = newtop->next;
	  Table->rovingPointers[index] = newtop->next;
	} 
	/* beginning of list */
	else if(newtop->next) {
	  Table->freeLists[index] = newtop->next;
	  newtop->next->prev = 0;
	  Table->rovingPointers[index] = newtop->next;
	}
	/* end of list */
	else if(newtop->prev) {
	  newtop->prev->next = 0;
	  Table->rovingPointers[index] = Table->freeLists[index];
	}
	/* list of one element */
	else {
	  Table->freeLists[index] = 0;
	  Table->rovingPointers[index] = 0;
	}
    }
    else {
      newtop = block;
    }
  }
  else {
    newtop = block;
  }






  /* coalesce next block */
  if(((unsigned)FOOTBASE(block) + 8) < (unsigned)dseg_hi) { 
    down = ((struct HEADER *)((unsigned)FOOTBASE(block) + 4))->size; 
    if(!(down & ALLOCBIT)) { 
      int index;
      struct HEADER *temp = 
	(struct HEADER *)((unsigned)FOOTBASE(block) + 4);

      /* 8 bytes from newtop footer, 16 bytes from temp header */      
      newtop->size += down + HEADERSIZE;
      *FOOTBASE(newtop) = newtop->size;
      
      index = INDEX(temp->size);
      
      if((temp->next) && (temp->prev)) {
	temp->next->prev = temp->prev;
	temp->prev->next = temp->next;
	Table->rovingPointers[index] = temp->next;
      } 
      /* beginning of list */
      else if(temp->next) {
	Table->freeLists[index] = temp->next;
	temp->next->prev = 0;
	Table->rovingPointers[index] = temp->next;
      }
      /* end of list */
      else if(temp->prev) {
	temp->prev->next = 0;
	Table->rovingPointers[index] = 
	  Table->freeLists[index];
      }
      /* list of one element */
      else {
	Table->freeLists[index] = 0;
	Table->rovingPointers[index] = 0;
      }
    } 
  } 



  index = INDEX(newtop->size);

  newtop->prev = 0;
  newtop->next = Table->freeLists[index];
  Table->freeLists[index] = newtop;
  if(newtop->next)
    newtop->next->prev = newtop;
  Table->rovingPointers[index] = newtop;
}
 


/* fragment the memory from start to dseg_hi into pieces of size
   size */
void fragment(void *start, int size) {

  int totsize = (unsigned)dseg_hi + 1 - (unsigned)start;
  int count = totsize / (size + HEADERSIZE);
  int c;
  struct HEADER *frag, *frag2;
  int index = INDEX(size);

  count = (count == 0) ? 1 : count;

  frag2 = Table->freeLists[index];
  for(c = 0; c < (count - 1); c++) {
    frag = (struct HEADER*)((unsigned)start + (size + HEADERSIZE) * c);
    frag->size = size;
    *FOOTBASE(frag) = frag->size;

    frag->prev = 0;
    frag->next = Table->freeLists[index];
    if(frag->next)
      frag->next->prev = frag;

    Table->freeLists[index] = frag;
    Table->rovingPointers[index] = frag;

   }

  frag = (struct HEADER*)((unsigned)start + (size + HEADERSIZE)*(count - 1));
  frag->size = totsize - (count - 1) * (size + HEADERSIZE) - HEADERSIZE;
  *FOOTBASE(frag) = frag->size;

  index = INDEX(frag->size);

  frag->prev = 0;
  frag->next = Table->freeLists[index];
  Table->freeLists[index] = frag;
  if(frag->next)
    frag->next->prev = frag;
  Table->rovingPointers[index] = frag;
}









