/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Darth Malloc",
    /* First member full name */
    "Jake Bordens",
    /* First member email address */
    "bordens@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Sahala Swenson",
    /* Second member email address (blank if none) */
    "swenson@andrew.cmu.edu"
};

/* We've implemeneted a simple, first fit malloc routine, with a (really) simple
 * free.  We had intended to expand this implementation to a set of hashed
 * linked-lists of free blocks, (per the extra 4 bytes in the header and footer
 * for next and prev pointers), but due to time constraints, we had to go with what
 * works.  Its not pretty, hell its not efficient, but it passes all the tests.
 */

#define HEAP_LEADING_SPACE 0  /* 4 bytes of leading space to the heap */
#define BLOCK_HEADER_SIZE 8   /* 4 bytes of header to each memory block */
#define BLOCK_FOOTER_SIZE 8   /* 4 block footer to each memory block */

/* Helper function: return the int at the address of the given void pointer */
int voidPtrToInt(void *p) {
  return *(int *)p;
}

/* Helper function: set the bytes at *p to the given integer */
void setVoidPtr(void *p, int value) {
  *(int *)p = value;
}

/* Helper function: get the footer of a block, given its header */
void* getFootFromHead(void *p) {
  return p - BLOCK_HEADER_SIZE + (*(int *)p & -2);
}

/* Helper function: get the user block space pointer from its header */
void* getUserPtrFromHead(void *p) {
  return p + BLOCK_HEADER_SIZE;
}

/* Helper function: get the header block from the user space pointer */
void* getHeadFromUserPtr(void *p) {
  return p - BLOCK_HEADER_SIZE;
}

/* Helper function: get the footer from the user space pointer */
void* getFootFromUserPtr(void *p) {
  return getFootFromHead(getHeadFromUserPtr(p));
}

/* Helper function: get the block size from the user space pointer */
int getBlockSize(void* p) {
  return (*(int *)(p - BLOCK_HEADER_SIZE)) & -2;
}

/* Allocate new block: allocate n bytes and set the start and end tags */
void* getNewBlock(int size) {
  void* newBlock = mem_sbrk(size);
  setVoidPtr(newBlock, size);
  setVoidPtr(getFootFromHead(newBlock), size);
  return getUserPtrFromHead(newBlock);
}

/* Given a void pointer to the user space, find the next block's user pointer
 * or return null if the next block doesn't exist.
 */
void* getNextBlock(void* ptr) {
  void* blockHead = getHeadFromUserPtr(ptr) + getBlockSize(ptr);
  if (blockHead < (void *)dseg_hi)
    return getUserPtrFromHead(blockHead);
  else
    return NULL;
}

/* Given a pointer to the user space, find the previous block's user pointer
 * or return null if the previous block doesn't exist
 */
void* getPrevBlock(void* ptr) {
  int   prevBlockSize = (*(int *)(ptr - BLOCK_HEADER_SIZE - BLOCK_FOOTER_SIZE)
			 & -2);
  void* result = ptr - prevBlockSize + BLOCK_HEADER_SIZE;
  if (result >= (void *)dseg_lo)
    return result;
  else
    return NULL;
}

/* give an pointer to the user space, determine if the block is allocated */
int isBlockAllocated(void* p) {
  return (*(int *)getHeadFromUserPtr(p)) & 1;
}

/* Helpter Function: set the allocated flag to false for the given block */
void unsetAllocatedFlag(void* p) {
  void* header = getHeadFromUserPtr(p);
  void* footer = getFootFromHead(header);
  *(int *)header = (*(int *)header & -2);
  *(int *)footer = (*(int *)footer & -2);
}

/* Helpter Function: set the allocated flag to true for the given block */
void setAllocatedFlag(void* p) {
  void* header = getHeadFromUserPtr(p);
  void* footer = getFootFromHead(header);
  *(int *)header = (*(int *)header | 1);
  *(int *)footer = (*(int *)footer | 1);
}


int mm_init (void)
{
  int heapsize = mem_pagesize();

  /* allocate the first free block.  Note that the first 4 bytes of the
   * heap are left kept aside to maintain alignment. (HEAP_LEADING_SPACE)
   */
  void* newBlockHead = mem_sbrk(heapsize) + HEAP_LEADING_SPACE;
  int size = heapsize - HEAP_LEADING_SPACE;

  setVoidPtr(newBlockHead, size);
  setVoidPtr(getFootFromHead(newBlockHead), size);

  return -1;
}

/* Split block - given a block of sufficient size, make one block of the
 * given size and another with the remaining space */
void splitBlock(void* ptr, int size) {

  /* make sure the newsize is right, and get the old size */
  int newsize = ((size + 1) >> 1) << 1;
  int oldsize = getBlockSize(ptr);
  void* header = getHeadFromUserPtr(ptr);

  if (newsize < oldsize) {
    *(int *)header = newsize | 1;
    *(int *)getFootFromHead(header) = newsize | 1;
    *(int *)getHeadFromUserPtr(getNextBlock(ptr)) = oldsize-newsize;
    *(int *)getFootFromUserPtr(getNextBlock(ptr)) = oldsize-newsize;
  }
}

void *mm_malloc (size_t size)
{
  /* declaration of variables */
  void* ptr;
  int numpages;
  int pagesize = mem_pagesize();
  
  
  /* first, make sure that the size of the block is a multiple if 8.
   * This is necessary to maintain alignment. 
   */
  if (size % 8)
    size += 8 - (size % 8);
		  
  /* next, add on the size of the header and footer */
  size += BLOCK_HEADER_SIZE + BLOCK_FOOTER_SIZE;

  /* now, find the first free block */
  ptr = dseg_lo + HEAP_LEADING_SPACE + BLOCK_HEADER_SIZE;     
                                  /* the first block in the heap */

  /* iterate over all blocks */
  while (ptr < (void *)dseg_hi && ptr != NULL) {
    if (!isBlockAllocated(ptr) && size <= getBlockSize(ptr)) {
      /* block is free, and of sufficient size so then */
      splitBlock(ptr,size);
      setAllocatedFlag(ptr);
      return ptr;
    }
    ptr = getNextBlock(ptr);
  }

  /* if we get here, then no block was of sufficient size, so allocate a
   * new one using getNewBlock(); 
   */

  /* determine the size of the new block in pages. */
  if (size < pagesize)
    numpages = 1;
  else if (size % pagesize == 0)
    numpages = (size / pagesize);
  else
    numpages = (size / pagesize) + 1;

  /* if we can allocate a new block, then split it, and return the pointer */
  if ((ptr = getNewBlock(numpages * pagesize))) {
    splitBlock(ptr, size);
    setAllocatedFlag(ptr);
    return ptr;
  } else {
    printf ("out of memory error!");
    exit(1);
  }
	
}

void mm_free (void *ptr)
{

  /* int size = getBlockSize(ptr);
  void * currFoot = getFootFromUserPtr(ptr);
  void * currHead = getHeadFromUserPtr(ptr); */
  
  unsetAllocatedFlag(ptr);

  /* if (!isBlockAllocated( getNextBlock(ptr) )){
    size = size + getBlockSize( getNextBlock(ptr) );
    currFoot = getFootFromUserPtr( getNextBlock(ptr) );
    unsetAllocatedFlag( getNextBlock(ptr));
  } 

  if (!isBlockAllocated( getPrevBlock(ptr) )){
    size = size + getBlockSize( getPrevBlock(ptr));
    currHead = getHeadFromUserPtr( getPrevBlock(ptr));
    unsetAllocatedFlag( getPrevBlock(ptr));
  } 

  setVoidPtr( currFoot, size);
  setVoidPtr( currHead, size);
  */
}



