/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
		/* Team name to be displayed on webpage */
		"blah",
		/* First member full name */
		"Ronald Y. Teng",
		/* First member email address */
		"rteng",
		/* Second member full name (leave blank if none) */
		"",
		/* Second member email address (blank if none) */
		""
};


/*******************************************************************************

The implicit data structure is a doubly-linked list of free blocks with a dummy
first node.  Each free node has a size, pointer to previous node, and pointer to
next node (in that order).  The pointer to previous node is 8-byte aligned.
When a block of memory is requested the list is searched until a large enough
block is found.  If no such block is found, additional memory is requested (and
possibly coalesced).  The used block keeps the header with its size.  Since
sizes are made multiples of 8, two bits are used to describe whether the block
is used and whether the previous block is used.  If the previous block is free,
the nearest word contains the size of the block.  When a used block is freed,
those features are used to determine coalescing.

*******************************************************************************/


#define DSEG_HI (dseg_hi + 1)
#define MEM_USAGE (mem_usage() + 1)                                             // Fix for memlib bug.

#define LAST_USED (*(int *)dseg_lo)                                             // Bool: is last block used?
#define IS_LAST(f) (((char *)(f) + ((f)->size<<2)) == DSEG_HI)                  // Rvalue bool: is this the last block?
#define TRUE 1
#define FALSE 0

#define ALIGN4(n) (12 - (n)%8)                                                  // Padding to make n a (multiple of 8) + 4.
#define ALIGNED8(n) ((n) + 8 - (n)%8)                                           // Ceils n to multiple of 8.

#define HEAD ((Free *)(dseg_lo + 4))                                            // Pointer to dummy free block.
#define PREC_SIZE(f) (*((unsigned *)(f) - 1))                                   // Size of f's preceeding block (assuming it's unused).
#define PREC(f) ((Free *)((char *)(f) - PREC_SIZE(f)))                          // Pointer to f's preceeding block (assuming it's unused).
#define FOLL(f) ((Free *)((char *)(f) + ((f)->size<<2)))                        // Pointer to f's following block.


typedef struct FreeT
{
	unsigned size:30, used:1, prec_used:1;                                        // The header word which precedes the 8-byte aligned data.
	struct FreeT *prev, *next;                                                    // Used in free blocks to maintain the list.
} Free;                                                                         // Also, the last word of a free block contains the actual size.


void make_free(Free *f, unsigned size, Free *prev, Free *next)
{
	f->size = size;                                                               // Sizes (which include size of header) are internally represented >> 2.
	*(unsigned *)((char *)f + (size<<2) - 4) = size<<2;                           // Sets last word to true size.

	f->used = FALSE;
	f->prec_used = TRUE;                                                          // Assumes preceeding has to be used or it would have been coalesced.
	if(IS_LAST(f)) LAST_USED = FALSE;

	f->prev = prev;
	prev->next = f;

	f->next = next;
	if(next != 0) next->prev = f;
}


int mm_init(void)
{
	if((int)dseg_lo%8 != 0) return -1;                                            // Functions rely on dseg_lo being 8-byte aligned (which it should be).
	if(MEM_USAGE < 44) if(mem_sbrk(mem_pagesize()+4) == 0) return -1;             // Gets required memory if necessary.
	if(MEM_USAGE%8 != 4) if(mem_sbrk(ALIGN4(MEM_USAGE)) == 0) return -1;          // Aligns end to 8-byte aligned + 4 so that, after header, new blocks are 8-byte aligned.

	HEAD->size = 0;                                                               // Special size so that HEAD is never used.
	HEAD->prev = 0;
	HEAD->next = (Free *)(dseg_lo + 20);
	*((unsigned *)dseg_lo + 4) = 20;                                              // Sets last word to true size.

	make_free(HEAD->next, (MEM_USAGE - 20) >> 2, HEAD, 0);                        // Makes remainder a free block.

	return 0;
}


void *mm_malloc(size_t s)
{
	unsigned size = ALIGNED8(s+4) >> 2;                                           // Internal representation.

	Free *f;
	for(f = HEAD; f != 0 && f->size < size; f = f->next);                         // Try to find the first block that fits.

	if(f == 0)                                                                    // If none large enough were found.
	{
		if((f = (Free *)mem_sbrk(size<<2)) == 0) return 0;                          // Get required memory.

		if(LAST_USED == TRUE)                                                       // If coalescing isn't possible.
		{
			f->size = size;
			f->used = TRUE;
			f->prec_used = TRUE;
			return (void *)((char *)f + 4);                                           // Return with the new memory.
		}
		else                                                                        // Coalesce with preceeding.
		{
			f = PREC(f);
			make_free(f, f->size + size, f->prev, f->next);
		}
	}

	if(f->size >= size + 20)                                                      // Make remaining space into a free block (keep in same position on list).
	{
		make_free((Free *)((char *)f + (size<<2)), f->size - size, f->prev, f->next);
		f->size = size;
	}
	else                                                                          // Remove this block from list.
	{
		f->prev->next = f->next;
		if(f->next != 0) f->next->prev = f->prev;

		if(IS_LAST(f)) LAST_USED = TRUE;
	}

	f->used = TRUE;
	return (void *)((char *)f + 4);                                               // Return start of usable space (after header).
}


void mm_free(void *p)
{
	Free *f = (Free *)((char *)p - 4);                                            // Set to header.

	if(f->prec_used)
	{
		if(IS_LAST(f) || FOLL(f)->used)                                             // Don't coalesce.
		{
			make_free(f, f->size, HEAD, HEAD->next);
		}
		else                                                                        // Coalesce with following.
		{
			make_free(f, f->size + FOLL(f)->size, FOLL(f)->prev, FOLL(f)->next);
		}
	}
	else
	{
		if(IS_LAST(f) || FOLL(f)->used)                                             // Coalesce with preceeding.
		{
			make_free(PREC(f), f->size + PREC(f)->size, PREC(f)->prev, PREC(f)->next);
		}
		else                                                                        // Coalesce with preceeding and following.
		{
			FOLL(f)->prev->next = FOLL(f)->next;                                      // Remove following from list (preceeding's place will be used).
			if(FOLL(f)->next != 0) FOLL(f)->next->prev = FOLL(f)->prev;

			make_free(PREC(f), f->size + PREC(f)->size + FOLL(f)->size, PREC(f)->prev, PREC(f)->next);
		}
	}
}

