/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Unnamed",
    /* First member full name */
    "Matthew Hunter",
    /* First member email address */
    "mhunter",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

// The following values are used for debugging & statistics

#define start (malloc_header *)(((int) dseg_lo) + sizeof(malloc_info))
#define info ((malloc_info *) dseg_lo)

typedef struct malloc_header
{
   void *next;
   size_t size;
} malloc_header;

typedef struct malloc_info
{
   malloc_header *(lists[32]);
} malloc_info;


/**
 * Taken from the Lab1_log2.c file.
 **/

int log2(int x)
{
  int m16 = ((1<<16) + ~0) << 16;                         /* groups of 16 */
  int m8 = (((1<<8)  + ~0) << 24) + (((1<<8) + ~0) << 8); /* groups of 8 */
  int m4 = (0xf0<<24) + (0xf0<<16) + (0xf0<<8) + 0xf0;    /* groups of 4 */
  int m2 = (0xcc<<24) + (0xcc<<16) + (0xcc<<8) + 0xcc;    /* groups of 2 */
  int m1 = (0xaa<<24) + (0xaa<<16) + (0xaa<<8) + 0xaa;    /* groups of 1 */
  int result = 0;
  int upper;
  int mask;

  /* m16 */
  upper = !!(x & m16);
  result += upper << 4;
  mask = m16 ^ ~((upper<<31)>>31);

  /* m8 */
  upper = !!(x & m8 & mask);
  result += upper << 3;
  mask &= (m8 ^ ~((upper<<31)>>31)); 

  /* m4 */
  upper = !!(x & m4 & mask);
  result += upper << 2;
  mask &= (m4 ^ ~((upper<<31)>>31)); 

  /* m2 */
  upper = !!(x & m2 & mask);
  result += upper << 1;
  mask &= (m2 ^ ~((upper<<31)>>31)); 

  /* m1 */
  upper = !!(x & m1 & mask);
  result += upper;

  return result;
}

__inline void clearmem(void *region, int size)
{
   int count;
   char *uregion = (char *)(((int) region) + sizeof(malloc_header));
   for (count = 0; count < size; count++)
   {
      uregion[count] = 0;
   }
}

__inline int valid_header(malloc_header *header)
{
   if (((void *) header > (void *) dseg_lo) && ((void *) header < (void *) dseg_hi))
   {
      return 1;
   }
   else return 0;
}

int isfree(malloc_header *header)
{
   return ((header->size << 31) >> 31);
}

/*
__inline int isfree(malloc_header *header)
{
   if (header->size % 2) return 1;
   else return 0;
}
*/
__inline malloc_header *next_region(malloc_header *header)
{
   return (malloc_header *)(((int) header) + header->size - isfree(header));
}

__inline malloc_header *next_list_region(malloc_header *header)
{
   return header->next;
}

void add_to_list(malloc_header *region)
{
   int lsize = log2(region->size);
   int debug = 0;
   if (debug)
   {
      printf("add_to_list() ");
      if (log2(region->size) != lsize)
      {
         printf("Incorrect lsize!");
      }
      fflush(NULL);
   }
   region->next = info->lists[lsize];
   info->lists[lsize] = region;
}

void rem_from_list_prev(malloc_header *prev, malloc_header *region)
{
   int lsize = log2(region->size);
   int debug = 0;
   malloc_header *current;

   if (debug)
   {
      printf("rem_from_list() ");
      fflush(NULL);
   }
   
   current = info->lists[lsize];
   if (current == region)
   {
      info->lists[lsize] = region->next;
      region->next = NULL;
      return;
   }
   else
   {
      prev->next = region->next;
      region->next = NULL;
      return;
   }
}

void rem_from_list(malloc_header *region)
{
   int lsize;
   int count = 0;
   int debug = 0;
   malloc_header *current;
   
   if (debug)
   {
      printf("rem_from_list() ");
      fflush(NULL);
   }
   lsize = log2(region->size);
   current = info->lists[lsize];

   if (current == region)
   {
      info->lists[lsize] = region->next;
      region->next = NULL;
      return;
   }

   while (valid_header(current))
   {
      if (current->next == region)
      {
         current->next = region->next;
         region->next = NULL;
         return;
      }
      current = next_list_region(current);
   }
}

__inline void init_header(malloc_header *header, int size, int free, void *next)
{
   header->size = size + free;
   header->next = next;
   // clearmem(header, size - free - sizeof(malloc_header));
}

int coalesce(malloc_header *region)
{
   /*
   int size;
   int debug  = 0;
   int count  = 0;
   int blocks = 0;
   malloc_header *current = region;
   malloc_header *last = NULL;
   malloc_header *next = NULL;
   
   if (debug)
   {
      printf("Coalescing: ");
      fflush(NULL);
   }

   size = current->size;
   next = next_region(current);
   while (valid_header(next) && isfree(next))
   {
      size += next->size - 1;
      rem_from_list_prev(last, next);
      last = next;
      next = next_region(next);
   }
   init_header(current, size, 1, NULL);
   add_to_list(current);

   if (debug)
   {
      printf("%d blocks\n", count);
      fflush(NULL);
   }
   return size;
   */
   return 0;
}

__inline malloc_header *find_fit(int size)
{
   int debug = 0;
   if (debug)
   {
      printf("find_fit(%d) ", size);
      fflush(NULL);
   }

   if (info != NULL)
   {
      int csize = 0;
      int clsize = 0;
      int cfree = 0;
      int lfree = 0;
      int count = 0;
      int counter = 0;
      malloc_header *current = NULL;
      malloc_header *last = NULL;
      malloc_header *ptr = NULL;

      // Walk each freelist large enough to be possible
      // lsize = log2(size);
      for (count = log2(size); count < 32; count++)
      {
         counter = 0;
         current = info->lists[count];
         while (valid_header(current))
         {
            // Get current size, masking out lowest-order bit
            csize = current->size - 1;

            // If this block is free and big enough for the current request,
            // we can fill that request with this block.

            if (csize >= size)
            {
               if (debug)
               {
                  printf("fits in existing %d block at %d", csize, (int) current);
                  fflush(NULL);
               }

               rem_from_list_prev(last, current);

               // If the block is large enough to split, split it;
               // otherwise, leave the size unchanged.  Use a sizing
               // factor to prevent really small blocks.
               
               if ((csize - size) > (2 * sizeof(malloc_header) + 112))
               {
                  malloc_header *temp;
                  init_header(current, size, 0, NULL);
                  temp = next_region(current);
                  init_header(temp, csize - size, 1, NULL);
                  add_to_list(temp);
               }
               else
               {
                  init_header(current, csize, 0, NULL);
               }
               return current;
            }
            last = current;
            current = next_list_region(current);
         }
      }
   }
   return NULL;
}

int mm_init (void)
{
   int count;
   int debug = 0;
   if (dseg_lo >= dseg_hi)
   {
      mem_sbrk(mem_pagesize());
   }
   for (count = 0; count < 32; count++)
   {
      info->lists[count] = NULL;
   }

   init_header(start, mem_pagesize() - sizeof(malloc_info), 1, NULL);
   add_to_list(start);
   
   if (debug)
   {
      printf("pagesize: %d\n", mem_pagesize());
      printf("dseg_lo: %d\n", (int) dseg_lo);
      printf("dseg_hi: %d\n", (int) dseg_hi);
      printf("malloc_info: %d bytes\n", sizeof(malloc_info));
      printf("malloc_header: %d bytes\n", sizeof(malloc_header));
   }
   
   return 0;
}

void *mm_malloc (size_t size)
{
   int lsize;
   int debug = 0;
   int rsize = 0;
   void *ptr;

   // Debugging stuff
   if (debug)
   {
      printf("malloc(%d): ", size);
      fflush(NULL);
      rsize = 0;
   }

   // Calculate the real size in bytes by adding the size
   // of the header
   rsize = size + sizeof(malloc_header);

   // Ensure 8-byte alignment by adding any necessary size
   if ((rsize % 8) > 0)
   {
      rsize += 8 - (rsize % 8);
   }
   lsize = log2(rsize);
   if (debug)
   {
      printf("%d bytes ", rsize);
      fflush(NULL);
   }
   
   // Check for usable freed blocks
   ptr = NULL;
   if (dseg_lo < dseg_hi) ptr = find_fit(rsize);
      

   // If there are no free blocks with enough space, ask for more
   if (ptr == NULL)
   {
      // How many pages will we need to allocate?
      int pagesize;
      int numpages;
      int remainder;

      // If we couldn't find a free block large enough, coalesce
      // coalesce();
      
      pagesize = mem_pagesize();
      numpages = rsize / pagesize;
      if ((rsize % pagesize) > 0) numpages++;
      remainder = (numpages * pagesize) - rsize;

      if (debug)
      {
         printf("in %d pages, %d bytes extra ", numpages, remainder);
         fflush(NULL);
      }
      // Allocate new block
      ptr = mem_sbrk(numpages * pagesize);
      // Initialize the block we'll return
      init_header(ptr, rsize, 0, NULL);
      // Initialize the remaining space as freed
      init_header((void *)(((int) ptr) + rsize), remainder, 1, NULL);
      add_to_list((malloc_header *)(((int) ptr) + rsize));
   }

   if (ptr != NULL)
   {
      // ((int *) ptr)[0] = rsize;
      // if (debug) printf("with size %d ", ((int *) ptr)[0]);
      
      ptr = (void *)(((int) ptr) + sizeof(malloc_header));
      if (debug)
      {
         printf("at %d\n", ((int) ptr));
         fflush(NULL);
      }
      // if (debug) display_list(info->start);
      return ptr;
   }
   else return NULL;
}

/**
 * Takes the (adjusted) size of a memory region, and clears it.
 **/

void mm_free (void *ptr)
{
   malloc_header *next;
   malloc_header *current;
   int size;
   int lsize;
   int debug = 0;

   if (debug)
   {
      printf("mm_free(%d): ", (int) ptr);
      fflush(NULL);
   }

   // Check that the pointer is in the valid range
   current = (malloc_header *)(((int) ptr) - sizeof(malloc_header));
   if (valid_header(current))
   {
      // If the pointer is in the valid range, mark it freed;
      // Coalesce adjacent regions
      size = current->size;
      lsize = log2(size);
      next = next_region(current);

      while (valid_header(next) && isfree(next))
      {
         size += next->size - 1;
         rem_from_list(next);
         next = next_region(next);
      }

      init_header(current, size, 1, NULL);
      add_to_list(current);

      if (debug)
      {
         printf("%d bytes", current->size - 1);
      }
      
      // After freeing, walk the rest of the list to coalesce it
   }

   if (debug) printf("\n");
}

