/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>


#include "memlib.h"
#include "malloc.h"


/* We used a segregated free list strategy where each list
 * is sorted in order of decreasing size.  Each block has
 * a 1-block (2 int) header that consists of a pointer to
 * the next block in the list and the size of the block in
 * ints.  
 *
 * mm_init() requests one page for the initial heap size and
 * sets up a 32-int array of pointers to free lists at the
 * beginning of the heap.  It then creates a header for the
 * remaining part of the heap and inserts it into the free
 * list.  The hash function from block size to array index
 * number is log2().
 *
 * When mm_malloc(int) is called, first the size is rounded
 * up to the nearest 8 bytes, then converted to ints.  It
 * looks in the appropriate free list for a block of at least
 * that size.  Since the list is sorted in decreasing size order
 * we can tell if the current list contains a large enough
 * free block in O(1).  If there is a large enough block, we
 * traverse the list until we find the best fit.  We remove
 * the block from the free list, split if necessary, and 
 * insert the remainder back into the free list.  We also
 * set the "next" pointer in the header of the block we are
 * allocating to ALLOCFLAG=1; this is a safe overload because
 * nothing in the free list will point to 0x01.  
 *
 * If there is not a large enough free block, we look in the
 * next list, and so on, until we reach the end of the array,
 * in which case we coalesce our free space (unless we haven't
 * freed anything since the last coalesce) and try the same
 * process again.  If we are still unable to find a large
 * enough free block, we request another page and see if we
 * can immediately coalesce it with the last free block in the
 * heap (pointed to by int* last, we have to update this a lot
 * when we split or allocate.  bool last_is_active == last block
 * in the heap is free).  If this is still not enough, we request
 * an additional page and repeat this process.
 *
 * When we coalesce, we wipe the free list array clean, start
 * from the beginning of the heap, and coalesce free space and
 * add it to the free list in linear time on the size of the
 * heap.
 * 
 * mm_free() updates our last_is_active pointer and inserts the
 * freed block into the free list.
 * 
 * insert() uses the log2() hash function and maintains the
 * sortedness of each list.
 *
 * splice() removes a free block from the free list.
 */






#define PAGE_SIZE 4096
#define INIT_PAGE_SIZE PAGE_SIZE
#define ALLOCFLAG 1
#define false 0
#define true 1

unsigned *last = NULL;
unsigned **array;
int last_is_active;
int just_coalesced;

team_t team = {
    /* Team name to be displayed on webpage */
    "CowPants44",
    /* First member full name */
    "Jason Liszka",
    /* First member email address */
    "jliszka",
    /* Second member full name (leave blank if none) */
    "Dave Heine",
    /* Second member email address (blank if none) */
    "dheine"
};



int log2 (unsigned x)
{
  int total = 0;
  x >>= 1;
  while (x != 0) {
    total++;
    x >>= 1;
  }
  return total;
}


int mm_init (void)
{
  int i;
  int *g;

  g = mem_sbrk(INIT_PAGE_SIZE);

  if (!g) {
    printf("***mem_sbrk() returned NULL\n");
    return -1;
  }
 
  if ((i = mem_usage()) != INIT_PAGE_SIZE-1) {
    printf("mem_usage() is not %d, is %d", INIT_PAGE_SIZE, i);
    return -1;
  }

  array = (unsigned**)dseg_lo;
  for(i=0; i < 32; i++)
    *(array+i) = NULL;
  
  *(array+log2((INIT_PAGE_SIZE-32)/4)) = (unsigned*)(array + 32);
  *(array+32) = (unsigned)NULL;
  *(array+33) = (unsigned*)(INIT_PAGE_SIZE/4 - 34);

  last = array+32;
  last_is_active = true;
  just_coalesced = true;

  return 0;
}


void insert(unsigned *left)
{
  int i = log2(*(left+1));
  unsigned *temp = *(array+i);
  unsigned *prev = array+i;

  while (temp && (*(temp+1) > *(left+1))) {
    prev = temp;
    temp = *temp;
  }
  *prev = left;
  *left = temp;
}



void splice(unsigned *bad)
{
  int i = log2(*(bad+1));
  unsigned *temp = *(array+i);
  unsigned *prev = NULL;

  while (temp != bad) {
    if (temp == NULL) {
      printf("block at 0x%x of size %d not found in list %d in splice()\n", (unsigned)bad, (unsigned)(*(bad+1)), i);
      exit(-1);
    }
    prev = temp;
    temp = *temp;
  }
  if (prev) 
    *prev = *temp;

  else
    *(array+i) = *temp;
  
}
  




void coalesce()
{
  int i;
  unsigned *temp = (unsigned*)(array+32);

  just_coalesced = true;

  for(i=0; i < 32; i++)
    *(array+i) = NULL;

  temp = (unsigned*)(array+32);

  while((unsigned)temp < (unsigned)dseg_hi) {
    if (*temp == ALLOCFLAG)  
      temp+= *(temp+1) + 2;
    else {
      if (temp == last) {
	insert(temp);
	return;
      }
      else if (*(temp + *(temp+1) + 2) == ALLOCFLAG) {
	insert(temp);
	temp+= *(temp+1) + 2;
      } else {
	if ((temp + *(temp+1) + 2) == last) 
	  last = temp;
	*(temp+1) += *(temp + *(temp+1) + 3) + 2;
      }
    }
  }
}
      




void *mm_malloc (size_t size)
{

  int i, j;
  unsigned *p = NULL;
  unsigned *left = NULL;
  unsigned *newpage;
  unsigned *temp;
  unsigned *prev;


  if (size%8) 
    size = (size + (8 - size%8)) / 4;
  else
    size/= 4;

  

  for (j = 0; j < 2; j++) {
    i = log2(size);      // look in the right place in the array
    while (i < 32) {     // hopefully we find it here, else loop
      if (*(array+i)) {  // if there's nothing in the list, move on
	if (*(*(array+i)+1) >= size) {
                         // if first block is too small, move on
          
	  temp = *(array+i);
	  prev = array+i;
	  while (temp && (*(temp+1) >= size)) {
	    prev = temp;
	    temp = *temp;
	  }             // find a best fit

	  splice(prev);

          // if sizes match, don't split
	  if (*(prev+1) == size) {
	    p = prev+2;
	    *(p-2) = ALLOCFLAG;
	    if (prev == last) 
	      last_is_active = false;
	    return p;
	  } else {   // else split
	    if (size < 20) {
	      left = prev+size+2;
	      *(left+1) = *(prev+1) - size - 2;
	      p = prev+2;
	      *(p-2) = ALLOCFLAG;
	      *(p-1) = size;
	      if (prev == last) {
		last = left;
	      }
	      insert(left);
	      return p;
	    } else {
	      p = prev + (*(prev+1)-size) + 2;
	      *(p-2) = ALLOCFLAG;
	      *(p-1) = size;
	      left = prev;
	      *(left+1) = *(prev+1)-size-2;
	      if (prev == last) {
		last_is_active = false;
		last = p-2;
	      }
	      insert(left);
	      return p;
	    }
	  }
	  
	}

      } // end list is not empty
      i++;
    } // end loop through lists

    // if we're here, we couldn't find a block
    // of the right size, so coalesce (but only once)
    if (!just_coalesced) coalesce(); 
    
  }
  
  // if we're here, our coalescing still
  // failed to yield a block of sufficient size,
  // so get a new page and coalesce with last

  if (last_is_active) splice(last);

  while (1) {
    newpage = mem_sbrk(INIT_PAGE_SIZE);
    if (!newpage) {
      printf("***mem_sbrk() returned NULL\n");
      return NULL;
    }

    // coalesce with last?
    if (last_is_active) {
      *(last+1) += (INIT_PAGE_SIZE/4);
    } else {
      last = newpage;
      last_is_active = true;
      *(last+1) = (INIT_PAGE_SIZE/4) - 2;
    }

    // to split or not to split...
    if (*(last+1) == size) {
      *last = ALLOCFLAG;
      p = last;
      last_is_active = false;
      return p+2;
    } else if (*(last+1) > size) {
      *(last+size+2) = (unsigned)NULL;
      *(last+size+3) = *(last+1) - size - 2;
      p = last + 2;
      *(p-1) = size;
      last = last+size+2;
      *(p-2) = ALLOCFLAG;

      insert(last);

      return p;
    }
    
  }
}




void mm_free (void *ptr)
{
  unsigned *temp = (unsigned*)(ptr);
  just_coalesced = false;
  temp = temp - 2;
  // update our "last" pointer
  if (temp == last) last_is_active = true;
  insert(temp);
}





 
