/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "cdh",
    /* First member full name */
    "Christopher Hayes",
    /* First member email address */
    "cdhayes",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};
      
int mm_init (void)
{
  size_t page = mem_pagesize();
  size_t ps = page / 4;
  size_t *t = mem_sbrk(page);
  if (t != NULL)
    {
      *t = ps;
      *(t + 1) = *(t + ps - 2) = ps - 2;
      *(t + ps - 1) = 0;
      return 0;
    }
  return -1;
}

void *mm_malloc (size_t size)
{
  size_t s = (size + ((-size) & 7) + 8)/4;
  size_t *t = (size_t *)dseg_lo + 1;

  while((*t != 0) && ((*t & 1) || (*t < s))) t += *t & ~1;
  
  if (*t == 0)
    {
      size_t n = s;

      if (!(*(t - 1) & 1))
	{
	  t -= *(t - 1);
	  n -= *t;
	}

      if (mem_sbrk(n * 4) == NULL)
	{
	  printf("Out of memory\n");
	  return NULL;
	}

      *t += n;
      *(t + *t - 1) = *t;
      *(t + *t) = 0;
    }
  
  if (*t > s)
    {
      size_t *p = t + s;
      *p = *(t + *t - 1) = *t - s;
      *t = *(p - 1) = s;
    }
  
  *(t + *t - 1) |= 1;
  *t |= 1;
  return (void *)(t + 1);
}

void mm_free (void *ptr)
{
  size_t *t = (size_t *)ptr - 1;
  size_t s = *t & ~1;

  if (((unsigned)t > (unsigned)dseg_lo) && ((unsigned)t < (unsigned)dseg_hi) && (*t & 1))
    {
      size_t *next = t + s;
      size_t *prev = t - 1;
      *(t + s - 1) = *t = s;

      if (!(*prev & 1) && ((unsigned)prev > (unsigned)dseg_lo))
	{
	  *(t + *t - 1) += *prev;
	  *(t - *prev) += *t;
	  t -= *prev;
	  *prev = *(prev + 1) = 0;
	}

      if (!(*next & 1) && ((unsigned)next < (unsigned)dseg_hi) && (*next))
	{
	  *(next + *next - 1) += *t;
	  *t += *next;
	  *next = *(next - 1) = 0;
	}
    }
}
