/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "",
    /* First member full name */
    "Bryan Holland-Minkley",
    /* First member email address */
    "beh@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

#define eightByteAlignMask -8

#define selectLeftMask 32768
#define selectRightMask 2
#define selectUsedMask 1
#define selectSizeMask 32764
#define pageMask -4096

#define heap_start dseg_lo
#define heap_end dseg_hi
#define next_page (void*)((char*)desg_hi + 1)
#define next_page_mem_spot (void*)((char*)dseg_hi + 7)

int freeMem() {
  return mem_usage() + 1;
}

void* roundUpToPage(void* ptr) {
  if ((int)ptr == ((int)ptr & pageMask))
    return ptr;
  else
    return ((void*)((int)ptr & pageMask) + 1024);
}
void* roundDownToPage(void* ptr) {
  return (void*)((int)ptr & pageMask);
}

void* roundUpToBoundary(void* ptr) {
  if ((int)ptr == ((int)ptr & eightByteAlignMask))
    return ptr;
  else
    return (void*)(((int)ptr & eightByteAlignMask) + 2);
}
void* roundDownToBoundary(void* ptr) {
  return (void*)((int)ptr & eightByteAlignMask);
}

int hasLeft(unsigned int val) {
  return (selectLeftMask & val);
}
unsigned int setLeft(unsigned int val) {
  return (selectLeftMask | val);
}
unsigned int unsetLeft(unsigned int val) {
  return (~selectLeftMask & val);
}
int hasRight(unsigned int val) {
  return (selectRightMask & val);
}
unsigned int setRight(unsigned int val) {
  return (selectRightMask | val);
}
unsigned int unsetRight(unsigned int val) {
  return (~selectRightMask & val);
}
int isUsed(unsigned int val) {
  return (selectUsedMask & val);
}
unsigned int setUsed(unsigned int val) {
  return (selectUsedMask | val);
}
unsigned int unsetUsed(unsigned int val) {
  return (~selectUsedMask & val);
}
unsigned int getSize(unsigned int val) {
  return (selectSizeMask & val);
}
unsigned int setSize(unsigned int val, unsigned int size) {
  return ((selectSizeMask & size) | (~selectSizeMask & val));
}



typedef struct {
  void* next;
} freePage;


typedef struct {
  unsigned short size; // these 2 bytes need to be placed before the pointer
                       // that is returned from malloc
  // the 16 bits are of the form:
  // |l|s|s|s|s|s|s|s|s|s|s|s|s|s|r|u|
  // where s stores size data,
  // r refers to whether this spot in memory is a right hand buddy,
  // u refers to whether this memory is in use,
  // and l refers to whether this spot in memory is a left hand buddy
  
  void* next;
  void* prev;
} memSpot;


// a size is equal to the storage space
//  free space is smaller by 2 bytes
typedef struct {
  memSpot* size8list;    // smaller than this has wasted space due to byte allignment
                         // so this is as small as I am going to go
  memSpot* size16list;
  memSpot* size32list;
  memSpot* size64list;
  memSpot* size128list;
  memSpot* size256list;
  memSpot* size512list;
  memSpot* size1024list;
  memSpot* size2048list;
  memSpot* freePageList; // list of unused pages
} heapControl;


int getLargestSize(int);

void addToList(memSpot**, memSpot*);
void addToFree(heapControl*, memSpot*);

int distributePage(heapControl*);

memSpot* findSpot(heapControl*, int);

void setList(heapControl*, int, memSpot*);

memSpot* searchPageList(heapControl*, int);

int mm_init (void) {
  heapControl* heap = roundUpToPage(dseg_lo);
  int freeSpace, chunkSize;
  char* unusedStart;
  memSpot* curr;

//  printf("#  called mm_init\n");

  mem_sbrk(4096);
  
  freeSpace = freeMem();
  unusedStart = dseg_lo;

  if (freeSpace < 40)
    return -1;

  heap->size8list = NULL;
  heap->size16list = heap->size32list = NULL;
  heap->size64list = heap->size128list = NULL;
  heap->size256list = heap->size512list = NULL;
  heap->size1024list = heap->size2048list = NULL;
  heap->freePageList = NULL;

  freeSpace -= 46;  // 6 extra bytes to align to 8bytes
  unusedStart += 46;

//  printf("#    freeSpace = %d\n", freeSpace);
//  printf("#    unusedStart = %d\n", (int)unusedStart);

  chunkSize = getLargestSize(freeSpace);
  
  while(chunkSize) {
    curr = (memSpot*)unusedStart;
    curr->size = chunkSize;
    addToFree(heap, curr);

    freeSpace -= chunkSize;
    unusedStart += chunkSize;
    chunkSize = getLargestSize(freeSpace);
  }

  return 0;
}

void *mm_malloc (size_t size) {
  heapControl* heap = (heapControl*)dseg_lo;
  memSpot* spot;
  void* loc = NULL;

//  printf("#  mm_malloc: size = %d\n", size);

//  printf("#    size = %d\n", size);

  spot = findSpot(heap, size);

  if (spot)
    loc = (void*)((char*)spot + 2);
  else
    printf("#    returning NULL\n");
  
  spot->size = setUsed(spot->size);

//  printf("#    loc = %d; %x; rsize = %d; l = %d, r = %d\n", (int)loc, (int)loc, getSize(spot->size), hasLeft(spot->size) >> 15, hasRight(spot->size) >> 1);

  return loc;
}

void mm_free (void *ptr) {
  memSpot* spot;
  heapControl* heap = (heapControl*)dseg_lo;
  memSpot* auxSpot;

//  printf("#  called mm_free: ptr = %x\n", ptr);
 
  spot = (memSpot*)((char*)ptr - 2);

  spot->size = unsetUsed(spot->size);

  if (getSize(spot->size) == 4088) {
    addToFree(heap, spot);
    return;
  }

  if (getSize(spot->size) > 4088) {
    spot->size = getSize(spot->size);
    addToFree(heap, spot);
    return;
  }
  
  if (hasRight(spot->size)) {
    auxSpot = (memSpot*)((char*)spot + getSize(spot->size));
    if (!isUsed(auxSpot->size) && (getSize(auxSpot->size) == getSize(spot->size))) {
//      printf("#    coalescing right\n");
      spot->size = unsetRight(setSize(spot->size, getSize(spot->size) * 2));
      if (auxSpot->prev)
	((memSpot*)auxSpot->prev)->next = auxSpot->next;
      else
	setList(heap, getSize(auxSpot->size)/2, spot->next);
      if (auxSpot->next)
	((memSpot*)auxSpot->next)->prev = auxSpot->prev;

      if (hasLeft(spot->size)) {
	auxSpot = (memSpot*)((char*)spot - getSize(spot->size));
	if (!isUsed(auxSpot->size) && (getSize(auxSpot->size) == getSize(spot->size))) {
//	  printf("#    coalescing left\n");
	  spot->size = 0;
	  spot = auxSpot;
	  spot->size = unsetLeft(setSize(spot->size, getSize(spot->size) * 2));
	  if (spot->prev)
	    ((memSpot*)spot->prev)->next = spot->next;
	  else
	    setList(heap, getSize(spot->size)/2, spot->next);
	  if (spot->next)
	    ((memSpot*)spot->next)->prev = spot->prev;
	}
      }

    }
  }

  
  if (hasLeft(spot->size)) {
    auxSpot = (memSpot*)((char*)spot - getSize(spot->size));
    if (!isUsed(auxSpot->size) && (getSize(auxSpot->size) == getSize(spot->size))) {
//      printf("#    coalescing left 2: spot = %x; auxSpot = %x\n", spot, auxSpot);
      spot->size = 0;
      spot = auxSpot;
      spot->size = unsetLeft(setSize(spot->size, getSize(spot->size) * 2));
      if (spot->prev) {
//	printf("had prev\n");
	((memSpot*)spot->prev)->next = spot->next;
      } else {
//	printf("no prev\n");
	setList(heap, getSize(spot->size)/2, spot->next);
      }
      if (spot->next) {
//	printf("had next\n");
	((memSpot*)spot->next)->prev = spot->prev;
      }
    }
  }
  
  addToFree(heap, spot);
}


int getLargestSize(int size) {
//  printf("#   running getLargestSize\n");

  if (size >= 2048) return 2048;
  if (size >= 1024) return 1024;
  if (size >= 512) return 512;
  if (size >= 256) return 256;
  if (size >= 128) return 128;
  if (size >= 64) return 64;
  if (size >= 32) return 32;
  if (size >= 16) return 16;
  if (size >= 8) return 8;
  return 0;
}


void addToList(memSpot** head, memSpot* spot) {
//  printf("#   running addToList. size = %d\n", spot->size);

  spot->prev = NULL;
  
  if (*head) {
    (*head)->prev = spot;
    spot->next = *head;
  } else {
    spot->next = NULL;
//    printf("#    no head\n");
  }
  *head = spot;
}  

void addToFree(heapControl* heap, memSpot* spot) {
  int size = getSize(spot->size);

  //  printf("#   running addToFree\n");

  if (size >= 4088)
    addToList(&(heap->freePageList), spot);
  else if (size >= 2048)
    addToList(&(heap->size2048list), spot);
  else if (size >= 1024)
    addToList(&(heap->size1024list), spot);
  else if (size >= 512)
    addToList(&(heap->size512list), spot);
  else if (size >= 256)
    addToList(&(heap->size256list), spot);
  else if (size >= 128)
    addToList(&(heap->size128list), spot);
  else if (size >= 64)
    addToList(&(heap->size64list), spot);
  else if (size >= 32)
    addToList(&(heap->size32list), spot);
  else if (size >= 16)
    addToList(&(heap->size16list), spot);
  else if (size >= 8)
    addToList(&(heap->size8list), spot);
}


int distributePage(heapControl* heap) {
  int freeSpace, chunkSize;
  char* unusedStart;
  memSpot* curr;

//  printf("#    running distributePage\n");

  freeSpace = 4088;

  unusedStart = (char*)searchPageList(heap, 4088);

  if (!unusedStart) {
    unusedStart = (char*)next_page_mem_spot;
    
    mem_sbrk(4096);
    if ((void*)(unusedStart + 4088) > (void*)dseg_hi) {
      //    printf("#    sbrk didn't give enough RAM\n");
      return 0;
    }
  }

  chunkSize = getLargestSize(freeSpace);
  
  while(chunkSize) {
    curr = (memSpot*)unusedStart;
    curr->size = chunkSize;
    addToFree(heap, curr);

    freeSpace -= chunkSize;
    unusedStart += chunkSize;
    chunkSize = getLargestSize(freeSpace);
  }

  return 1;
}


memSpot* findSpot(heapControl* heap, int size) {
  memSpot** list;
  memSpot* spot;
  memSpot* auxSpot;
  int realSize;

  void* temp;
  
//  printf("#   running findSpot; ");

  if (size <= 6) {
    list = &(heap->size8list);
    realSize = 8;
  } if (size <= 14) {
    list = &(heap->size16list);
    realSize = 16;
  } else if (size <= 30) {
    list = &(heap->size32list);
    realSize = 32;
  } else if (size <= 62) {
    list = &(heap->size64list);
    realSize = 64;
  } else if (size <= 126) {
    list = &(heap->size128list);
    realSize = 128;
  } else if (size <= 254) {
    list = &(heap->size256list);
    realSize = 256;
  } else if (size <= 510) {
    list = &(heap->size512list);
    realSize = 512;
  } else if (size <= 1022) {
    list = &(heap->size1024list);
    realSize = 1024;
  } else if (size <= 2046) {
    list = &(heap->size2048list);
    realSize = 2048;
  } else if (size <= 4088) {
    list = &(heap->freePageList);
    realSize = 4088;
  } else {
    list = NULL;
    realSize = (pageMask & (size + 6));
    if (realSize != size)
      realSize += 4096;

    spot = searchPageList(heap, realSize);

    if (spot)
      return spot;
  }

//  printf("realSize = %d\n", realSize);

  if (list && *list) {
    spot = *list;
    *list = (*list)->next;
    if (*list)
      (*list)->prev = NULL;
    spot->size = setSize(spot->size, realSize);
    return spot;
  }

  if (realSize < 2048) {
//    printf("#    splitting block\n");
    auxSpot = findSpot(heap, (realSize * 2) - 2);
    spot = (memSpot*)((unsigned int)auxSpot + realSize);
//    printf("#    splitting block: spot = %x; auxSpot = %x; realSize = %d\n", (int)spot, (int)auxSpot, realSize);
    auxSpot->size = setRight(setSize(spot->size, realSize));
    spot->size = setLeft(realSize);
    addToFree(heap, auxSpot);
    return spot;
  }

  if (realSize == 2048) {
    if (!distributePage(heap)) return NULL;
    return findSpot(heap, size);
  }

  if (realSize <= 4088) {
    spot = next_page_mem_spot;
    mem_sbrk(4096);
    if ((void*)((char*)spot + 4088) > (void*)dseg_hi) {
//      printf("#    sbrk didn't give enough RAM: %d; %d\n", (int)spot, (int)dseg_hi);
      return NULL;
    }
    spot->size = 4088;
    return spot;
  }
  
  temp = (void*)dseg_hi;
  spot = next_page_mem_spot;
  mem_sbrk(realSize);
  if ((void*)((char*)spot + realSize - 8) > (void*)dseg_hi) {
    printf("#    sbrk suxors: dseg_hi = %x; spot + realSize = %x\n", (int)dseg_hi, (int)spot + realSize);
//    printf("#    realSize = %d; old dseg_hi = %d; new dseg_hi = %d\n", realSize, temp, dseg_hi);
    return NULL;
  }
  spot->size = realSize;
  return spot;

//  printf("#    couldn't find spot\n");

  return NULL;
}


void setList(heapControl* heap, int size, memSpot* newSpot) {
  memSpot** list;

  if (size == 8) {
    list = &(heap->size8list);
//    printf("list is 8\n");
  } if (size == 16) {
    list = &(heap->size16list);
//    printf("list is 16\n");
  } else if (size == 32) {
    list = &(heap->size32list);
//    printf("list is 32\n");
  } else if (size == 64) {
    list = &(heap->size64list);
//    printf("list is 64\n");
  } else if (size == 128) {
    list = &(heap->size128list);
//    printf("list is 128\n");
  } else if (size == 256) {
    list = &(heap->size256list);
//    printf("list is 256\n");
  } else if (size == 512) {
    list = &(heap->size512list);
//    printf("list is 512\n");
  } else if (size == 1024) {
    list = &(heap->size1024list);
//    printf("list is 1024\n");
  } else if (size == 2048) {
    list = &(heap->size2048list);
//    printf("list is 2048\n");
  } else if (size == 4088) {
    list = &(heap->freePageList);
//    printf("list is 4096\n");
  } else return;

  *list = newSpot;
}


memSpot* searchPageList(heapControl* heap, int size) {
  memSpot* curr = heap->freePageList;
 
  while(curr) {
    if (curr->size == size) {
      if (curr->prev)
	((memSpot*)curr->prev)->next = curr->next;
      else
	heap->freePageList = curr->next;
      if (curr->next)
	((memSpot*)curr->next)->prev = curr->prev;
      return curr;
    }
    
    curr = curr->next;
  }

  return NULL;
}
