/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

/* our blocks will contain size, prevsize, and two pointers to make a double linklist
 * all sizes are in bytes
 * header is 16 bytes, however, the next and prev pointers occupy the 2nd 8bytes
 *  and when mm_malloc returns a pointer, it points to the location immediately after prevsize
 *  so the effective header size for a used block is 8bytes
 * we do imediate coalasing in free
 * the first element of the array keeps pointer to the beginning of
 *   the last free block of the heap
 *   also, it contains the size of the heap
 */

team_t team = {
    /* Team name to be displayed on webpage */
    "Bug breeders",
    /* First member full name */
    "Daniel Ting",
    /* First member email address */
    "dting",
    /* Second member full name (leave blank if none) */
    "Alex Shtut",
    /* Second member email address (blank if none) */
    "ashtut"
};

#define PAGESIZE 4096
#define INIT_HEAP_SIZE 4096
#define SEGARR_SIZE 15
#define UTMAX ~0
#define SIZEMASK 0xfffffffe

#define markused(b)  (b->size|=1)
#define markfree(b)  (b->size&=SIZEMASK)
#define bsize(b)     (b->size&SIZEMASK)
#define bprevsize(b) (b->prevsize)
#define isfree(b)    (!((b->size)&1))

#define heapsize      (((segtype *)heap)->binsize)
#define topblock      ((header *)(((segtype *)heap)->list))
#define segarr_start  (((segtype *)heap)+1)
#define heapstart     (header *)(((segtype *)heap)+SEGARR_SIZE+1)

#define inheap(p)    (p>=heapstart)
#define printblock(b) printf("%p s:%d ps:%d pv:%p nx:%p\n",b,b->size, b->prevsize, b->prev, b->next)

char *heap;

typedef struct HEADER {
    size_t size, prevsize;
    struct HEADER *next, *prev;
} header;

typedef struct {
    size_t size, prevsize;
} usedheader;

typedef struct {
    header *list;
    size_t binsize;
} segtype;


int log2(int x) {
  int m16 = ((1<<16) + ~0) << 16;                         /* groups of 16 */
  int m8 = (((1<<8)  + ~0) << 24) + (((1<<8) + ~0) << 8); /* groups of 8 */
  int m4 = (0xf0<<24) + (0xf0<<16) + (0xf0<<8) + 0xf0;    /* groups of 4 */
  int m2 = (0xcc<<24) + (0xcc<<16) + (0xcc<<8) + 0xcc;    /* groups of 2 */
  int m1 = (0xaa<<24) + (0xaa<<16) + (0xaa<<8) + 0xaa;    /* groups of 1 */
  int result = 0;
  int upper;
  int mask;

  /* m16 */
  upper = !!(x & m16);
  result += upper << 4;
  mask = m16 ^ ~((upper<<31)>>31);

  /* m8 */
  upper = !!(x & m8 & mask);
  result += upper << 3;
  mask &= (m8 ^ ~((upper<<31)>>31)); 

  /* m4 */
  upper = !!(x & m4 & mask);
  result += upper << 2;
  mask &= (m4 ^ ~((upper<<31)>>31)); 

  /* m2 */
  upper = !!(x & m2 & mask);
  result += upper << 1;
  mask &= (m2 ^ ~((upper<<31)>>31)); 

  /* m1 */
  upper = !!(x & m1 & mask);
  result += upper;

  return result;
}

/* inserts a block into the beginning of the apropriet list */
/* list is sorted before and after*/
void insert(header *block)
{
    segtype *segarr = segarr_start; /* points to the first list */
    header *cur;
    
    /*look until it finds something less or equal */
    while(block->size > segarr->binsize) { 
	segarr++;
    }

    /* looks for an apropriate spot in the list */
    if(segarr->list != NULL) {
	cur = segarr->list;
	if(bsize(cur) >= bsize(block)) {
	    block->next = cur; /* block points to the old first element */
	    block->prev = (header *)segarr; /* block points back to segarr */
	    segarr->list = block; /*array points to block */
	    cur->prev=block;
	} else {
	    while((cur->next != NULL)&& bsize(cur) < bsize(block))
		cur = cur->next;
		
	    if(cur->next == NULL && bsize(cur) < bsize(block)) {
		cur->next = block;
		block->prev = cur;
		block->next = NULL;
	    } else {
		block->next = cur->next;
		block->prev = cur;
		if(cur->next)
		    cur->next->prev=block;
		cur->next = block;
	    }
	}
	
    }
  
    else {
	block->next = segarr->list; /* block points to the old first element */
      	block->prev = (header *)segarr; /* block points back to segarr */
	segarr->list = block; /*array points to block */
    }
    
}


/* finds a block of big enough size */
header *find(size_t size)
{
    segtype *segarr = segarr_start;
    header *block = NULL;
    int notfound = 1;
    
    /*looks until it finds something greater or equal or gets upto the end of the list */
    while((segarr->binsize != UTMAX)&&(notfound)) { 
	/*looks in the list if it has apropriet size and not empty */
	if((segarr->binsize >= size)&&(segarr->list != NULL)) {
	    block = segarr->list;
            /* looks until it find the big enough block or hits the end */	    
	    while((block != NULL)&&(block->size < size))
		block = block->next;
	    
	    if(block != NULL) notfound = 0;
	}
	
	segarr++;	
    }   
     /* special case for the last list */
    if((notfound)&&(segarr->binsize == UTMAX))
	if(segarr->list != NULL) {
	    block = segarr->list;
            /* looks until it find the big enough block or hits the end */	    
	    while((block != NULL)&&(block->size < size))
		block = block->next;
	}
    
    return block;
}


header *expand(size_t size)
{
    header *newblock;

    if(isfree(topblock))
	size=size-bsize(topblock);
   
    newblock=mem_sbrk(size);
    
    if(!newblock)
	return NULL;

    if(isfree(topblock)) {
	newblock=topblock;
        /*add the additional heapsize to the existing topblock*/
	newblock->size += mem_usage()-heapsize;  
	/*remove topblock from the list and reinsert it*/
	if(inheap(newblock->prev))
	    newblock->prev->next=newblock->next;
	else
	    ((segtype*)(newblock->prev))->list=newblock->next;

	if(newblock->next)
	  newblock->next->prev=newblock->prev;
    } else {
	newblock->prevsize=bsize(topblock);
	newblock->size = mem_usage()-heapsize;
	topblock=newblock;
    }
    insert(newblock);    
    heapsize=mem_usage();
    return topblock;
}


void split(header *block, size_t size)
{
    header *newblock, *next;
    
    /*don't split*/
    if(bsize(block) < size+16) {
	markused(block);
        /*remove from list*/
	if(inheap(block->prev))
	    block->prev->next=block->next;
	else
	    ((segtype*)(block->prev))->list=block->next;

	if(block->next)
	    block->next->prev=block->prev;
    } else {
	newblock=(header *)((char*)block+size);
	newblock->size=bsize(block)-size;
	newblock->prevsize=size;

	if(topblock==block)
	    topblock=newblock;
	else {
	  next=(header*)((char*)newblock+bsize(newblock));
	  next->prevsize=bsize(newblock);
	}

        /*remove from list*/
	if(inheap(block->prev))
	    block->prev->next=block->next;
	else
	    ((segtype*)(block->prev))->list=block->next;

	if(block->next)
	    block->next->prev=block->prev;
	block->size=size;
	markused(block);
	insert(newblock);
    }
}


int mm_init (void)
{
    header *newblock;
    segtype *segarr;
    int i;
    
    heap = mem_sbrk(INIT_HEAP_SIZE);
    if(!heap)
	return -1;
    heapsize = mem_usage();

    /*initialize segarr*/
    for(segarr=segarr_start, i=0; i<SEGARR_SIZE-1; i++) {
	segarr[i].list=NULL;
    }
    /*set the binsizes*/
    segarr[0].binsize=16;
    segarr[1].binsize=24;
    segarr[2].binsize=32;
    segarr[3].binsize=48;
    segarr[4].binsize=64;
    segarr[5].binsize=96;
    segarr[6].binsize=128;
    segarr[7].binsize=256;
    segarr[8].binsize=512;    
    segarr[9].binsize=1024;    
    segarr[10].binsize=2048;    
    segarr[11].binsize=4096;    
    segarr[12].binsize=8192;    
    segarr[13].binsize=16384;    
    segarr[SEGARR_SIZE-1].list=NULL;
    segarr[SEGARR_SIZE-1].binsize=UTMAX;
    
    /*initialize newblock */
    newblock = heapstart;
    newblock->prevsize=0; /*only the first block in the heap has prevsize 0*/
    newblock->size=(size_t)(heap+heapsize+1)-(size_t)(heapstart);
    insert(newblock);
    topblock=newblock;
    
    return 0;
}


void *mm_malloc (size_t size)
{
    header *block;
    int tmp;

    if(size<=512) {
	tmp=1<<log2(size);
	if(size==tmp)
	    size+=8;
	else
	    size = (tmp<<1)+8;
	
    } else
	/*8 byte align and add 8 bytes for header*/
	size = ((size+7)/8)*8+8;
    
    /* finds an apropriate block */
    block = find(size);
    if(block)
	split(block, size);
    else {
	/* if there is no such block then expand the heap*/
	block = expand(size);
	if(block)
	    split(block, size);
	else
	    return NULL;
    }
    return (usedheader *)block+1;
}


void mm_free (void *ptr)
{
    header *block, *prev, *next, *newblock, *next2;

    /*align block so it includes the header*/ 
    block = (header*)((usedheader*)ptr-1);
    /*find the blocks before and after block in the heap*/
    prev = (header *)((char*)block-bprevsize(block));
    next = (header *)((char*)block+bsize(block));

    /*check that block isn't the first block and that the prev block is free*/
    if(bprevsize(block) && isfree(prev)) {
	newblock=prev;
	newblock->size += bsize(block);
        /*remove from list*/
	if(inheap(prev->prev))
	    prev->prev->next=prev->next;
	else
	    ((segtype*)(prev->prev))->list=prev->next;

	if(prev->next)
	    prev->next->prev=prev->prev;
	
	/*prevsize should still be OK*/
	if(topblock==block)
	    topblock=newblock;
	else {
	  next2=(header *)((char *)newblock+bsize(newblock));
	  next2->prevsize=bsize(newblock);
	}
    } else 
	newblock=block;
    
    /*checks if there is a next block and if it's free*/
    if(newblock != topblock && isfree(next)) {
	newblock->size += bsize(next);
        /*remove from list*/
	if(inheap(next->prev))
	    next->prev->next=next->next;
	else
	    ((segtype*)(next->prev))->list=next->next;

	if(next->next)
	    next->next->prev=next->prev;

	if(topblock==next)
	    topblock=newblock;
	else {
	  next2=(header *)((char *)newblock+bsize(newblock));
	  next2->prevsize=bsize(newblock);
	}
    }
    
    markfree(newblock);
    insert(newblock);
    
}

