#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "<font color=red><b>puk-tik, yawar k'ocha</b></font>",
    /* First member full name */
    "Andrew Gardner",
    /* First member email address */
    "asg",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};



/*
  DESCRIPTION:

  Implementations of mm_init, mm_malloc, and mm_free for CS
  213 Lab 3.  mm_init initializes the memory space, and
  mm_malloc and mm_free manage it.  As far as I can tell,
  it doesn't leak memory anymore, although when it did leak
  some memory it was two orders of magnitude faster and only
  10% less memory efficient, if you can call anything that
  looses that much memory "efficient."

  ALGORITH:

  Free chunks are stored in a singly linked list.  This
  is the main cause of the extreme slowness.  It is also
  why the code is simple.  The other reason the code is
  simple and exceedingly slow is because the data in the
  free list is unordered, and the first acceptable chunk
  is used.  To not waste too much memory, a chunk is split
  if it is at least 2 times larger than it needs to be.

  There is no coalescing.  This might help performance.
  Segregated free lists would also be of great benefit.

  */



/* important pointers and their friends */
#define free_list_root_ptr (*((int*)(dseg_lo)))
#define wilderness_chunk_ptr (*((int*)(dseg_lo+4)))

/* used to make overhead stuff */
#define OFFSET 8



/* --------------------> mm_init <-------------------- */

int mm_init (void) {
  int SYS_PAGE_SIZE;
  int INIT_MEM_SIZE; /* initial memory size request */
  int i,j,length;  /* counters, a temp */
  int* curr;
  int mem_init_length;

  int mem_init_chunks[] = { 1, 4104, /* make left chunks of right size*/
			    2, 8200,
			    1,  16 }; /* wilderness chunk */

  mem_init_length = 6;

  INIT_MEM_SIZE = 0;
  
  SYS_PAGE_SIZE = mem_pagesize();

  /* 
     Find INIT_MEM_SIZE 
  */

  for( i = 0; i < mem_init_length; i += 2 ){
    INIT_MEM_SIZE += ( ( mem_init_chunks[i+1] ) ) * mem_init_chunks[i];
  }
  INIT_MEM_SIZE += OFFSET; /* for housekeeping overhead, alignment */

  /* remember how big we are (should be later, but value here now) */
  (int*)wilderness_chunk_ptr = INIT_MEM_SIZE;
  
  /* 
     Make INIT_MEM_SIZE request
  */

  if( !mem_sbrk( INIT_MEM_SIZE ) )
    return 1;

  *(dseg_lo) = 0;

  /* 
     Prepare housekeeping overhead words
  */

  /* make free_list_root_ptr */
  (int*)free_list_root_ptr = (int*)dseg_lo+4;

  /* make all of the ckunkies, setting headers and things */

  curr = (int*)dseg_lo+4;

  for( i=1; i<mem_init_length; i+=2 ){ /* for each chunk size */
    for( j=0; j<mem_init_chunks[i-1]; j+=1 ){ /* make this many chunks */
             
      length = mem_init_chunks[i];
      
      if( i == mem_init_length-1 )
	length = (int)dseg_hi - (int)dseg_lo+4 + OFFSET;
       
      /* first step, write length in header */
      /**((int*)current_ptr) = length;*/
      
      *curr = length;

      /* second  step, write forward pointer */

      *(curr+1)= (int)curr+length;
 
      curr += length/4;
    }
  }

  /* modify the wilderness chunk */
  
  curr -= length/4;

  length = (int)dseg_hi - (int)curr;
  *curr = length;
  *(curr+length/4-1) = length;
  *(curr+1)= 0;

  wilderness_chunk_ptr = (int)curr;

  return 0;
}



/* --------------------> mm_malloc <------------------ */

void *mm_malloc( size_t size ) {

  int *curr, *prev_f, *prev, *extra_chunk;
  int lsize;

  /* algorith:
     attempt to find something useful in the free list
     if there isn't anything in the free list, mem_sbrk
     more memory
     */

  curr = (int*)free_list_root_ptr;

  size += 8;

  prev = NULL;

  /* search the free list */

  while( curr != NULL ){
    if( *curr > size ){
      *(curr+2) = (int)prev;
      goto found;
    }
    prev = curr;
    curr = (int*)*(curr+1);
  }
  
  /* couldn't find anything in the free list,
     must mem_sbrk new memory */
  
  lsize = ((size+8)/8) * 8;
  curr = (int*)(dseg_hi+1);
  *curr = lsize;

  if(!mem_sbrk( lsize )){
    return NULL;
  }

  return curr+2;
  
 found:
  
  /* need to remove current node from the free list */
  
  /* first, make previous node point to my next node */
  prev_f = (int*)*(curr+2);
  if( prev_f ){
    prev_f++;
    *prev_f = *(curr+1);
  }else{
    free_list_root_ptr = *(curr+1);
  }

  /* we may need to hurt this chunk */
  
  if( *curr > 2*size ){

    /* 
       now that we've established that this is a dumb 
       malloc to make, give back a chunk of size+8 and
       turn the extra into a new chunk to put on the
       free list
    */
    
    lsize = ((size+8)/8)*8;
    
    extra_chunk = curr+lsize/4;
    *extra_chunk = *curr-lsize;
  
    *curr = lsize;

    /* put extra chunk on the free list */

    *(extra_chunk+1) = free_list_root_ptr;
    
    free_list_root_ptr = (int)extra_chunk;
    
  }
  
  return curr+2;
  
}



/* --------------------> mm_free<--------------------- */

void mm_free( void *ptr ){

  int *chunk;
  
  chunk = (int*)ptr - 2;
  
  /* prepend to the free list */

  *(chunk+1) = free_list_root_ptr;
  
  free_list_root_ptr = (int)chunk;    
  
}
