//* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>
#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Run program under gdb!",
    /* First member full name */
    "Aditya Ganjam",
    /* First member email address */
    "aganjam",
    /* Second member full name (leave blank if none) */
    "Vishal Radhakrishnan",
    /* Second member email address (blank if none) */
    "vishal"
};



/* figured we will use our own implementation of log2, 
   think its comparable or faster than one provided */
int log2(int x)
{

int t=!!(x>>16);
int y=~(t+~0);
int count =0;
count = y & 16;
x =(y&(x>>16))|(x&~y);

t=!!(x>>8);
y=~(t+~0);
count = count + (y & 8);
x=(y&(x>>8))|(x&~y);

t=!!(x>>4);
y=~(t+~0);
count =count+ (y & 4);
x=(y&(x>>4))|(x&~y);

t=!!(x>>2);
y=~(t+~0);
count=count+(y & 2);
x=(y&(x>>2))|(x&~y);

t=!!(x>>1);
y=~(t+~0);
count = count+ (y & 1);
x=(y&(x>>1))|(x&~y);

return count;
}



/* This function initializes the heap */


/* There are two cases:
   1 -> when the heap is empty : then initialize enough memory for 
   the neccessary data that I have to store

   2 -> the heap is already existant, then make the pointers look at the
   beginning and think of the existing heap as all unallocated stuff

   THE CONTROL DATA THAT IS STORED
   
   (int*)dseg_lo(or p as it is called right through the program) is
   our current pointer which will point to the front guard of a block of
   memory (usually). When we allocate memory, p will continue to point to the 
   front guard of the allocated block. We will begin searches for allocating
   new blocks of memory from p onwards. But ofcourse, we come to the question
   of the free blocks that are before p which either existed or are now free.
   Therefore we have (int*)(dseg_lo+4) which will keep count of the number of
   times malloc is called. (reps) Everytime it is called, it will be incremented and
   when we reach a certain number (50) we reset the counter and then we reset
   p to the beginning of the list from where it works like it did at the very 
   first call to malloc.
   
   As we are implementing a First fit allocation algorithm, we have each memory
   block have "guards" - both front and back which contain the # of bytes the 
   block as a whole contains (including two of the 4 byte words for the guards)
   Thus the rest of the allocated memory when we first mem_sbrk, will have to 
   put into the guard-controlled mem system, thus we have two words with 8 
   stored in them.(this is to get the 8 byte offset necessary for the beginning
   of data)
   */


int mm_init (void)
{
 
  int* p;
  int memuse;
  if (mem_usage() == -1)
    p = mem_sbrk(20);             /* Allocate 20 bytes, we need to store the number of repetitions, and the */
  else                            /* pointer to the current block that is looked at                         */
    p = (int*)dseg_lo;
  *(int*)(dseg_lo+4)=50;
  memuse=mem_usage();
  if (p)
    {
      *p = (int)(p+3);
      *(p+1) = 0;  
      *(p+2) = 5;
      *(p+3) = 8;
      *(p+4) = 8;
      return 0;  
    }
  else
    return -1;
}





void *mm_malloc (size_t size)
{
  int *ptr, *p;
  int *rear, *q,* myrear;
  int rem;
  int logtwo =0;
  int flag = 0;


  if (*(int*)(dseg_lo+4)>=50) /* This takes care of the reps */
    { /* if it is 50 reset the counter */
      p = (int*)(dseg_lo+12);
      *(int*)(dseg_lo+4) = 0;
    }
  else /* otherwise just increment the counter */
    {
      p = (int*)(*(int*)(dseg_lo));
      *(int*)(dseg_lo+4) +=1;
    }
  
  logtwo = log2(size);
  /* if the size is small, then just take the next higher power
     of two and allocate that amount of memory */
   if ((size<512)&&((size!=(1<<logtwo))))
     size=1<<(logtwo+1);
  
   if (size & 7)/* and anyway make sure its 8-byte aligned */
     size = size + (8 - size%8); 
 
   /*The whole code is arranged under this algorithm. 
     We look at each memory location and if it is occupied or
     if it is too small for what we want to allocate then we loop
     through this goto loop until we reach the right block. if we
     dont reach it we allocate more memory.
     If mem_sbrk fails then we wonder if we actually have some 
     space to allocate and we look from the beginning and if we
     still dont have any space then truly we dont have space in
     heap therefore return NULL.

   */
    
  top: 
   
  rear = p+((*p)>>2)-1; 
  if ((*p & 1)||(*p < (size + 8)))
      { 
	p = rear + 1; /*increment pointer */
	  if (p >= (int*)(dseg_hi-3))/*if we need to allocate */
	    {
	      ptr = mem_sbrk(size+8);
	      if (!ptr)
		    {
		      if (flag == 0)
			{
			  p = (int*)(dseg_lo+4);
			  flag = 1;
			  goto top;
			}
		      else
			  return NULL;   
		    }
	      /* setting the guard bytes*/
	      *p = size + 9;
	      myrear =  p + ((*p)>>2)-1;
	      *myrear = size + 9;
	      *(myrear+1) = 5;
	      (int*)(*(int*)(dseg_lo)) = p;
	      return (p+1);
	    }
	  
	  goto top;                    /* else just loop back and see if we can get some block in the list*/
      }
  else if (*p == size + 8)             /* This code is executed when the size asked for fits exactly into */
    {                                  /* into one of the free blocks.  The code puts a one in the least  */
      *p = (*p)|1;                     /* significant bit of each guard to signify that it has been used  */
      *rear = (*rear)|1;
      (int*)(*(int*)(dseg_lo)) = p;
      return (p+1);
    }
  else if(*p > size + 8)               /* This code is executed when the size asked for id less than the  */
    {                                  /* current free block size.  The code splts the block in two,      */
      q = p + (size>>2) +1;            /* allocates what is needed, and keeps the remaining as free space */
      *q = size+8;
      rem = (*p)-(*q);
      *rear =rem;
      *q=(*q)|1;
      *p=*q;
      *(q+1)=rem;
      (int*)(*(int*)(dseg_lo)) = p;
      return (p+1);
    }
  
 
  return NULL;
}

  
void mm_free (void *p1)
{
   int * left, *rightguard,* right,*ptr=p1; 

   *(int*)(dseg_lo+4) = 50;
   ptr = ptr - 1; 
   left = ptr - ((*(ptr-1))>>2);               /* set left to the guard of the block to the left*/
   rightguard = ptr+((*ptr)>>2)-1;             /* rightguard of the block to free */
   right = rightguard + (*(rightguard+1)>>2);  /* set right to the guard of the block on the right */
   
   *ptr = *ptr - 1;                            /* make ptr point to the guard to free */
   *rightguard = *ptr;
   
   
   if((((*(ptr-1)) & 1) == 0)&&(*(ptr-1)))     /* If the left block is free then coaless the blocks */
     { 
       
       *left += *ptr;                          /*change increase the size of the guards to the new size*/
       *rightguard = *left; 
       ptr = left; 
       
       
     } 
   
   if (rightguard < ((int*)(dseg_hi-7)))       /* If the right block is fre then coaless the block */
     if (((*(rightguard+1)) & 1) == 0) 
       { 
 	  *ptr = *ptr + *right;                /*change the size of the guards to the new size */
 	  *right = *ptr; 
       } 
   
}

  


























