/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "n2",
    /* First member full name */
    "Norman Chen",
    /* First member email address */
    "nkc",
    /* Second member full name (leave blank if none) */
    "Norbert Hu",
    /* Second member email address (blank if none) */
    "nhu"
};

#define GET_VAL(x)   (*((unsigned long *)(x)))
#define GET_SIZE(x)  (*((unsigned long *)(x)) & ~0x7)
#define GET_FLAGS(x) (*((unsigned long *)(x)) & 0x7)

#define ALIGN(p, s)    ((void *)(((unsigned long)(p) / (s)) * (s)))
#define ALIGN_UP(p, s) ((void *)((((unsigned long)(p) + (s) - 1) / (s)) * (s)))

#define MMSEG_LO      (*((char **)(dseg_lo)))
#define MMSEG_HI      (*((char **)(dseg_lo + 0x04)))
#define MMSEG_CURRPTR (*((char **)(dseg_lo + 0x08)))
#define MMSEG_SIZE    (*((unsigned long *)(dseg_lo + 0x0c)))
#define MMSEG_FREE_START (*((char **)(dseg_lo + 0x10)))
#define MMSEG_FREE_END (*((char **)(dseg_lo + 0x14)))

#define SYS_SIZE  (0x18)
#define INIT_SIZE (0x3100)
#define ADD_SIZE  (0x4000)

//#define DEBUG
//#define DEBUG_FREE
//#define PROMPT

unsigned int c = 0;


// mm_init allocates a block of memory on the heap in the beginning with size SYS_SIZE+INIT_SIZE
// The block allocated contains a header block which holds various information of the heap followed
// by a initial empty block of size INIT_SIZE.
int mm_init (void)
{
  // set the initial lo and hi pointers to NULL and initialize the size of the heap to 0
  char * init_lo = NULL;
  char * init_hi = NULL;
  unsigned long init_size = 0;

#ifdef DEBUG
  printf("mm_init start\n");
#endif

  // allocate a size of SYS_SIZE + INIT_SIZE on the heap
  mem_sbrk(SYS_SIZE + INIT_SIZE);

#ifdef DEBUG
  printf("  dseg_lo = %x\n", dseg_lo);
  printf("  dseg_hi = %x\n", dseg_hi);
  printf("  dseg_size = %x\n", dseg_size);
#endif

  // set the init_lo pointer to the address after the SYS_SIZE (the beginning of the actual heap)
  init_lo = (char *)(ALIGN_UP(dseg_lo + SYS_SIZE, 0x4));
 
  if ((((unsigned long)(init_lo)) & 0x3) == 0) {
    init_lo = init_lo + 0x4;
  }

  // adjust the pointer to maintain 8 byte alignment
  init_hi = (char *)(ALIGN(dseg_hi, 0x8));

  if ((((unsigned long)(dseg_hi)) & 0x7) < 0x4) {
    init_hi = init_hi - 0x8;
  }

  init_size = (unsigned long)(init_hi) - (unsigned long)(init_lo) + 0x4;

  // set the head and tail for the initial free block
  *((unsigned long *)(init_lo)) = init_size;
  *((unsigned long *)(init_hi)) = init_size;
  *((char **)(init_lo + 0x04)) = NULL;
  *((char **)(init_lo + 0x08)) = NULL;

  // set initial information
  MMSEG_LO = init_lo;
  MMSEG_HI = init_hi;
  MMSEG_CURRPTR = init_lo;
  MMSEG_SIZE = init_size;
  MMSEG_FREE_START = init_lo;
  MMSEG_FREE_END = init_lo;

#ifdef DEBUG
  printf("  MMSEG_LO = %x\n", (unsigned long)(MMSEG_LO));
  printf("  MMSEG_HI = %x\n", (unsigned long)(MMSEG_HI));
  printf("  MMSEG_CURRPTR = %x\n", (unsigned long)(MMSEG_CURRPTR));
  printf("  MMSEG_SIZE = %x\n", MMSEG_SIZE);
  printf("  MMSEG_FREE_START = %x\n", (unsigned long)(MMSEG_FREE_START));
  printf("  MMSEG_FREE_END = %x\n", (unsigned long)(MMSEG_FREE_END));

  printf("mm_init end\n\n");
#endif

  return 0;
}

// mm_malloc looks for a free space in the heap and allocates a block of size size and returns the
// address to that block.
void *mm_malloc (size_t size)
{
  int loop = 1;
  unsigned long ssize = 0;
  unsigned long tempsegsize = 0;
  unsigned long currsegsize = 0;
  char *currseg = NULL;
  char *tempseg = NULL;
  char *returnseg = NULL;
  char *prevseg = NULL;
  char *nextseg = NULL;

#ifdef DEBUG
  printf("mm_malloc start\n");
#endif
  
  // check the requested size ssize and adjusts it to maintain 8 byte alignment
  ssize = (((size + 7) / 8) * 8);

#ifdef DEBUG
  printf("  MMSEG_LO = %x\n", (unsigned)(MMSEG_LO));
  printf("  MMSEG_HI = %x\n", (unsigned)(MMSEG_HI));
  printf("  MMSEG_SIZE = %x\n", MMSEG_SIZE);
  printf("  MMSEG_FREE_START = %x\n", (unsigned long)(MMSEG_FREE_START));
  printf("  MMSEG_FREE_END = %x\n", (unsigned long)(MMSEG_FREE_END));
  printf("  size = %x\n", size);
  printf("  ssize = %x\n", ssize);
#endif

  // begin by looking for free space at the memory pointed by MMSET_FREE_START
  currseg = MMSEG_FREE_START;

  while (loop) {
#ifdef DEBUG
    printf("> currseg = %x\n", (unsigned long)(currseg));
#endif

    if (currseg == NULL) {
      // if currseg is NULL then there is no more free space big enough in the current heap
      // therefore, more space needs to be allocated for the heap

      // determine the additional space needed							       
      tempsegsize = (ssize + 8) * 2;

      if (tempsegsize < ADD_SIZE) {
	tempsegsize = ADD_SIZE;
      }

      tempseg = mem_sbrk(tempsegsize);

      if (tempseg) {

#ifdef DEBUG
	printf("  adding %x bytes to heap\n", tempsegsize);
#endif
      
	tempseg = MMSEG_HI + 4 - GET_SIZE(MMSEG_HI);
	
	if (GET_FLAGS(tempseg) == 0) {
          // if the last block in the original heap is a free block, then merge with the newly
	  // allocated block of free space	      

	  MMSEG_SIZE = MMSEG_SIZE + tempsegsize;
	  MMSEG_HI = MMSEG_HI + tempsegsize;

	  tempsegsize = tempsegsize + GET_SIZE(tempseg);

	  currseg = tempseg;

#ifdef DEBUG
	  printf("  merging with previous block at %x\n", 
		 (unsigned long)(currseg));
#endif

	  GET_VAL(tempseg) = tempsegsize;

#ifdef DEBUG
	  printf("  created new block (%x - ", (unsigned long)(tempseg));
#endif

	  tempseg = tempseg + tempsegsize;
	  GET_VAL(tempseg - 4) = tempsegsize;

#ifdef DEBUG
	  printf("%x) of %x bytes\n", 
		 (unsigned long)(tempseg - 1),
		 tempsegsize);
#endif


	}
	else {
          // add the allocated block to the end and update the header information of the entire heap
	 
	  tempseg = MMSEG_HI + 4;

	  MMSEG_SIZE = MMSEG_SIZE + tempsegsize;
	  MMSEG_HI = MMSEG_HI + tempsegsize;

	  currseg = tempseg;

	  GET_VAL(tempseg) = tempsegsize;

#ifdef DEBUG
	  printf("  created new block (%x - ", (unsigned long)(tempseg));
#endif

	  tempseg = tempseg + tempsegsize;

#ifdef DEBUG
	  printf("%x) of %x bytes\n", 
		 (unsigned long)(tempseg - 1),
		 tempsegsize);
#endif

	  GET_VAL(tempseg - 4) = tempsegsize;

	  (char *)(GET_VAL(currseg + 0x04)) = NULL;
	  (char *)(GET_VAL(currseg + 0x08)) = MMSEG_FREE_START;

	  if (MMSEG_FREE_START != NULL) {
	    (char *)(GET_VAL(MMSEG_FREE_START + 0x04)) = currseg;
	  }
	  else {
	    MMSEG_FREE_END = currseg;
	  }

	  MMSEG_FREE_START = currseg;
	}
      }
      else {

#ifdef DEBUG
	printf("  failed to add %x bytes to heap\n", tempsegsize);
#endif
	// allocation failed... get out of the loop and return NULL
	loop = 0;
      }
    }
    else {

      currsegsize = GET_SIZE(currseg);

#ifdef DEBUG
      printf("  currsegsize = %x\n", currsegsize);
#endif
    
      if (currsegsize < (ssize + 8)) {

#ifdef DEBUG
	printf("  too small\n");
#endif

	currseg = (char *)(GET_VAL(currseg + 0x08));
      }
      else {
	if ((currsegsize - ssize - 8) < 16) {

#ifdef DEBUG
	  printf("  using whole segment ");
#endif
	
	  prevseg = (char *)(GET_VAL(currseg + 0x04));
	  nextseg = (char *)(GET_VAL(currseg + 0x08));

#ifdef DEBUG
	  printf("  prevseg = %x\n", (unsigned long)(prevseg));
	  printf("  nextseg = %x\n", (unsigned long)(nextseg));
#endif

	  if (prevseg == NULL) {
	    /* head */

#ifdef DEBUG
	    printf("  currseg is head\n");
#endif

	    MMSEG_FREE_START = nextseg;
	  }
	  else {
	    (char *)(GET_VAL(prevseg + 0x08)) = nextseg;
	  }

	  if (nextseg == NULL) {
	    /* tail */

#ifdef DEBUG
	    printf("  currseg is tail\n");
#endif

	    MMSEG_FREE_END = prevseg;
	  }
	  else {
	    (char *)(GET_VAL(nextseg + 0x04)) = prevseg;
	  }

	  returnseg = currseg + 4;
	  
	  GET_VAL(currseg) = currsegsize | 0x1;

	  currseg = currseg + currsegsize;

	  GET_VAL(currseg - 4) = currsegsize | 0x1;

	  loop = 0;
	}
	else {

#ifdef DEBUG
	  printf("  partitioning to ");
#endif
	  // The following code partitions the free space into a block with the required space
	  // and the rest into a new free space.
	  prevseg = (char *)(GET_VAL(currseg + 0x04));
	  nextseg = (char *)(GET_VAL(currseg + 0x08));

	  returnseg = currseg + 4;

	  tempsegsize = ssize + 8;

	  GET_VAL(currseg) = tempsegsize | 0x1;

#ifdef DEBUG
	  printf("(%x - ", (unsigned long)(currseg));
#endif

	  currseg = currseg + tempsegsize;

	  GET_VAL(currseg - 4) = tempsegsize | 0x1;

#ifdef DEBUG
	  printf("%x) %x bytes and (", 
		 (unsigned long)(currseg),
		 tempsegsize);
#endif

	  currsegsize = currsegsize - tempsegsize;

	  GET_VAL(currseg) = currsegsize;
	  GET_VAL(currseg + currsegsize - 4) = currsegsize;

#ifdef DEBUG
	  printf("  %x - %x) %x bytes\n", 
		 (unsigned long)(currseg), 
		 (unsigned long)(currseg + currsegsize - 4),
		 currsegsize);
#endif

#ifdef DEBUG
	  printf("  prevseg = %x\n", (unsigned long)(prevseg));
	  printf("  nextseg = %x\n", (unsigned long)(nextseg));
#endif
	  // Update the header information
	  if (prevseg == NULL) {
	    /* head */

#ifdef DEBUG
	    printf("  prevseg is head\n");
#endif

	    MMSEG_FREE_START = currseg;
	  }
	  else {
	    (char *)(GET_VAL(prevseg + 0x08)) = currseg;
	  }
	  // Update the header information
	  if (nextseg == NULL) {
	    /* tail */

#ifdef DEBUG
	    printf("  nextseg is tail\n");
#endif
	    MMSEG_FREE_END = currseg;
	  }
	  else {
	    (char *)(GET_VAL(nextseg + 0x04)) = currseg;
	  }
	
	  (char *)(GET_VAL(currseg + 0x04)) = prevseg;
	  (char *)(GET_VAL(currseg + 0x08)) = nextseg;
	  // exit the loop
	  loop = 0;
	}
      }
    }
  }  

#ifdef DEBUG
  printf("  returnseg %x\n", returnseg);
  printf("mm_malloc end\n\n");

#ifdef PROMPT
  if (c > 0) {
    printf("waiting for user... (%d)", c);
    getchar();

    c = c - 1;
  }
#endif
#endif
  // return the pointer to the head of the allocated space
  return returnseg;
}

void mm_free (void *ptr)
{
  char * lseg = NULL;
  char * rseg = NULL;
  char * ptrseg = ptr - 4;
  char * prevseg = NULL;
  char * nextseg = NULL;
  
  unsigned long ptrsegsize = 0;

#ifdef DEBUG_FREE
  printf("mm_free start\n");

  printf("  MMSEG_LO = %x\n", (unsigned)(MMSEG_LO));
  printf("  MMSEG_HI = %x\n", (unsigned)(MMSEG_HI));
  printf("  MMSEG_SIZE = %x\n", MMSEG_SIZE);
  printf("  MMSEG_FREE_START = %x\n", (unsigned long)(MMSEG_FREE_START));
  printf("  MMSEG_FREE_END = %x\n", (unsigned long)(MMSEG_FREE_END));
  printf("  ptr = %x\n", ptr);
#endif

  lseg = ptrseg - GET_SIZE(ptrseg - 4);

#ifdef DEBUG_FREE
  printf("  testing left seg at %x (%x - %x)\n", 
	 lseg,
	 ptrseg,
	 GET_SIZE(ptrseg - 4));
#endif

  ptrsegsize = GET_SIZE(ptrseg);

  if ((lseg < MMSEG_LO) || (GET_FLAGS(lseg) != 0)) {
    /* don't merge left */

    lseg = ptrseg;

#ifdef DEBUG_FREE
    printf("  moving left seg back to %x\n", lseg);
#endif

    rseg = ptrseg + GET_SIZE(ptrseg);

#ifdef DEBUG_FREE
    printf("  testing right seg at %x\n", rseg);
#endif

    if ((rseg < MMSEG_HI) && (GET_FLAGS(rseg) == 0)) {
      /* merge right */

      prevseg = (char *)(GET_VAL(rseg + 0x04));
      nextseg = (char *)(GET_VAL(rseg + 0x08));
      
      ptrsegsize = ptrsegsize + GET_SIZE(rseg);
      
#ifdef DEBUG_FREE
      printf("  extending right seg to %x\n", rseg);
#endif

      if (prevseg == NULL) {
	/* rseg is head */
	
	MMSEG_FREE_START = ptrseg;
      }
      else {
	(char *)(GET_VAL(prevseg + 0x08)) = ptrseg;
      }

      if (nextseg == NULL) {
	/* rseg is tail */

	MMSEG_FREE_END = ptrseg;
      }
      else {
	(char *)(GET_VAL(nextseg + 0x04)) = ptrseg;
      }
      
      (char *)(GET_VAL(ptrseg + 0x04)) = prevseg;
      (char *)(GET_VAL(ptrseg + 0x08)) = nextseg;

      GET_VAL(ptrseg) = ptrsegsize;
      rseg = ptrseg + ptrsegsize;
      GET_VAL(rseg - 4) = ptrsegsize;
    }
    else {
      /* don't merge right */

      (char *)(GET_VAL(ptrseg + 0x04)) = NULL;
      (char *)(GET_VAL(ptrseg + 0x08)) = MMSEG_FREE_START;

      if (MMSEG_FREE_START != NULL) {
	(char *)(GET_VAL(MMSEG_FREE_START + 0x04)) = ptrseg;
      }
      else {
	MMSEG_FREE_END = ptrseg;
      }

      MMSEG_FREE_START = ptrseg;
    }
  }
  else {
    /* merge left */

    rseg = ptrseg + GET_SIZE(ptrseg);

#ifdef DEBUG_FREE
    printf("  testing right seg at %x\n", rseg);
#endif

    if ((rseg < MMSEG_HI) && (GET_FLAGS(rseg) == 0)) {
      /* merge right */

      prevseg = (char *)(GET_VAL(rseg + 0x04));
      nextseg = (char *)(GET_VAL(rseg + 0x08));
      
      ptrsegsize = ptrsegsize + GET_SIZE(lseg) + GET_SIZE(rseg);
      
#ifdef DEBUG_FREE
      printf("  extending right seg to %x\n", rseg);
#endif

      if (prevseg == NULL) {
	/* rseg is head */
	
	MMSEG_FREE_START = nextseg;
      }
      else {
	(char *)(GET_VAL(prevseg + 0x08)) = nextseg;
      }

      if (nextseg == NULL) {
	/* rseg is tail */

	MMSEG_FREE_END = prevseg;
      }
      else {
	(char *)(GET_VAL(nextseg + 0x04)) = prevseg;
      }

      GET_VAL(lseg) = ptrsegsize;
      rseg = lseg + ptrsegsize;
      GET_VAL(rseg - 4) = ptrsegsize;
    }
    else {
      /* don't merge right */

      ptrsegsize = ptrsegsize + GET_SIZE(lseg);

      GET_VAL(lseg) = ptrsegsize;
      GET_VAL(lseg + ptrsegsize - 4) = ptrsegsize;
    }
  }      

#ifdef DEBUG_FREE
  printf("  creating new free seg (%x - %x) with %x bytes\n", 
	 lseg, 
	 rseg - 1, 
	 rseg - lseg);

  printf("mm_free end\n\n");

#ifdef PROMPT
  printf("waiting for user...");
  getchar();

  c = 5;
#endif
#endif
}
