/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "wdk",
    /* First member full name */
    "William Dennis Kunz",
    /* First member email address */
    "kunz",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/*
  This malloc attempts to function similarly to the LIBC malloc explained in
  recitation.
  Implementation:
    Four byte header before and after a block to indicate size
    A negative number indicates a free block
    Free blocks are maintained by a linked list with a prev(ious) and a next
    The program maintains different lists:
      For sizes less than 512 bytes it is exact match
      For sizes between 512 and 16896 it places it 256 range buckets
      (* NOTE - Unable to implement this feature before deadline *)
      All other sizes are maintained on the remainder list
*/

#define allign8byte(x) (((x+7)>>3)<<3)

// Define enough space to hold the system 4 byte pointer * 64 pointers * 8 bits per byte + some padding and allignment
#define heaplistssize 2100

/* headerinfo provides an easy way to access the block information via casting */
struct headerinfo
{
   int size;
   struct headerinfo *next;
   struct headerinfo *prev;
};

/* heaplists provides an easy way to access the various lists via casting */
struct heaplists
{
  struct headerinfo *asize[64];
//  struct headerinfo *bsize[64];
  struct headerinfo *remainder;
};

/* addtolist is responsible for taking a free block and adding it to the appropriate free list */

void addtolist(struct headerinfo *x)
{
  struct heaplists *thestart=dseg_lo;
  int ls=-x->size;
  if (ls<512)
  {
    ls=((ls-16)>>3);
    if (thestart->asize[ls]) thestart->asize[ls]->prev=x;
    x->next=thestart->asize[ls];
    x->prev=NULL;
    thestart->asize[ls]=x;
  }
  /*  else if (ls<16896)
  {
    ls=((ls-512)>>8);
    if (thestart->bsize[ls]) thestart->bsize[ls]->prev=x;
    x->next=thestart->bsize[ls];
    x->prev=NULL;
    thestart->bsize[ls]=x;
  }*/
  else
  {
    if (thestart->remainder) thestart->remainder->prev=x;
    x->next=thestart->remainder;
    x->prev=NULL;
    thestart->remainder=x;
  }
}

/* removefromlist takes a freeblock and takes it out of the list */
void removefromlist(struct headerinfo *x)
{
  struct heaplists *thestart=dseg_lo;
  int ls;

  if (x->next) x->next->prev=x->prev;
  if (x->prev) x->prev->next=x->next;
  else
  {
    if (-x->size<512)
    {
      ls=((-x->size)-16)>>3;
      thestart->asize[ls]=x->next;
    }
    /*  else if (-x->size<16896)
    {
      ls=((-x->size)-512)>>8;
      thestart->bsize[ls]=x->next;
    }*/
    else
    {
      thestart->remainder=x->next;
    }
  }
}

/* findinlist finds the best place to allocate a block of findsize */
struct headerinfo *findinlist (int findsize)
{
  struct heaplists *thestart=dseg_lo;
  struct headerinfo *fbptr=NULL;

  while (!fbptr && findsize<512)
  {
    fbptr=thestart->asize[(findsize-16)>>3];
    findsize+=8; // it will continue to loop
  }
  /*while (!fbptr && findsize<16896)
  {
    fbptr=thestart->bsize[(findsize-512)>>8];
    findsize+=256;
  }*/
  if (!fbptr)  // if it didn't find an exact fit than it does first fit
  {
    fbptr=thestart->remainder;
    while (fbptr && findsize>-fbptr->size) fbptr=fbptr->next;
  }
  return fbptr;
}  

int mm_init (void)
{
    int i;

    struct heaplists *start=dseg_lo;
    mem_sbrk(heaplistssize);
    for (i=0;i<64;i++)
    {
      start->asize[i]=NULL;
      //start->bsize[i]=NULL;
    }
    start->remainder=NULL;
    return 0;
}

void *mm_malloc (size_t size)
{
    struct headerinfo *fbptr=dseg_lo;
    int cbsize;
    int spot;

    if (size<8) size=8;     // Set minumum size
    size=allign8byte(size)+8;  // Add room for header, footer

    fbptr=findinlist(size);  // Look for a fit
    if (fbptr)               // if there's a fit
    {
      removefromlist(fbptr); // remove it from the list
      cbsize=-fbptr->size;   // grab the size of the block
      fbptr->size=cbsize;    // change the header
      *(int *)((char *)fbptr+cbsize-4)=cbsize;    // and footer
      if (size+16<=cbsize)             // if there is enough room in the end
      {
	fbptr->size=size;              // reduce the size to the actual size
	*(int *)((char *)fbptr+size-4)=size;         // in the footer as well
        *(int *)((char *)fbptr+size)=cbsize-size;      // and mark the extra
        *(int *)((char *)fbptr+cbsize-4)=cbsize-size;  // as a filled block
        mm_free((void *)((char *)fbptr+size+4));       // which you free
      }
      return ((void *)((char *)fbptr+4));   // returning the spot+4
    }

    spot=(int)dseg_hi+1;  // start at the top
    if ((spot-4)<0)       // if there is a blank spot at top
    {
       if (!mem_sbrk(size+*(int *)(spot-4))) return NULL; // get enough suplemental memory
       spot+=*(int *)(spot-4);      // got to the start of the blank
       fbptr=(char *)size;          // make a pointer to it
       removefromlist(fbptr);       // so that you can remove it from the list
       *(int *)(spot)=size;            // set the size tag in the header
       *(int *)(spot+size-4)=size;     // and footer
       return (void *)(spot+4);        // return
    }
    if (!mem_sbrk(size)) return NULL; // otherwise we need to make room
    *(int *)(spot)=size;              // set the header
    *(int *)(spot+size-4)=size;       // and footer
    return (void *)(spot+4);          // and return it
}

void mm_free (void *ptr)
{
    struct headerinfo *freespot=(char *)ptr-4;
    struct headerinfo *neighbor;
    int size;

//Change headers
    size=-freespot->size;
    freespot->next=NULL;
    freespot->prev=NULL;
    freespot->size=size;
    *(int *)((char *)freespot-size-4)=size;
    neighbor=(char *)freespot-size;

// Check it's following neighbor for coalescing
    if ((char *)neighbor<dseg_hi && neighbor->size<0)
    {
      size+=neighbor->size;
      removefromlist(neighbor);
    }

// Check it's preceding neighbor for coalescing
    if ((char *)freespot>dseg_lo+heaplistssize && *(int *)((char *)freespot-4)<0)
    {
      neighbor=(char *)freespot+*(int *)((char *)freespot-4);
      size+=neighbor->size;
      removefromlist(neighbor);
      freespot=neighbor;
    }

// readjust and add to the list
    freespot->size=size;
    *(int *)((char *)freespot-size-4)=size;
    addtolist(freespot);
}

