/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Oh my god... You've killed Kenny.  YOU BASTARDS!",
    /* First member full name */
    "Hung-Lin Lu",
    /* First member email address */
    "hlu",
    /* Second member full name (leave blank if none) */
    "Sean Hammond",
    /* Second member email address (blank if none) */
    "sh5p"
};

/*  get_alloc_addr.c
 *
 *  given an int size request (size > 0), get_index will return the corresponding index
 *     in the free-size array.  If size = -1, get_index will return the size of the array
 *     in bytes.
 *
 *  array[0] -> unused at present
 *
 *  000000 - 000512  000008-byte bins  64 bins
 *  000513 - 002560  000064-byte bins  32 bins
 *  002561 - 010752  000512-byte bins  16 bins
 *  010753 - 043520  004096-byte bins  08 bins
 *  043521 - 174592  032768-byte bins  04 bins
 *  174593 - 698880  262144-byte bins  02 bins
 *
 *  explanation:
 *     the cascading if...then...else statement breaks the size down into the appropriate
 *     bin size.  the round_mask is set to mask all digits less significant than the 
 *     bin size.  pwr_of_2 is the power of 2 of the bin size (ex. pwr_of_2 for 8 = 3).
 */

/* if round_up == 1, round up, otherwise round down */

void *get_alloc_addr (int *size, int round_up)
{
  int round_mask = 0;
  int multiple   = 0;  /* flag to set if even multiple of pwr_of_2 */
  int pwr_of_2   = 0;
  int index_shift= 0;  /* # of array indicies to shift */
  int floor = 0;

  if (*size == -1)
  { return (dseg_lo + 508);
  }
  else if (*size <= 512)
  { round_mask = 0x07;
    pwr_of_2 = 3;
    index_shift = 0;
    floor = 0;
  }
  else if (*size <= 2560)
  { round_mask = 0x3f;
    pwr_of_2 = 6;
    index_shift = 64;
    floor = 512;
  }  
  else if (*size <= 10752)
  { round_mask = 0x1ff;
    pwr_of_2 = 9;
    index_shift = 96;
    floor = 2560;
  }  
  else if (*size <= 43520)
  { round_mask = 0xfff;
    pwr_of_2 = 12;
    index_shift = 112;
    floor = 43520;
  }  
  else if (*size <= 174592)
  { round_mask = 0x7fff;
    pwr_of_2 = 15;
    index_shift = 120;
    floor = 174592;
  }  
  else if (*size <= 698880)
  { round_mask = 0x3ffff;
    pwr_of_2 = 18;
    index_shift = 124;
    floor = 698880;
  }  

/*  else extremely large */
/*  will complete later  */

  
  multiple = !(*size & round_mask);  /* if even multiple, set to 1 */

  *size = ((((*size) >> pwr_of_2) + (!multiple & round_up)) << pwr_of_2);

  return (dseg_lo + ((index_shift + (((*size) - floor) >> pwr_of_2) + (!multiple & round_up)) * 4));

}


/* mm_init.c
 *
 * initializes the heap
 *
 */

int mm_init (void)
{
  int size = -1;
  unsigned *init_ptr     = NULL; 
  unsigned *insert_ptr   = NULL; 
  unsigned *overhead_end = get_alloc_addr(&size, 0);

  /* check initial heap size - make sure alloc array fits
   * since overhead guaranteed < one page, only one page will ever need to be allocated
   */

  if ((unsigned*)(dseg_hi - dseg_lo + 1) < overhead_end)
  { if (mem_sbrk(mem_pagesize()) == NULL)
      return(-1);
  }
  
  /* set all elements in array to NULL     */
  for (init_ptr = (unsigned*)dseg_lo; init_ptr < overhead_end; (unsigned)init_ptr += 4)
    *init_ptr = 0;

  /* add initial free-space block to array
   * make sure free-space block aligns properly to 8 bytes
   */

  if ((unsigned)overhead_end & 0x7)                 /* make address divisible by 8      */
    overhead_end = (unsigned*)((((unsigned)overhead_end >> 3) + 1) << 3);
  *overhead_end = ~0;                     /* set footer before free space     */

  *((unsigned*)(dseg_hi + 1 - 4)) = ~0;                /* set end-of-page footer */

  overhead_end += 1;                      /* advance pointer to next word     */
  size = ((unsigned)dseg_hi + 1 - 4 - (unsigned)overhead_end);        /* size of free space  */
  *((unsigned*)overhead_end) = size & ((~0) << 1);     /* set free-space header            */
  *((unsigned*)(dseg_hi + 1 - 8)) = size & ((~0) << 1);    /* set free-space footer            */

  insert_ptr = get_alloc_addr(&size, 0);     /* get pointer for free-space array */
  *(overhead_end + 2) = (unsigned)insert_ptr;/* set free-space back-pointer      */
  *insert_ptr = (unsigned)(overhead_end + 1);        /* set array pointer to free-space  */
  
  return(0);
}

/* mm_free.c
 *
 * another implementation of free()
 *
 * things to remember...
 *    ptr is the address of the DATA part of the allocated memory
 *    the header is at (ptr - 4)
 *    the footer is at (ptr - 4 + size)
 */

/* add_to_array
 * remove_from_array
 *
 * we have chosen to use a static array of pointers to free-space elements.  since
 *    our minimum allocation size is 8 bytes of data, we can fit a bi-directional
 *    linked-list of free-space elements.  we have chosen to implement this list in
 *    a stack-like format - FIFO relative to the array.  elements are inserted between
 *    the allocation array and any existing free-space elements.
 */

void add_to_array(unsigned *add_addr)
{
  int size = (*(add_addr - 1)) & -2;             /* element size w/o alloc bit   */
  unsigned *array_addr = get_alloc_addr(&size, 0);      /* storage array addr           */
  unsigned *next_addr = (unsigned*)(*array_addr);                 /* next element addr            */
  
  if ((unsigned*)(*array_addr) == NULL)                     /* no elements in array         */
    {
      *array_addr = (unsigned)add_addr;                         /* array points to new free-blok*/
      *(add_addr + 1) = (unsigned)array_addr;      /* back ptr points to array     */
    }
  else
    {
      *(add_addr + 1) = (unsigned)array_addr; /* back ptr points to array     */
      *(next_addr + 1) = (unsigned)add_addr;/* back ptr of next pts to new  */
      *add_addr = (unsigned)next_addr;                     /* add "->next" pts to next     */
      *array_addr = (unsigned)add_addr;                    /* array pts to new element     */
      
    }
}

void remove_from_array(unsigned *remove_addr)
{
  unsigned *back_addr = (unsigned*)(*(remove_addr + 1));
  unsigned *next_addr = (unsigned*)(*remove_addr);                /* next element addr            */

  if (*remove_addr == 0)                      /* element at end of list       */
    {
      *back_addr = 0;                         /* "next" ptr = NULL            */
    }
  else                                           /* element not at end of list   */
    {
      *back_addr = (unsigned)next_addr;    /* set "next" ptr to next elmnt */
      /* set back ptr on next element */
      *(next_addr + 1) = (unsigned)back_addr;
    }
}

void *mm_malloc (size_t size)
{
  unsigned* at_arr = 0;  
  unsigned* beg_ptr = 0;
  unsigned* addr_largest_bin = (unsigned*)(dseg_lo + 500);
  size_t    chunk_size;
  unsigned  page_num = 0;
  int found = 0;

  if (size <= 0)
    return NULL;

  size += 8;
  chunk_size = size;

  /* go through all array elements to find if there is something for size */

  at_arr = get_alloc_addr(&chunk_size, 1); /* gets array and updates chunk size */
  while(!found && at_arr <= addr_largest_bin) {
    if (*at_arr) {
      chunk_size = *((unsigned*)((*at_arr) - 4));
      beg_ptr = (unsigned*)(*at_arr);
      found = 1;
    }
    else {
      /*go to the next size and see if any slot available*/
      at_arr = at_arr + 1;
    }
  }
  if (!found) {
    if (size & 0xfff) /* if more than exact multiple of page size */
      page_num = (size >> 12) + 1;
    else /* if is exact multiple of page size (2^12) */
      page_num = size >> 12;
    chunk_size = page_num * 4096;
    beg_ptr = mem_sbrk(mem_pagesize());
    while(--page_num) /* get enough space */
      mem_sbrk(mem_pagesize());
    found = 1;
  }
  
  if (!found)
    return NULL;

  /* check if there is anything big enough to stick back to array
   * if so, assign size values to header and footer of new block
   *   and then insert it to array
   * if not, assign footer 
   */
  
  if (chunk_size - size >= 16) {
    *(beg_ptr + (size >> 2) - 1) = chunk_size - size;
    *(beg_ptr + (chunk_size >> 2) - 2) = *(beg_ptr + (size >> 2) - 1);  /* footer = header */
    
    *(beg_ptr - 1) = size + 1; /* header = size + 1; the 1 indicates the block is in use */
    *(beg_ptr + (size >> 2) - 2) = *(beg_ptr - 1);
      
    add_to_array((unsigned*)(beg_ptr + (size >> 2)));
  }
  else {
    *(beg_ptr -1) = chunk_size + 1;
    *(beg_ptr + (chunk_size >> 2) - 2) = *(beg_ptr - 1);
  }
  remove_from_array(beg_ptr);

  return beg_ptr;

}


void mm_free (void *ptr)
{
  unsigned *this = ptr;
  int size = *(this - 4);                         /* size of allocated block      */
  int coalesce_l = !( *(this - 8) & 1);          /* bit switch                   */
  int coalesce_r = !( *(this - 4 + size) & 1);   /* bit switch                   */
  unsigned *coalesce_block = NULL;                   /* addr of block to coalesce    */
  int coalesce_size = 0;

  if (coalesce_l)
    {
      coalesce_size = *(this - 8);                /* size of coalescable block    */
      coalesce_block = this - coalesce_size;      /* pointer to coalescable block */
      remove_from_array(coalesce_block);
      size += coalesce_size;                     /* expand free-block size       */
      this = coalesce_block;                      /* move pointer to free-block   */
      *(this - 4) = size;                         /* set header                   */
      *(this - 8 + size) = size;                  /* set footer                   */
    }

  if (coalesce_r)
    {
      coalesce_size = *(this - 4 + size);         /* size of coalescable block    */
      coalesce_block = this + size;               /* pointer to coalescable block */
      remove_from_array(coalesce_block);
      size += coalesce_size;                     /* expand free-block size       */
      *(this - 4) = size;                         /* set header                   */
      *(this - 8 + size) = size;                  /* set footer                   */
    }

  *(this - 4)        = (~0) << 1;                 /* set status bit on header     */
  *(this - 8 + size) = (~0) << 1;                 /* set status bit on footer     */
  add_to_array(this);

}
