/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Jesiatha",
    /* First member full name */
    "Eric Heutchy",
    /* First member email address */
    "eheutchy",
    /* Second member full name (leave blank if none) */
    "Ethan Tira-Thompson",
    /* Second member email address (blank if none) */
    "ejt"
};

#define BUCKETS ((unsigned int *)dseg_lo)
#define BUCKSIZE (32 * 4)
#define ALIGN(n) ((n + 7) & (~7))

inline int ToBucket(int n)
{
  /* A hash function which groups the blocks together
     based on the power of two that the size of the block
     fits into */
	int count = 0;
	while (n) { count++; n >>= 1; }
	if (count < 4) count = 4;
	return count;
}

int mm_init (void)
{
  /* initializes the hash tables to empty buckets...
     when blocks are freed, they will be placed in these buckets */
	unsigned int i;
	if ((int)dseg_hi - (int)dseg_lo < BUCKSIZE)
	{
		mem_sbrk(BUCKSIZE + (int)dseg_lo - (int)dseg_hi);
	}

	for (i = 0; i < 32; i++) BUCKETS[i] = 0;

    return 0;
}

void *mm_malloc (size_t size)
{
  /* Initialize some stuff */
	char *temp;
	int bucket;
	unsigned int *previous;
	unsigned int *current;
	size = ALIGN(size); /* align to 8-byte boundaries */
	bucket = ToBucket(size); /* find out which bucket to look in */
	previous = &(BUCKETS[bucket]);
	current = *previous;
	while (0 != current)
	{ // have a bucket
		if (*(current - 2) >= size)
		{ /* This block is big enough for what we're looking for */
			*previous = *current; /* Take it out of the free list */
			return current; /* Use it */
		}
	        /* Otherwise, keep looking */
		previous = current;
		current = *current;
	} // have a bucket

        /* We didn't find a block big enough, we need to ask for more space */
	{ // make a bucket
		temp = dseg_hi;
		if (NULL == mem_sbrk(size + 8)) return NULL;
		*((unsigned int *)temp) = size;
		return temp + 8;
	} // make a bucket

}

void mm_free (void *ptr)
{
  /* Initialize stuff */
	int bucket;
	bucket = ToBucket(*((int *)(ptr) - 2));
  
	/* Insert this block into the front of the appropriate bucket */
	*((unsigned int*)ptr) = BUCKETS[bucket];
	BUCKETS[bucket] = (unsigned int)ptr;
}
