/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */


/*

Our implementation uses Segregated Free Lists plus a special pointer to TOP block, which is the free block at the TOP of our avaliable heap.  We break down free lists into many classes, and each class has a distinct increment size.  For example, class1 is from size 8 bytes to 128 bytes with 8-byte increment, class2 is from 128 to 512 with 32-byte increment.
When allocating memory, we first check to see if any free blocks in our free lists are big enough, then if all fails, try TOP (expand heap if necessary).
When freeing, we do immediate coalescing.  If either or both adjacent blocks are free, we coalesce and take the coalesced adjacent free blocks off their old free lists, then put the final free block onto its appropriate free list.

 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

/* Macroes */

#define ALIGNMENT 8
#define MASKHI 0xfffffffa
#define MASKLO 0x00000001

#define C1 8
#define C2 128
#define C3 512
#define C4 4096
#define C5 32768
#define C6 262144
#define C7 2097152
#define CLARGE 16777216

#define BIN1 8
#define BIN2 32
#define BIN3 256
#define BIN4 2048
#define BIN5 C5
#define BIN6 C6
#define BIN7 C7

#define L2 16
#define L3 28
#define L4 42
#define L5 58
#define L6 66
#define L7 74
#define LLARGE 82

#define TOTALLEVELS 82
#define LARGE (dseg_lo + TOTALLEVELS*4)
#define TOP (LARGE+4)
#define BASE (dseg_lo + 516)

#define DEREF(x) (*(int *)x)

team_t team = {
    /* Team name to be displayed on webpage */
    "HTML tags SUCK!",
    /* First member full name */
    "Da Kong",
    /* First member email address */
    "dkong@adnrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Wally Chang",
    /* Second member email address (blank if none) */
    "wallyc@andrew.cmu.edu"
};

void mm_splice(void *ptr);

int mm_size(int size)
{
  return (MASKHI & size);
}

int mm_abit(int size)
{
  return (MASKLO & size);
}



/************************************************************************ 
Function: mm_print()
   Purpose:  Used debugging the code. Not called in final version of the
             code.
************************************************************************/
void mm_print()
{
  void *p, *ptr, *base;
  int i, size;

  printf("lo: %x = %d, hi: %x, = %d\n", (int)dseg_lo, (int)dseg_lo, (int)dseg_hi, (int)dseg_hi-(int)dseg_lo);
  (int *)ptr = (int *)base = (int *) dseg_lo;
  i = 0;
  while ((int)ptr < (int)(TOP)) {
    p = (int *)DEREF(ptr);
    while(p != NULL) {
      printf("LIST %d: addr: %x = dec: %d, size: %d\n", i, (int)p, (int)p-(int)dseg_lo, mm_size(DEREF(p)));
      p = (int *)DEREF((p+4));
    }
    ptr += 4;
    i++;
  }

  p = BASE;
  i = 0;
  while((int)p+4 < (int)dseg_hi) {
    if(mm_abit(DEREF(p))) {
      printf("Allocated...");
    } else {
      printf("Free...     ");
    }
    printf("block (%d), addr: %x = dec %d, size %d\n", i, (int)p, (int)p-(int)dseg_lo, (size = mm_size(DEREF(p))));
    p += size+8;
    i++;
  }
  printf("TOP of the heap :: addr: %x = dec %d, TOPsize: %d\n", (int)DEREF(TOP), (int)DEREF(TOP)-(int)dseg_lo, mm_size(DEREF(DEREF(TOP))));
  printf("--------------------------------------------------------------\n");
}

/************************************************************************ 
Function: mm_init()
Purpose:  Initialize structure used by mm_malloc. 
          Method employed in this malloc package is the segregated freelist.
	  mm_init() writes the first 400 bytes of the heap to NULL. The first
	  byte that is actually return does not start until 512 bytes
	  above dseg_lo. TOP list is also initialized. At this point,
	  there are no free blocks on the free lists so requests for
	  memory will be directly allocated from the TOP list.
************************************************************************/
int mm_init (void)
{
  int i;
  void *p;

  p = mem_sbrk(mem_pagesize());

  if (p == NULL) return -1; /*something's wrong with mem_sbrk() */

  for(i = 0; i < 400; i++) {
    (int *)DEREF((p + i*4)) = NULL;
  }

  /* setting TOP to point to BASE, very first free block */
  (int *) DEREF(TOP) = (int *) BASE;

  /* setting size blocks in the TOP free block */
  /* total size is initial pagesize - 512 mem structure, 8 bytes for size blocks and another 8 foralignment requirement */
  DEREF(DEREF(TOP)) = DEREF((dseg_lo+mem_pagesize()-8)) = mem_pagesize()-512-16;

//  mm_print();
//   printf("init done\n");

  return 0;
}

/************************************************************************ 
Function: mm_addfree()
Purpose:  a unallocated block or a "free block" -- pointed to by the void
          pointer fblock -- is passed as the parameter. The function takes
	  this free block and places it on the appropriate free list.
	  All insertions of free blocks are done as prepends. They are
	  added as the head of the list and the old head becomes the
	  2nd element on the list.
************************************************************************/
void mm_addfree(void *fblock)
{
  int size;
  void *f;

  size = mm_size(DEREF(fblock));
  if((int) fblock+size+8+4 >= (int) dseg_hi) { /* case of fblock is TOP*/
    (void *) DEREF(TOP) = fblock;  /*added 2 (int) */
  } else {  
    if (size < C2) { /* we're in class1 */
      (int *)f = (int *)(((size / BIN1) + !(size % BIN1)) * 4  + (int)dseg_lo);
    } else if (size < C3) { /* class2 */
      (int *)f = (int *)((((size-C2) / BIN2) + !(size % BIN2) + L2) * 4 + (int)dseg_lo);
    } else if (size < C4) {  /* class3 */
      (int *)f = (int *)((((size-C3) / BIN3) + !(size % BIN3) + L3) * 4 + (int)dseg_lo);
    } else if (size < C5) { /* class4 */
      (int *)f = (int *)((((size-C4) / BIN4) + !(size % BIN4) + L4) * 4 + (int)dseg_lo);
    } else if (size < C6) { /* class5 */
      (int *)f = (int *)((((size-C5) / BIN5) + !(size % BIN5) + L5) * 4 + (int)dseg_lo);
    } else if (size < C7) { /* class6 */
      (int *)f = (int *)((((size-C6) / BIN6) + !(size % BIN6) + L6) * 4 + (int)dseg_lo);
    } else if (size < CLARGE) { /* class7 */
      (int *)f = (int *)((((size-C7) / BIN7) + !(size % BIN7) + L7) * 4 + (int)dseg_lo);
    } else {
      f = LARGE;
    }

    if ((int *)(DEREF(f)) != NULL) {  /* there are elements on the free list */
      (int *) DEREF((DEREF(f)+8)) = (int *)fblock; /* set old head's prev to new head */
      DEREF((fblock+4)) = DEREF(f); /* set new head's next to old head */
      (int *)DEREF(f) = fblock; /* set free list to point to new head */
    } else {  /* There are no elements on the list, just insert the block */
      (int *)DEREF((fblock+4)) = NULL; /* only element on the list */
      (int *)DEREF(f) = fblock;  /* free list point to new head */
    }
    (int *)DEREF((fblock+8)) = NULL; /* new head's prev is NULL */
  }
}

/************************************************************************ 
Function: mm_allocate()
Purpose:  Helper function called by the main function mm_malloc().
          mm_malloc() has already found a suitable block and has passed
	  the pointer to that block this function. It also gives the 
	  function the desired target size. If the desired size is
	  equal to the size of the free block then there is no need
	  for splitting. If that is not the case, then we take the 
	  free block and split it into 2 pieces, one block of the
	  desired size and the other the remaining size provided that
	  remaining size is at least 8 bytes long. It then places the
	  remaining block on the free list by calling mm_addfree().
************************************************************************/
void mm_allocate (void *ptr, size_t size)
{
  int Free_Size, Allocated_Size, Remainder_Size;
  void *r; /* pointer to the remaining block after the split */

  Free_Size = mm_size(DEREF(ptr)); /* size of the free block */

//  if (Free_Size < size) 
//    printf("Block size smaller than target size!\n");


  if(ptr != (void *)DEREF(TOP)) { /* if the free block isn't the TOP block, 
				     then we remove the free block from
				     the appropriate free list by calling
				     mm_splice().
				     */
    mm_splice(ptr);
  }

  if ((Free_Size-size) >= 16) { /* make sure remainder is big enough */
    Allocated_Size = 
      (size % 8 == 0) ? size : ((size / 8) * 8 + 8); /* all blocks must be 8
							byte aligned. If it
							isn't, round up to
							the nearest 8 bytes */

    Remainder_Size = Free_Size - Allocated_Size - 8; /* size of the remaining
							block */

    r = ptr + Allocated_Size + 8;  /* pointer to that remaining block */

    DEREF(r) = DEREF((r + Remainder_Size + 4)) 
      = Remainder_Size;            /* set the size of the remaining block */

    (int *)(DEREF((r+8))) = NULL; /* prev = NULL */
    mm_addfree(r); /* case of r = TOP taken care of in addfree */
  } else {
    Allocated_Size = Free_Size;   /* no splitting necessary */ 
    if(ptr == (void *)DEREF(TOP)) {    /* if the freeblock was TOP set the */
      DEREF(TOP) += Allocated_Size+8;  /* size of the TOP correctly */
    }
  }

  DEREF(ptr) = DEREF((ptr + Allocated_Size + 4)) = Allocated_Size | 1;
            /* set size of the allocated block with the last bit as the 
               allocation bit denoting if the block is allocated or not*/

}

/************************************************************************ 
Function: mm_malloc()
Purpose:  Accepts a request for a memory block. We are assuming mm_init()
          was already called to initialize all the structures necessary.
	  An attempt is first made to match the request to a free block
	  already on the free list. If there are no free blocks that
	  is equal to or larger than the requested size, then the requested
	  block is allocated from the TOP block. The TOP block extends
	  from its current location to the top of the heap. If the TOP
	  block cannot accomdate the the request, then a request to
	  mem_sbrk() is called extending the heap so that at least the
	  request will be covered. 
************************************************************************/
void *mm_malloc (size_t size)
{  

  int UpperBound, AllocateTop, s = 0;
  int found = 0;
  int topsize, PagesReq, mempagesize = mem_pagesize();
  void *base, *p, *allocated;

  base = dseg_lo;

  /* A search is done to find an appropriate free block that is greater than
     or equal to the size of the requested block. A simple comparison between
     the requested size (held in variable size) and each "class" of lists.
     Once the appropriate class is found, it will search through all lists
     in that class and all classes larger than the current class until
     a suitable block is found. If no appropriate blocks were found,
     it will allocate a block from the TOP block. */

  if (size < C2) { /* we're in class1 */
    p = base;
    UpperBound = L2 * 4 + (int) base;
    while (!found && ((int)p < UpperBound)) {
      if(((void *)DEREF(p) != NULL) && (mm_size(DEREF(DEREF(p))) >= size)) {
	found = 1;
	p -= 4;
      }
      p += 4;
    }
  }

  if (!found && (size < C3)) { /* class2 */
    p = base + L2*4;
    UpperBound = L3 * 4 + (int) base;
    while (!found && ((int)p < UpperBound)) {
      if(((void *)DEREF(p) != NULL) && (mm_size(DEREF(DEREF(p))) >= size)) {
	found = 1;
	p -= 4;
      }
      p += 4;
    }
    if (DEREF(p)) found = 1;
  }

  if (!found && (size < C4)) {  /* class 3 */
    p = base + L3*4;
    UpperBound = L4 * 4 + (int) base;
    while (!found && ((int)p < UpperBound)) {
      if(((void *)DEREF(p) != NULL) && (mm_size(DEREF(DEREF(p))) >= size)) {
	found = 1;
	p -= 4;
      }

      p += 4;
    }
    if (DEREF(p)) found = 1;
  } 

  if (!found && (size < C5)) { /* class 4 */
    p = base + L4*4;
    UpperBound = L5 * 4 + (int) base;
    while (!found && ((int)p < UpperBound)) {
      if(((void *)DEREF(p) != NULL) && (mm_size(DEREF(DEREF(p))) >= size)) {
	found = 1;
	p -= 4;
      }
      p += 4;
    }
    if (DEREF(p)) found = 1;
  } 

  if (!found && (size < C6)) { /* class 5 */
    p = base + L5*4;
    UpperBound = L6 * 4 + (int) base;
    while (!found && ((int)p < UpperBound)) {
      if(((void *)DEREF(p) != NULL) && (mm_size(DEREF(DEREF(p))) >= size)) {
	found = 1;
	p -= 4;
      }
      p += 4;
    }
    if (DEREF(p)) found = 1;
  } 

  if (!found && (size < C7)) { /* class 6 */
    p = base + L6*4;
    UpperBound = L7 * 4 + (int) base;
    while (!found && ((int)p < UpperBound)) {
      if(((void *)DEREF(p) != NULL) && (mm_size(DEREF(DEREF(p))) >= size)) {
	found = 1;
	p -= 4;
      }
      p += 4;
    }
    if (DEREF(p)) found = 1;
  } 

  if (!found && (size < CLARGE)) { /* class 7 */
    p = base + L7*4;
    UpperBound = LLARGE * 4 + (int) base;
    while (!found && ((int)p < UpperBound)) {
      if(((void *)DEREF(p) != NULL) && (mm_size(DEREF(DEREF(p))) >= size)) {
	found = 1;
	p -= 4;
      }
      p += 4;
    }
    if (DEREF(p)) found = 1;
  } 
  
  if(!found) {   /* Allocation from the TOP block */
    if (((int)(DEREF(TOP) + 4)) < (int)dseg_hi) { /*Do not read pass the upper
						    limit of the heap */
      topsize = mm_size(DEREF(DEREF(TOP)));       /* size of TOP block */
    } else {
      topsize = 0;                                /* top block is 0, extend*/
      s = -8;                                     /* the heap for more memory*/
    }
    if(size <= topsize) {  /* TOP block big enough to accomdate request*/
      p = TOP;             /* Allocating from TOP block is allowed */
      AllocateTop = 1;     /* Allocation from TOP block instead of free block*/
    } else {
      AllocateTop = 1;     /* Allocation from TOP block instead of free block*/
      if (((size-topsize)) % mempagesize == 0) {/* Exactly X pages is needed */
	PagesReq = ((size-topsize)) / mempagesize;
      } else {
	PagesReq = ((size-topsize)) / mempagesize + 1; /* More than X pages
							  are needed but calls
							  to mem_sbrk must be
							  multiple of 
							  mem_pages() */
      }

      if (mem_sbrk(PagesReq * mempagesize)) { /* call to extend heap */
	p = TOP;                /* Allow allocation from TOP block*/
	topsize = topsize + PagesReq*mempagesize + s; /*set new size of TOP */
	s = 0;                  
	DEREF(DEREF(TOP)) = DEREF((DEREF(TOP) + topsize + 4)) = topsize;
      } else {                  /* failure in extending heap */
	return NULL;
      }
    }
  }

  allocated = (void *)(DEREF(p)+4);  /* Pointer to block to return */
  mm_allocate((void *)DEREF(p), size);  /* call for splitting, etc */
  /* debugging code */
  /*
  printf("Allocating...at addr: %x = dec: %d, size: %d\n", (int)allocated, (int)allocated - (int)dseg_lo, size);
  mm_print();*/

  return (allocated);   /* don't let user overwrite the size bytes */
}

/************************************************************************ 
Function: mm_splice()
Purpose:  Removes a block from the free list and reattach all the pointers
	  of the remaining blocks (if any) to the correct positions. 
************************************************************************/
void mm_splice(void *ptr)
{
  int size;
  void *f, *p, *prev, *next;

  size = mm_size(DEREF(ptr));

  /* check to see if we are given a TOP block to splice. If TOP is given, 
     we do not splice it */
  if(ptr != (void *)DEREF(TOP)) {
    /* find the which freelist is this block on, set f to that list  */
    if (size < C2) { /* we're in class1 */
      (int *)f = (int *)(((size / BIN1) + !(size % BIN1)) * 4  + (int)dseg_lo);
    } else if (size < C3) { /* class2 */
      (int *)f = (int *)((((size-C2) / BIN2) + !(size % BIN2) + L2) * 4 + (int)dseg_lo);
    } else if (size < C4) {  /* class3 */
      (int *)f = (int *)((((size-C3) / BIN3) + !(size % BIN3) + L3) * 4 + (int)dseg_lo);
    } else if (size < C5) {  /* class4 */
      (int *)f = (int *)((((size-C4) / BIN4) + !(size % BIN4) + L4) * 4 + (int)dseg_lo);
    } else if (size < C6) {  /* class5 */
      (int *)f = (int *)((((size-C5) / BIN5) + !(size % BIN5) + L5) * 4 + (int)dseg_lo);
    } else if (size < C7) {  /* class6 */
      (int *)f = (int *)((((size-C6) / BIN6) + !(size % BIN6) + L6) * 4 + (int)dseg_lo);
    } else if (size < CLARGE) {  /* class7 */
      (int *)f = (int *)((((size-C7) / BIN7) + !(size % BIN7) + L7) * 4 + (int)dseg_lo);
    } else {
      f = LARGE;
    }

    /* setting p to the head of the list (first block) */
    p = (void *)DEREF(f);
    /* find the block we are given in the list */
    while(p != ptr) {
      p = (void *)DEREF((p+4));
    }

    /* find the next and prev blocks (could be NULL) of the block */
    (int *) next = (int *)DEREF((p+4));
    (int *) prev = (int *)DEREF((p+8));
    /* reattach pointers according to difference cases */
    if(next != NULL) {
      if(prev != NULL) {
        (int *)DEREF((next+8)) = (int *)prev;
        (int *)DEREF((prev+4)) = (int *)next;
      } else {
	(int *)DEREF(f) = (int *)next;
        (int *)DEREF((next+8)) = NULL; 
      }
    } else {
      if(prev != NULL) {
        (int *)DEREF((prev+4)) = NULL; 
      } else {
	(int *)DEREF(f) = NULL;
      }    
    }
  }
}

/************************************************************************ 
Function: mm_free()
Purpose:  Frees a block of pointer previously assigned.
          Coalesces with adjacent blocks if possible.
	  Calls mm_splice() on coalesced adjacent blocks.
************************************************************************/
void mm_free (void *ptr)
{

  int newsize, size, tempsize;

  /* minus 4 since we user pointer is 4 points past our size block */
  ptr -= 4;
  
  size = mm_size(DEREF(ptr)); /* extract size */
  DEREF(ptr) = DEREF((ptr+size+4)) = size;  /* set the size (fix allocation bit) */

  if(((int)ptr)+size+8+4 < (int) dseg_hi) { /* if not TOP block */
    if(!mm_abit(DEREF((ptr+size+8)))) {  /* if right adj. block is also free */
      tempsize = DEREF((ptr+size+8));  
      mm_splice((void *)(ptr+size+8)); /* splice right out of its old list */
      newsize = size + tempsize + 8;
      DEREF(ptr) = newsize;
      DEREF((ptr+newsize+4)) = newsize;
    }
  }
  if(ptr != BASE) { /* if not first block */
    if(!mm_abit(DEREF((ptr-4)))) { /* if left adj. block is also free */
      size = mm_size(DEREF(ptr));  
      tempsize = DEREF((ptr-4));
      mm_splice((void *)(ptr-tempsize-8)); /* splice lift out of its old list */
      newsize = size + tempsize + 8;
      DEREF((ptr-tempsize-8)) = newsize;
      DEREF((ptr+size+4)) = newsize;
      ptr = ptr - tempsize - 8;
    }
  }
 /* calls mm_addfree() to add the new free block to its appropriate list */
  mm_addfree(ptr); 

  /* debugging code */
  /*  printf("FREEING...at addr: %x = dec: %d\n", (int)ptr, (int)ptr - (int)dseg_lo);
  mm_print();*/
}

