/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "<font color = red>D is for DIPLOMA</font>",
    /* First member full name */
    "Dmitry Frumkin",
    /* First member email address */
    "ddf",
    /* Second member full name (leave blank if none) */
    "Daniel Shaykevich",
    /* Second member email address (blank if none) */
    "dan2"
};

/*
  HEADERS:
    Free block: NEXT, SIZE, PREVIOUS, __
    Used block: next, SIZE   

    (next & 1 will tell us if the buddy is in use) 

  FOOTER:
    STARTING ADDRESS

  The minimal block size: 4 words == 16 bytes = 2^4 bytes
*/

#define WORDSIZE (sizeof (size_t))
#define LOGMIN 4
#define DSEG_LO ((size_t *) dseg_lo)
#define INTPTR(x) (*(DSEG_LO + (x)))
#define OFFSET(x) ((size_t)(x) - (size_t)dseg_lo)
#define LOGM 7
#define M ((1<<LOGM)/WORDSIZE)
#define MEM_USAGE (mem_usage()+1)
#define HEADER 2
#define FOOTER 1
#define USERDATA ((size_t *)(dseg_lo + (1<<LOGM)))
#define LASTWORD(addr)  ((size_t *)* ((addr) + (*((addr) + 1))/WORDSIZE - 1))

/* Uncomment if the program crashes */
//#define MYDEBUG

void print_array ()
{
  size_t  i = 0;
  size_t *ptr = NULL;

  printf ("Printing the array:\n\n");

  for (i = LOGMIN; i < M; i++)
  {
    printf ("%d:  \n", i);
    ptr = (size_t *)INTPTR (i);
    while (ptr != NULL)
      {
	printf ("     0x%x: (0x%x, %d, 0x%x)  \n", 
		(size_t)ptr, *ptr, *(ptr+1), *(ptr+2));
	  if (*(ptr+1) != (1<<i) || ((ptr >= USERDATA) && (LASTWORD (ptr)!= ptr)))
	  {
	    exit(-1);
	  }
	ptr = (size_t *)*ptr;
      }
  }
  
  printf ("\n");
}
     
void setfooter (size_t *addr)
{
  if (addr >= USERDATA)  
    LASTWORD (addr) = addr;
}

inline size_t log (size_t number)
{
  int result = -1;

  while (number)
  {
    result++;
    number /= 2;
  }

  return result;
}

/* 2^size is the actual size */
void insert (size_t *addr, size_t size)
{
  size_t *next = (size_t *)INTPTR (size);

#ifdef MYDEBUG
  printf ("In insert, addr = 0x%x, size = %d\n", (size_t) addr, size);
#endif

  /* Update the header */
  *addr = (size_t) next;        /* word 0 = next */
  *(addr + 1) = 1<<size;        /* word 1 = size */
  *(addr + 2) = 0;              /* word 2 = prev = 0*/
                                /* word 3 unused */
  
  /* Update the footer */
  setfooter (addr);

  /* Add to the linked list */
  if (next != NULL)
    *(next + 2) = (size_t) addr; /* next->back = this block */
  INTPTR (size) = (size_t) addr; /* add this block to the linked list */ 

#ifdef MYDEBUG
  print_array ();
  printf ("Exiting insert \n");
#endif
}

/* 2^size is the actual size */
void remove_node (size_t *addr)
{
  size_t size = log (*(addr + 1));

#ifdef MYDEBUG
  printf ("Entering remove_node, addr = 0x%x, size = %d\n", (size_t) addr, size);
#endif

  /* Remove from the list */
  if   (*(addr+2)) /* if it is not the first one on the list */
    *((size_t*)*(addr+2)) = *addr; /* previous->next=next */
  else
    INTPTR (size) = *addr; /* remove from the list */

  if (*addr)     /* if it is not the last one on the list */
    *((size_t*)*(addr)+2) = *(addr+2); /* next->previous=previous */

  /* Update the header */
  *addr = (*addr) | 1;

#ifdef MYDEBUG
  print_array ();
  printf ("Exiting remove_node \n");
#endif
}

/* 2^requested_size -- how much to allocate in bytes */
void split (size_t big_size, size_t requested_size)
{
  size_t *start = (size_t *) INTPTR (big_size); 

  size_t  buddy_size = 0;
  size_t *buddy_address = NULL; 

#ifdef MYDEBUG
  printf("Entering Split\n");
  printf("big_size = %d  requested_size = %d\n", big_size, requested_size);
#endif

  remove_node (start);             /* remove from the linked list */
  *(start + 1) = (1 << requested_size); /* set the correct size */
  setfooter (start);

  /* Put the buddies into the free lists */

#ifdef MYDEBUG
  printf ("splitting into  buddies...\n");
#endif

  buddy_size = big_size - 1;              /* the log of the buddy size */
  while (buddy_size >= requested_size)
  {
    buddy_address = start + (1 << buddy_size)/WORDSIZE;
    insert (buddy_address, buddy_size);        /* add the buddy to the list */

    buddy_size--;
  } 

#ifdef MYDEBUG
  print_array ();
  printf ("Exiting split\n");
#endif
}


/* Initializes memory */
int mm_init (void)
{
  int result = -1;
  int i = 0;
  int init_size = mem_pagesize();
  int log_init_size = log (init_size);

  if (mem_sbrk (init_size) != NULL)
  {
    for (i = 0; i < M; i++)
      INTPTR (i) = 0;

    insert (DSEG_LO, log_init_size); /* this is OK since we do not
                                        use sizes < 16 == 2^4 
                                        and the last word is beyond
                                        the array */

    split (log_init_size, LOGM);
    result = 0;
  }

#ifdef MYDEBUG
  printf("Exiting Init, returning %d\n", result);
#endif
  return result;      
}

inline size_t adjust_size (size_t size)
{
  size_t result = 0;

  if (size > 0)
  {
    size += (HEADER + FOOTER)*WORDSIZE;
    for (result = (1<<LOGMIN); result < size; result <<= 1);  
  }

  return result;
}

void *mm_malloc (size_t size)
{
  size_t *result = NULL;
  size_t log_size = 0;
  int i = 0;

  size = adjust_size (size); /* adjusted size in bytes */
  if (!size)
    return NULL;

  log_size = log (size);     /* the log of the size    */
 
  for (i = log_size; i < M; i++) /* search for the first free block */
    if (INTPTR (i) != 0)
      {
	result = (size_t *)INTPTR (i) + HEADER;
	split (i, log_size);
	break;
      }

  if (result == NULL) /* not found => allocate, crash if not available */
  {
    result = mem_sbrk (size);
    *result = 1;
    *(result + 1) = size;
    setfooter (result);
    result = result + HEADER;
  } 
    
  return (void *)result; 
}

inline size_t *left_buddy (size_t *block, size_t log_size)
{
  size_t *result = (size_t *)*(block - 1);
  if  ((result < USERDATA) || ((*result) & 1) || 
       (*(result + 1) != (1 << log_size)))
    result = NULL;
  return result;
}

inline size_t *right_buddy (size_t *block, size_t log_size)
{
  size_t *result = block + (1<<log_size)/WORDSIZE;
  if ((result >= (size_t*)dseg_hi) || ((*result) & 1) || 
         (*(result + 1) != (1 << log_size)))
    result = NULL;
  return result;
}

/* return values 1 => coalesce to the left , 2 => right, 0 => no way */
int analyze (size_t *block, size_t log_size)
{
  size_t *left = left_buddy (block, log_size);  
  size_t *right = right_buddy (block, log_size);
  size_t result = 0;

  int count = 0;
#ifdef MYDEBUG
  printf ("Entering analyze\n");
#endif

  while ((left != NULL) && (right != NULL))
  {
    if (count > 10)
    {
      printf ("Infinite loop 1\n");
      exit (-1);
    }
    count++;
    log_size++;
    left = left_buddy (left, log_size);
    right = right_buddy (block, log_size);
  } 
  
  if (right != NULL) result = 2;
  if (left != NULL) result = 1;
#ifdef MYDEBUG
  printf ("Exiting analyze, returning %d\n", result);
#endif
  return result;
}

void mm_free (void *ptr)
{
  size_t* block = ((size_t *) ptr) - HEADER;/* start of block */
  size_t log_size = log(*(block + 1)); /* log of block size */
  size_t *next = NULL;
  int change = analyze (block, log_size);


#ifdef MYDEBUG
  printf ("Entering free, block = 0x%x, log_size = %d, next = 0x%x\n", 
          (size_t)block, log_size, (size_t) next);
#endif

  while (change)
  {
    if (change == 1)
    {
      next = left_buddy (block, log_size);
#ifdef MYDEBUG
       printf ("Coalescing to the left, block = 0x%x, next = 0x%x\n", (size_t) block,
	    (size_t) next);
#endif
      remove_node (next);
      log_size++;
      block = next;
    }
    else
    {
      next = right_buddy (block, log_size);
#ifdef MYDEBUG
        printf ("Coalescing to the right, block = 0x%x, next = 0x%x\n", (size_t) block,
            (size_t) next);
#endif
        remove_node (next);
        log_size++;
    }
    change = analyze (block, log_size);
  }
  insert (block, log_size);
 
#ifdef MYDEBUG
  printf ("Exiting free\n");
#endif

}
