#!/usr/local/bin/perl5 -w
#!/usr/bin/perl

# Kip Walker <kwalker@cs.cmu.edu> / Spring 1998
# Spiros Papadimitirou <spapadim@cs.cmu.edu> / Spring 1999
# Khalil Amiri <amiri+@cs.cmu.edu> / Fall 1999
# CS213 - Lab assignment 3

use FileHandle;

# NOTES:
# programs should flush() output often if they want to produce useful
# output if they've been killed for running too long.

# here are some things that might have to be modified
$rootdir="/afs/cs/academic/class/15213-f99/private/L3/final/grade";

$submitdir = "$rootdir/submit";
$builddir = "$rootdir/build";

$maxtime = 450;
$progname = "$builddir/malloc";

$host = `hostname`; chop $host;
$logdir = "$rootdir/log";
$logfile = "$logdir/ourlog.$host";
$weblog = "$logdir/weblog.$host";

$webpage = "$rootdir/html/mallocgrades.html";

sub build_meth {
    my $ofile = shift;
    return "$rootdir/script/dobuild $submitdir $builddir $ofile";
}

format compileerror =
We tried compiling your malloc and found that 
it generated some errors.  Sorry!

Here's the output:
@*
$output
--end of output--

Have a good day!
.

format timeerror =
We've run our malloc tester for:
@##.### seconds
$time
and it wasn't finished, so we killed it.  Sorry!

The output of the program (up to then) follows:
@*
$output
--end of output--

Have a good day!
.

format timegood =
We ran your malloc, and the program exited with 
ode (0 is normal):
@*
$retval

The output of the program test run follows:
@*
$output
--end of output--

Have a good day!
.

# probably don't have to modify stuff below here
# but of course your mileage may vary

sub do_build {
    my $file = shift;
    my $buildcmd = build_meth($file);
    my $pid;

    print "Compiling $file...";
    if (!($pid = fork)) {
        # i'm the child and should do the compile
        
        open(STDOUT, ">$builddir/$file.compile")
            || die "can't redirect stdout";
        open(STDERR, ">&STDOUT")
            || die "can't redirect stdout";

        exec $buildcmd;
    }
    waitpid $pid, 0;
    print "done\n";
    if ($? != 0) {
        print "error in compilation\n";

        $output = `cat $builddir/$file.compile`;
        open RESULTS, ">$name.output";
        RESULTS->format_name("compileerror");
        write RESULTS;
        close RESULTS;

        unlink "$builddir/$file"; 
        unlink "$builddir/$file.compile";

        return 1;
    }

    unlink "$builddir/$file.compile";
    return 0;
}

sub get_name {
    my $filename = shift;
    $filename =~ /malloc-(.*)\.c/;
    my $username = $1;
    return $username;
}

sub update_results {
    my $ofile = shift;
    my $correct = "no";
    my $avg_time = 1000.0;
    my $avg_throughput = 0.0;
    my $avg_util = 0.0;
    my $perf_index = 0.0;
    my $teamname = "NO_TEAMNAME";
    my $email1 = $name;
    my $email2 = "";

    my $corr_grade = 0;
    my $perf_grade = 0;

    open(STATUS, $ofile);
    while (<STATUS>) {
        if (/Teamname: (.*)/) {
            $teamname = $1;     # random word
        }
        if (/Email 1: (.*)/) {
            $email1 = $1;        # email address
#            $name = $email1;
        }
        if (/Email 2: (.*)/) {
            $email2 = $1;        # email address
#           $name = $name." ".$email2;
        }
        if (/All correctness tests passed/) {
            $correct = "yes";      # "yes" or "no"
        }
	if (/All correctness tests passed/) {
            $correct = "yes";      # "yes" or "no"
        }
        if (/Average overall utilization: (.*)%/) {
            $avg_util = $1;
        }
        if (/Average throughput: (.*) tops/) {
            $avg_throughput = $1;
        }
        if (/>Performance index: (.*)/) {
            $perf_index = $1;
        }
    }
    close STATUS;

    my $time = time;
    
    if ($teamname ne "NO_CODENAME") {
        # Calculate grades
        if ($correct eq "yes") {
            $corr_grade = 20;
        }

        if ($perf_index >= 85.0 ) {
            $perf_grade = 35;
        } elsif ($perf_index >= 60) {
            $perf_grade = 30;
        } elsif ($perf_index >= 20) {
            $perf_grade = 25;
        } elsif ($corr_grade == 20) {
            $perf_grade = 15;
        } else {
            $perf_grade = 0;
	}

        open(LOG, ">>$logfile");
        print LOG "$time $teamname $email1 $email2 $correct $avg_time $avg_throughput $avg_util $perf_index $corr_grade $perf_grade\n";
        close(LOG);

        open RESULTS, ">$name.output";
        print RESULTS "Lab 3 - Results\n";
        print RESULTS "---------------------------------------\n\n";
        print RESULTS "Email1: $email1\n";
        print RESULTS "Email2: $email2\n";
        print RESULTS "---------------------------------------\n";
        print RESULTS "Correctness: $corr_grade\n";
        print RESULTS "Performance: $perf_grade\n";
        print RESULTS "Style: \n";
        print RESULTS "Late: -0\n";
        print RESULTS "Total: \n";
        print RESULTS "---------------------------------------\n\n";
        print RESULTS "Comments:\n\n";
        print RESULTS "---------------------------------------\n\n\n";
        close RESULTS;

        open(WEB, ">>$weblog");
        printf WEB "%020d <tr> <td bgcolor=#eeeeee> $correct </td> ", $time;
        print  WEB "<td bgcolor=#eeeeee> $avg_throughput </td> ";
        print  WEB "<td bgcolor=#eeeeee> $avg_util </td> ";
        print  WEB "<td bgcolor=#eeeeee> $perf_index </td> ";
        print  WEB "<td bgcolor=#eeeeee> $corr_grade </td> ";
        print  WEB "<td bgcolor=#eeeeee> $perf_grade </td> ";
        print  WEB "<td bgcolor=#eeeeee> $teamname </td> </tr>\n";
        close(WEB);
        system("cat $rootdir/script/www-header > $webpage.$host.NEW");
        system("sort -k 29 -k 1nr $logdir/weblog.* | uniq -19 | cut -b 22- | sort -k 16nr -k 28 >> $webpage.$host.NEW");
#       system("cat $weblog >> $webpage.$host.NEW");
        system("cat $rootdir/script/www-footer >> $webpage.$host.NEW");
        system("mv $webpage.$host.NEW $webpage");
    } else {
        print "Not updating results.\n";
    }
}

# start of main program

$| = 1;

opendir SUBMIT, $submitdir;

print "Starting...\n";
print "Dir: $submitdir\n";

rewinddir SUBMIT;

while (defined($file = readdir SUBMIT)) {
    # for each file in the directory
    if (($file eq ".") || ($file eq "..") || ($file eq "archived")) {
       next;
    }
    if ($file =~ /.*\.output/) {
       next;
    }

    print "Found $file...\n";

    $name = get_name($file);
    print "found name = $name\n";

    # build $file in $builddir
    if (do_build($file)) {
        print "****** CHECK BY HAND: $file (compile error) ******\n";
        next;
    }

    print "Running $file...";
    alarm $maxtime;
    $killed = 0;
    @start = times;
    if (!($pid = fork)) {
        # i'm the child; i should execute the process

        open(STDOUT, ">$builddir/$file.output") 
            || die "can't redirect stdout";
        open(STDERR, ">&STDOUT") 
            || die "can't redirect stderr to stdout";
        exec "$progname";
    }
    $SIG{ALRM} = sub { kill 9, $pid; $killed = 1; };
    waitpid $pid, 0;
    $retval = $?;
    alarm 0;
    @end = times;
    print "done\n";

    $time = $end[3] - $start[3] + $end[2] - $start[2];
    if ($killed) { 
        print "KILLED "; 
        $time = $maxtime;
        wait;
    }
    print "$file took $time seconds\n";

    $output = `cat $builddir/$file.output`;
    update_results("$builddir/$file.output");
    open RESULTS, ">>$name.output";
    if ($killed) {
        RESULTS->format_name("timeerror");
    } else {
        RESULTS->format_name("timegood");
    }
    write(RESULTS);
    close RESULTS;


    unlink "$builddir/$file.output";
    unlink "$builddir/$file";
}

closedir SUBMIT;
