/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Grumpy",
    /* First member full name */
    "Sean Martin",
    /* First member email address */
    "martin3",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/* This implementation uses a single doubly linked list of free blocks each with a header 
   and a footer.  Both the header and footer contain the size information shifted to the
   left one bit to accomidate an additional 'in use' bit to indicate whether or not the
   block is in use.  Additionally the header contains pointers to the next and previous
   free blocks, but these pointers are only usable when the block is free. To find the
   linked list, and insure 8 byte alignment, an initial header is used located at 
   dseg_lo.

   common variables used:  
   cur_pos              : current position in memory
   temp_pos/temp2_pos   : moved around the current position to find the footer or next/previous
                          block information
   spacer1/spacer2      : typcially 4, one is the size of a size_t pointer, the other the size of 
                          a variable of type size_t.
   spacer3              : the size of a malloc_chunk pointer (cptr)
*/

/* define a structure for the header to contain needed info */
struct malloc_chunk
{
  size_t aligned_size;      /* Size in bytes, including overhead. */

  /* NOTE: material after this is stored in free space */

  struct malloc_chunk* fd;   /* double links -- used only if free. */
  struct malloc_chunk* bk;
};

/* define a structure for the footer to contain needed info */
struct footer
{
  size_t aligned_size;
};

/* simplify names for the header, and footer structs */
typedef struct malloc_chunk* cptr;
typedef struct footer* sptr;

/* Initialize the header struct at dseg_lo, initially put a page on the heap, and set up
   all pointers here.  If this has been called before, then just reinitialize everything
   and return.
*/

int mm_init (void)
{
  void *test_init;
  void *temp_pos;
  void *cur_pos;
  unsigned int total_size;
  int spacer1 = sizeof(size_t);
  int spacer2 = sizeof(size_t *);
  int spacer3 = 2 * sizeof(cptr) + spacer1;  /* size of a malloc_chunk object NOTE: code assumes size_t to be 4 bytes*/
   
  /* if this is the first time the heap is being set up, then check
     that memory is available, big problem if not. */

  if ((mem_usage() + 1) == 0) {
    /* get a pagesize and check that we have memory to use */
    if ((test_init = mem_sbrk(mem_pagesize())) == NULL)
      return -1;

    /* if this is the first time through then the total size is just a pagesize */
    total_size = mem_pagesize();

  }
  /* otherwise we're resetting so get the stored total size that's been allocated */
  else total_size = ((((cptr)dseg_lo)->aligned_size) >> 1);


    /* move the cur_pos pointer into position */
    (cptr)cur_pos = (cptr)dseg_lo;    

    /* move the temp pointer into position */
    temp_pos = (char *)cur_pos + spacer3;

    /* the first several bytes will be a pointer to the first free space.*/
    ((cptr)cur_pos)->fd = ((cptr)temp_pos);   
    ((cptr)cur_pos)->bk = ((cptr)temp_pos);

    /* put the size into the list header */
    ((cptr)cur_pos)->aligned_size = ((total_size << 1) | 1);
 
    /* move the current position  up */
    (cptr)cur_pos = (cptr)temp_pos;   


    /* Now set up the size at the first free space header to be the total size
       minus the initial struct at dseg_lo and the inuse bit set to 0 by a left shift. */ 
    ((cptr) cur_pos)->aligned_size = ((total_size - spacer3) << 1);

    /* now set up the pointers initially */
    ((cptr) cur_pos)->fd = (cptr) dseg_lo;
    ((cptr) cur_pos)->bk = (cptr) dseg_lo;
    
    /* and finally set up the footer, but first update our position  */
    temp_pos = (char *) cur_pos + ((((cptr)cur_pos)->aligned_size) >> 1) - spacer2;
    (((sptr)temp_pos)->aligned_size) = ((cptr)cur_pos)->aligned_size;

    /* go back now */
    return 1;
  
}


/* This is a private function for splitting free space into an allocated block
   and a remaining chunk of free space.  The free space is placed back into 
   a linked list of free spaces, all pointers/headers are updated, and a pointer is
   returned corresponding to the free space to be returned to the calling
   program. */

void *split(size_t size, size_t aligned_size, void *cur_pos) {
      
      int spacer1 = sizeof(size_t);
      int spacer2 = sizeof(size_t *);
      void *temp_pos = cur_pos;
      void *temp2_pos = cur_pos;



      /* update our linked list to take this block out of the list of free space.
         Basically, we want to do the following changes to the previous and next free
         blocks:
   
         previous block : next pointer = split free block
                          previous pointer = same
         next block     : next pointer = same
                          previous pointer = split free block


         NOTE: the following format is assumed for free blocks:
         
         |header  |nextpointer |previouspointer|  -free space- |footer|


         First access the previous free block pointer, dereference it, and have the next 
         free block pointer on this previous free space point to the chopped off free
         space.                 
      */



      /* update the temporary position to the start of the split free block */
      temp_pos = (char *)cur_pos + aligned_size;     

      /* update previous pointer regaurdless since cur_pos can never be dseg_lo */
      ((cptr)cur_pos)->bk->fd = (cptr)temp_pos; 
      
        /*Now access the next free block pointer, dereference it, and have the 
          previous free block pointer on this next free space point to the chopped
          off free space. */
 
      /* update next pointer regaurdless since we want a circular linked list*/
      ((cptr)cur_pos)->fd->bk = (cptr)temp_pos;
      
      /* That's done, now the new free block needs new pointers, identical to those
         the unsplit block had before. */

      ((cptr)temp_pos)->fd = ((cptr)cur_pos)->fd;
      ((cptr)temp_pos)->bk = ((cptr)cur_pos)->bk;
    
      /* Ok, the next thing to do is to fill in the header and footer for the split free
         space. */

      /* first update the header */
      ((cptr)temp_pos)->aligned_size = (((((cptr)cur_pos)->aligned_size >> 1) - aligned_size) << 1);

      /* update the temp2 position to the location of the free space footer*/
      temp2_pos = (char *)temp_pos + (((cptr)temp_pos)->aligned_size >> 1) - spacer2;

      /* fill in the footer */
      ((sptr)temp2_pos)->aligned_size = ((cptr)temp_pos)->aligned_size; 

      /* now set the header and footer of the allocated chunk along with 
         the 'in use' flag on the first bit. */

      /* first set up the header */
      ((cptr)cur_pos)->aligned_size = ((aligned_size << 1) | 1);

      /* now move the temp pointer back to the footer of the newly allocated block */
      temp_pos = (char *)temp_pos - spacer2;

      /* go ahead and fill in the footer */
      ((sptr)temp_pos)->aligned_size = ((cptr)cur_pos)->aligned_size;     
      

      /* Finally, return a pointer to the free space. Notice that 
         the old pointers in the free space are now ignored
         while the header and footer are kept. */      


      cur_pos = (char *)cur_pos + spacer1;


      return cur_pos;
}


void *mm_malloc (size_t size)
{
  size_t aligned_size = size;
  int pagesize = mem_pagesize();
  void *newpage, *cur_pos, *temp_pos;
  int spacer1 = sizeof(size_t *);
  int spacer2 = sizeof(size_t);

  /* if there's nothing to allocate then return NULL */
   if (!size) return NULL;  

  /* set up pointers to the begaining of the llist */ 
  (cptr)cur_pos = ((cptr)dseg_lo)->fd;

  /* The final pointer needs to be 8 byte aligned, thus round
     the pointer up to the closest multiple of 8 if it isn't 
     allready a multiple. */
  
  if (!(size == (aligned_size = ((aligned_size >> 3) << 3)))) 
    aligned_size += 8; 

  /* add space to the size for header and footer coalescing info.
     The space for backwards and forwards free space pointers will
     be contained in the required 8 bytes of free space. */

  aligned_size += spacer2 * 2;

  /* go ahead and search for room in the unallocated blocks */


  do {
 
    /* if this block is greater than the needed block size
       then split the block and set it up for use. Note the padding to 
       ensure the split free block is of at least minimum size. */

    if ((((cptr)cur_pos)->aligned_size >> 1) >= (aligned_size + 16)) 
      return split(size, aligned_size, cur_pos);
      
    /* do a check here before continuing */
    if (((cptr)cur_pos)->fd == (cptr)dseg_lo) break;    

    /* if it's equal or greater, and not the end of the list, just update pointers header/footer and return the block */
    if ((((cptr)cur_pos)->aligned_size >> 1) >= aligned_size) {
      ((cptr)cur_pos)->bk->fd = ((cptr)cur_pos)->fd;
      ((cptr)cur_pos)->fd->bk = ((cptr)cur_pos)->bk;

      ((cptr)cur_pos)->aligned_size = ((((cptr)cur_pos)->aligned_size) | 1);
      temp_pos = (char *)cur_pos + ((((cptr)cur_pos)->aligned_size) >> 1) - spacer2;
      ((sptr)temp_pos)->aligned_size = ((cptr)cur_pos)->aligned_size;      

      cur_pos = (char *)cur_pos + spacer2;
      return cur_pos;
    } 

    /* if that block size wasn't big enough, continue on to the next. */
    ((cptr)cur_pos) = ((cptr)cur_pos)->fd;  


  }while(((cptr)cur_pos)->fd != (cptr)dseg_lo);
  

  /* that didn't work so get a new page and compare sizes.
     Note that this may need to be done several times depending 
     on how long the requested size is. */

  do {

    /* If there is no memory left to allocate just return NULL.  */
    if ((newpage = mem_sbrk(pagesize)) == NULL) return NULL;

    /* add up the size of this thing in the header */
    ((cptr)cur_pos)->aligned_size = (((((cptr)cur_pos)->aligned_size) >> 1) + pagesize) << 1;

    /* and the initial struct at dseg_lo */
    ((cptr)dseg_lo)->aligned_size = (((((((cptr)dseg_lo)->aligned_size) >> 1) + pagesize) << 1) | 1);

    /* and the footer */
    temp_pos = (char *)cur_pos + ((((cptr)cur_pos)->aligned_size) >> 1) - spacer1;
 
    ((sptr)temp_pos)->aligned_size = ((cptr)cur_pos)->aligned_size; 

  } while (((((cptr)cur_pos)->aligned_size) >> 1) < (aligned_size + 16));

  /* so there is finally a large enough block, split it up and head home. */
  return split(size, aligned_size, cur_pos);
}


  /* The idea for this function is to take an allocated region
     and first look around for options to coalesce, then set headers for
     free space and instantiate forward/back pointers. */

void mm_free (void *ptr)
{

  int spacer1 = sizeof(cptr);
  int spacer2 = sizeof(size_t);
  void *temp_pos, *temp2_pos, *cur_pos;

  /* set up some usefull variables.  The first is the total size for 
     the free block of a forward coalesce, the second is the total
     size for a backwards coalesce. */ 

  size_t newsize1 = 0;
  size_t newsize2 = 0;


  /* create a pointer aligned back at the header for the space to be
     freed.  */  
  cur_pos = (char *)ptr - spacer2;
  
/*
Coalesce next block
*/

  /* First check the next block. If it's empty and not at the end of
     the heap, then combine the two. First line up the temp pointer */

  temp_pos = (char *)cur_pos + (((cptr)cur_pos)->aligned_size >> 1);

  if (((char *)temp_pos < (char *)dseg_hi) && (!(((cptr)temp_pos)->aligned_size & 1))) {

    /* go ahead and update the size to deal with here. */
    newsize1 = ((((cptr)cur_pos)->aligned_size) >> 1) + ((((cptr)temp_pos)->aligned_size) >> 1);

    /* add the size of the passed pointer and the size of the next free
       block and update the header and footer with this information.
 
       header = footer = newsize << 1  (last bit for occupancy info)
    */

    /* update the header */
    ((cptr)cur_pos)->aligned_size = (newsize1 << 1);

    /* move the temp2 pos up */
    temp2_pos = (char *)cur_pos + newsize1 - spacer2;

    /* and assign to the footer */
    ((sptr)temp2_pos)->aligned_size = ((cptr)cur_pos)->aligned_size;

    /* good, now there needs to be a lot of work done on the old pointers
       in the next block of free space.  These pointers need to be moved 
       to the begaining of the free space, and additionally the next and 
       previous free blocks on the free block linked list have to have
       their pointers updated to point at the begaining of the coalesced
       free space. */

    
    /* go ahead and update linked free blocks. */
    ((cptr)temp_pos)->bk->fd = (cptr)cur_pos;
    ((cptr)temp_pos)->fd->bk = (cptr)cur_pos;

    /* now update the pointers in the coalesced free space */
    ((cptr)cur_pos)->fd = ((cptr)temp_pos)->fd;
    ((cptr)cur_pos)->bk = ((cptr)temp_pos)->bk;


    return;
  }


/*
front of list check
*/

  /* move back a little more */
  temp2_pos = (char *)cur_pos - (2 * spacer1) - spacer2;

  /* now we want to check if this is the start of the llist.  If so, 
     just update some pointers and head out. */
  if ((char *)temp2_pos == (char *)dseg_lo) {

    /* first make this memory free */
    ((cptr)cur_pos)->aligned_size = ((((cptr)cur_pos)->aligned_size) & -2);
    temp_pos = (char *)cur_pos + ((((cptr)cur_pos)->aligned_size) >> 1) - spacer2;
    ((sptr)temp_pos)->aligned_size = ((cptr)cur_pos)->aligned_size;

    /* then update all pointers */
    ((cptr)cur_pos)->fd = ((cptr)dseg_lo)->fd;
    ((cptr)cur_pos)->bk = ((cptr)dseg_lo);

    ((cptr)dseg_lo)->fd->bk = ((cptr)cur_pos);
    ((cptr)dseg_lo)->fd = ((cptr)cur_pos);

    /* all done */
    return;
  }

/*
backwards Coalesce
*/

  /* now is the relatively easier of the two main cases, when the block we're
     freeing is adjacent to a previous free block.  To handle this, 
     there is no need to worry with the free block list pointers since
     the size is the only thing changing.  Thus, just update the header
     and footer with new size information.
     
     First check that this isn't the start of the heap and that the previous
     space is indeed free:
  */

  /* move the current pointer back a bit */
  temp_pos = (char *)cur_pos - spacer2; 
   
  if (!(((sptr)temp_pos)->aligned_size & 1)) {


    /* update the newsize2 */
    newsize2 = ((((cptr)cur_pos)->aligned_size) >> 1) + ((((sptr)temp_pos)->aligned_size) >> 1);


    /* Allrighty, this could be much worse.  Just update the header: */
    temp_pos = (char *)cur_pos - ((((sptr)temp_pos)->aligned_size) >> 1);


    ((cptr)temp_pos)->aligned_size = (newsize2 << 1);    

    /* it's possible we could be stepping on someone's toes. I.e. the next
       free pointer we have is the cur_pos.  Clear that up here. */
    if(((cptr)temp_pos)->fd == ((cptr)cur_pos)) {
      ((cptr)cur_pos)->fd->bk = ((cptr)temp_pos);
     
      ((cptr)temp_pos)->fd = ((cptr)cur_pos)->fd;
    }

    /* and update the footer: */
    temp2_pos = (char *)cur_pos + ((((cptr)cur_pos)->aligned_size) >> 1) - spacer2;
    ((sptr)temp2_pos)->aligned_size = ((cptr)temp_pos)->aligned_size;

    /* and go get lunch. */
    return;
  }

/*
Non - Coalesce Case
*/

  /* finally, what if no coalescing is possible? Then just set up some pointers. */

  /* first make this memory free */
  ((cptr)cur_pos)->aligned_size = ((((cptr)cur_pos)->aligned_size) & -2);
  temp_pos = (char *)cur_pos + ((((cptr)cur_pos)->aligned_size) >> 1) - spacer2;
  ((sptr)temp_pos)->aligned_size = ((cptr)cur_pos)->aligned_size;

  /* now add the free block in at the front of the list */
  ((cptr)cur_pos)->fd = ((cptr)dseg_lo)->fd;
  ((cptr)cur_pos)->bk = ((cptr)dseg_lo);
  
  ((cptr)dseg_lo)->fd->bk = ((cptr)cur_pos);
  ((cptr)dseg_lo)->fd = ((cptr)cur_pos);

}


























































