/* $Id$ */

/*
 * Frustrations, galore - it works in some of the *huge* cases just fine (coalesing)...but not in the 
 * kernel ones...I'm not sure why, either
 */


/*
 * Helper Functions
 *
 * try_incr_heap(factor) - increases heap by factor * pagesize
 *
 * round_to_eight(somenum) - returns next highest integer evenly divisible by 8
 * 
 */

/*
 * Implementation: "Method 2" (Doubly Linked Lists) from class notes
 *
 * An allocated chunk is actually 12 bytes longer than the user thinks - the first 4 bytes are the
 * size of the chunk stored as a long. The next 4 are padding to make sure the alignment works out.
 * The next n bytes (where n is the number of bytes the user requested) is the area where the user's 
 * data is stored. Finally, the last 4 bytes of the chunk is the size repeated once more. A note about
 * the stored size: the actual size of the block is 'size + 1' - by doing it this way, I can simply 
 * do a size % 8 to see if the chunk is free or not(free block % 8 = 0, used % 8 != 0)
 *
 * Free chunks are slightly more complex. Again, the first 4 blocks are the size. The next four are
 * the long interpretation a pointer to the previous free block. If there are no previous free blocks,
 * the pointer is to dseg_lo. The next 4 bytes are again a pointer, but this time to the next free
 * chunk (its dseg_hi if there are no others). The last 4 bytes are the free size again.
 *
 * Results so far: On sets that this works, I've been getting ~ 80% utilization and 1000+ tops/sec.
 * Not bad, but I'd rather this thing worked perfectly ;-)
 *
 */

/* 
 * some sizeof checks:
 * Size of char is: 1
 * Size of char* is: 4
 * Size of void* is: 4
 * Size of int is: 4
 * Size of long is: 4
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "ehn",
    /* First member full name */
    "Jim Gajnak",
    /* First member email address */
    "jgajnak@cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

// var used in debugging
// int jg = 0;

int try_incr_heap(int factor)
{

    // attempts to increase the heap by a factor of page size

    int pagesize = mem_pagesize();
    int used = mem_usage();
    int new_used;

    if (factor < 0)
    {
        printf("malloc.c(try_incr_heap) => FATAL: heap cannot be decreased!!!\n");
        exit(0);
    }

    mem_sbrk(factor * pagesize);

    new_used = mem_usage();

    if ((factor * pagesize) != (new_used - used))
    {
        printf("malloc.c(try_incr_heap) => FATAL: Attempt to increase heap FAILED!!!\n");
        return -1;
    }
    else
    {
        return 0;
    }

}

int round_to_eight(int somenum)
{
    // there's brain-dead routines, and then there's this

    while(somenum % 8 != 0)
       somenum++;

    return somenum;
}

int mm_init (void)
{  
   // make sure at least 1 page is allocated, and set appropriate pointer info
   int ret_val = 0;
   int size;
   long *addr = (long *)dseg_lo;

   if (mem_usage() <= 0)
	  ret_val = try_incr_heap(1);

   size = mem_usage() + 1;

   *addr = size;
   addr = (long *)((long)addr + 4); 
   *addr = (long)dseg_lo;
   addr = (long *)((long)addr + 4);
   *addr = (long)dseg_hi;
   addr = addr + size - 12;
   *addr = size;

   // some debugging output info
/* 
   printf("**********************\n");
   printf("mm_init call completed\n");
   printf("dseg_lo: %p\n", dseg_lo);
   printf("dseg_hi: %p\n", dseg_hi);
*/
   return ret_val;
}

void *mm_malloc (size_t size)
{
   long *addr = (long *)dseg_lo;
   long *ret_addr;
   long *more;
   long *more_too;
   int result = 0;
   // int reqSize = size;
   size = round_to_eight(size + 12);

   // jg += 1;

   //printf("starting %d\n", jg);
//
//	if (jg == 208)
//	{
//		printf("entering block\n");
//		jg = jg;
//	}
  
   // find me first unused block
   more_too = (long *)0;
   while((long)(*addr) % 8 != 0)
   {
	  result = 1;
	  more_too = addr;
	  addr = (long *)((long)(addr) + (long)(*addr) + 1);
  	  //printf("Block: %p\n", addr);
	  //printf("Contents: %ld\n", *addr);
	  //printf("dseg_hi: %p\n", dseg_hi);
   }
	 
   // eeeeewwwww....kludge....
   if ((*addr == 0) && (result))
   {
		*addr = (long)dseg_hi + 1 - (long)addr;
		more = (long *)((long)addr + (long)(*addr) - 4);
		*more = *addr;
		more = (long *)((long)addr + 4);
		*more = (long)more_too;
		more = (long *)((long)addr + 4);
		*more = (long)dseg_hi;
   }
   
   // if we're past dseg_hi, allocate
   if ((long)addr >= (long)dseg_hi)
   {
	  result = try_incr_heap((size / mem_pagesize()) + 1);
      if (-1 * result)
		 return NULL;
	  ret_addr = addr;
	  *addr = result * (size / mem_pagesize() + 1);
	  addr = (long *)((long)addr + 4);
	  *addr = (long)dseg_lo;
	  addr = (long *)((long)addr + 4);
	  *addr = (long)dseg_hi;
	  addr = (long *)((long)dseg_hi - 3);
	  *addr = result * (size / mem_pagesize() + 1);
	  addr = ret_addr;
   }
   
   // find me a block that fits
   more = (long *)((long)addr + 8);
   while((*addr < size) && ((long)(*more) != (long)dseg_hi)) 
   {
	  addr = (long *)(*((long *)((long)addr + 8)));
	  more = (long *)((long)addr + 8);
	  
   }

   // if we're at the end, allocate more space
   if ((*((long *)((long)addr + 8)) == (long)dseg_hi) && (*addr < size))
   {
	  result = try_incr_heap((size / mem_pagesize()) + 1);
	  if (-1 * result)
		 return NULL;
	  result = mem_pagesize();
	  if (*addr % 8 == 0)
	  { 
		 // the block before dseg_hi is free
		 // we've got to merge the two
	     ret_addr = addr;
		 *addr = (long)(*addr) + ((long)result * ((size / mem_pagesize()) + 1));
		 addr = (long *)((long)addr + 8);
		 *addr = (long)dseg_hi;
         addr = (long *)((long)dseg_hi - 3);		 
		 *addr = *ret_addr;
		 addr = ret_addr;
	  }
	  else
	  {
		 // we're starting on a new block
		 ret_addr = addr;
		 addr = (long *)((long)addr + 8);
		 *addr = (long)(*addr) + 1;
		 addr = (long *)(*addr);
		 *addr = ((long)result * ((size / mem_pagesize()) + 1));
		 addr = (long *)((long)(addr) + 4);
		 *addr = (long)ret_addr;
		 addr = (long *)((long)(addr) + 4);
		 *addr = (long)dseg_hi;
		 addr = (long *)((long)dseg_hi - 3);
		 *addr = ((long)result * ((size / mem_pagesize()) + 1));
		 addr = ret_addr;
		 addr = (long *)((long)addr + 8);
		 addr = (long *)(*addr);
	  }
   }
  
   if (*addr - size > 16)
   {
	  //its worth it to make a chunk
	  ret_addr = addr;
	  addr = (long *)((long)addr + size);
	  *addr = *ret_addr - size;
	  addr = (long *)((long)addr + 4);
	  *addr = (long)(*(long *)((long)ret_addr + 4));
	  addr = (long *)((long)addr + 4);
	  *addr = (long)(*(long *)((long)ret_addr + 8));
	  addr = (long *)((long)ret_addr + (long)(*ret_addr) - 4);
	  *addr = *ret_addr - size;
	  addr = (long *)((long)addr + size);
/*	  if (*((long *)((long)addr + 4)) != (long)(dseg_lo))
      {
		 addr = (long *)((long)(*((long *)((long)addr + 4))) + 8);
		 *addr = ((long)addr + size);
		 addr = (long *)((long)addr + size);
      }
	  if (*((long *)((long)addr + 8)) != (long)(dseg_hi))
	  {
         addr = (long *)((long)(*((long *)((long)addr + 8))) + 4);
		 *addr = ((long)addr + size);
	  }
*/			
	  addr = ret_addr;
   }
else
   {
	  // its not
	  ret_addr = addr;
	  size = *addr;
/*	  if (*((long *)((long)ret_addr + 4)) != (long)(dseg_lo))
	  {
		 addr = (long *)((long)(*((long *)((long)ret_addr + 4))) + 8);
		 *addr = (long)*((long *)((long)(ret_addr) + 8));
	  }
	  if (*((long *)((long)ret_addr + 8)) != (long)(dseg_hi))
	  {
		 addr = (long *)((long)(*((long *)((long)ret_addr + 8))) + 4);
		 *addr = (long)*((long *)((long)(ret_addr) + 4));
	  }
	  */
	  if ((long)(*((long *)((long)addr + 4))) != (long)dseg_lo)
	  {
		 addr = (long *)((long)(*((long *)((long)addr + 4))));
		 addr = (long *)((long)addr + 8);
		 more = addr;
		 *addr = (long)*((long *)((long)(ret_addr) + 4));
		 if (*((long *)((long)ret_addr + 8)) != (long)(dseg_hi))
		 {
			addr = ret_addr;
			addr = (long *)(*((long *)((long)addr + 8)));
			addr = (long *)((long)addr + 4);
			*addr = (long)more;
			addr = ret_addr;
		 }

	  }
	  else
	  {
		 addr = (long *)((long)addr + 8);
		 if ((long)*addr != (long)dseg_hi)
		 {
			addr = (long *)((long)addr + 4);
			*addr = *((long *)((long)ret_addr + 4));
		 }
	  }
	  addr = ret_addr;
   }
  
   ret_addr = (long *)((long)addr + 8);
   
   *addr = size - 1;
   addr = (long *)((long)addr + (long)(*addr) - 3);
   *addr = size - 1;

   // some debugging output info
/*
   printf("-----------------------------\n");
   printf("call to mm_malloc() completed\n");  
   printf("Returning: %p\n", ret_addr);
   printf("Requested Size: %d\n", reqSize);
   printf("Actual Size: %d\n", size);
   printf("dseg_lo: %p\n", dseg_lo);
   printf("dseg_hi: %p\n", dseg_hi);
*/
   return ret_addr;
}

void mm_free (void *ptr)
{
   long *addr = ptr;
   long *swap;
   long mergeop = 0;
   long *more;
   
   addr = (long *)((long)addr - 8);
   
   swap = addr;
 /*  
   if ((*addr % 8) == 0)
   {
	  printf("**********>>>>> HEY! <<<<<<<********\n");
	  printf("this space is free already :-P\n");
	  printf("you asked for %p back...well, YOU'RE NOT GETTING IT!!!\n", swap);
	  printf("Size of block %ld\n", *addr);
	  printf("************************************\n");
	  exit(0);
   }
   else
   {
	  printf("Good...this space is used... ;-)\n");
	  printf("(Or, at least, you've fooled me into thinking its used)\n");
   }
   */
   //merge on left if possible...
   if (((long)addr != (long)dseg_lo) && (*((long *)((long)addr - 4)) % 8 == 0))
   {
	  //printf("yes, stuff on left to glob with\n");
	  more = addr;
	  addr = (long *)((long)addr - 4);
	  addr = (long *)((long)addr + 4 - (long)(*addr));
	  *addr = (long)*addr + (long)(*swap) + 1;
      swap = (long *)((long)addr + (long)(*addr) - 4);
	  *swap = (long)(*addr);
	  addr = more;


	  mergeop = 1;
   }

   //merge on right...
   if (((long)addr + *addr != (long)dseg_hi) && (*((long *)((long)addr + *addr + 1)) % 8 == 0))
   {
	  more = addr;

	  if (!mergeop)
	  {
		 addr = (long *)((long)addr + (long)(*addr) + 5);
		 more = (long *)((long)more + 4);
		 *more = *addr;
		 more = (long *)((long)more - 4);
		 addr = more;
	  }
	  addr = (long *)((long)addr + (long)(*addr) + 9);
	  more = (long *)((long)more + 8);
	  *more = *addr;
	  more = (long *)((long)more - 8);
	  addr = (long *)((long)more + (long)(*more) + 1);
	  *more = (long)(*more) + (long)(*addr) + 1;
	  addr = (long *)((long)more + (long)(*more));
	  *addr = *more;
	  addr = more;
	  mergeop = 1;
	  }  
   
   // since we didn't merge right or left, we have to find pointers
   // (can i optimize this more??)
   if (!mergeop)
   {
	  *addr = *addr + 1;
	  addr = (long *)((long)addr + (long)(*addr) - 4);
	  *addr = *addr + 1;
	  addr = swap;
	  if ((long)addr == (long)dseg_lo)
	  {
		 if ((long)addr + (long)(*addr) - 1 == (long)dseg_hi)
         {
			addr = (long *)((long)addr + 8);
			*addr = (long)dseg_hi;
		 }
         else
		 {
			addr = (long *)((long)addr + (long)*addr);
            while (((long)addr + (long)(*addr) - 1 != (long)dseg_hi) && (*addr % 8 != 0))
			   addr = (long *)((long)addr + (long)*addr + 1);
            //if ((long)addr + (long)(*addr) - 1 == (long)dseg_hi)
			if (*addr % 8 != 0)
			{
			   addr = swap;
	           addr = (long *)((long)addr + 8);
	           *addr = (long)dseg_hi;	
			}
            else
			{
			   swap = (long *)((long)swap + 8);
			   *swap = (long)addr;
			   swap = (long *)((long)swap - 8);
			}
		 }
		 

	  }
	  else
	  {
	  	addr = (long *)((long)addr - 4);
	  	while ((((long)addr + 4 - (long)(*addr)) != (long)dseg_lo) && (*addr % 8 != 0) && ((long)addr > (long)dseg_lo))
		 	addr = (long *)((long)addr - (long)(*addr));
		if ((long)addr < (long)dseg_lo)
		{
			addr = swap;
			addr = (long *)((long)addr + 4);
			*addr = (long)dseg_lo;
			while (((long)addr + (long)(*addr) - 1 != (long)dseg_hi) && (*addr % 8 != 0))
			   addr = (long *)((long)addr + (long)*addr + 1);
			if (*addr % 8 != 0)
			{
               addr = swap;	
			   addr = (long *)((long)addr + 8);
			   *addr = (long)dseg_hi;
			}
			else
			{
			   swap = (long *)((long)swap + 8);
			   *swap = (long)addr;
			   swap = (long *)((long)swap - 8);
			}
			
		} else
	  	if (((long)addr + 4 - (long)(*addr)) != (long)dseg_lo)
	  	{
		 	addr = (long *)((long)swap + 4);
		 	*addr = (long)dseg_lo;
		 	addr = (long *)((long)addr + 4);
		 	*addr = (long)swap;
		 	addr = swap;
		 	if ((long)addr + (long)(*addr) - 1 == (long)dseg_hi)
		 	{
				addr = (long *)((long)addr + 8);
				*addr = (long)dseg_hi;
		 	}
		 	else
		 	{
				addr = (long *)((long)addr + (long)*addr);
		 		while (((long)addr + (long)(*addr) - 1 != (long)dseg_hi) && (*addr % 8 != 0))
			   		addr = (long *)((long)addr + (long)*addr + 1);
				// if ((long)addr + (long)(*addr) - 1 == (long)dseg_hi)
				if (*addr % 8 != 0)
				{
					addr = swap;
					addr = (long *)((long)addr + 8);
					*addr = (long)dseg_hi;
				}
				else
				{
			   		swap = (long *)((long)swap + 8);
			   		*swap = (long)addr;
			   		swap = (long *)((long)swap - 8);
				}
		 	}
	  	}
	  	else
	  	{
		 	// easy case - we've got the left pointer...
		 	addr = (long *)((long)addr + 4 - (long)(*addr));
		 	swap = (long *)((long)swap + 4);
		 	*swap = (long)addr;
		 	swap = (long *)((long)swap + 4);
		 	addr = (long *)((long)addr + 8);
		 	*swap = (long)(*addr);
		 	swap = (long *)((long)swap - 8);
		 	addr = swap;
	  	}
	  }
	  
	  // ok, now we make the other free places point
	  swap = (long *)((long)swap + 4);
	  if ((long)*swap != (long)dseg_lo)
	  {
		 addr = (long *)((long)*swap + 8);
		 *addr = ((long)swap - 4);
	  }
	  else
	  {
		 *swap = (long)dseg_lo;
	  }
	  swap = (long *)((long)swap + 4);
	  if ((long)*swap != (long)dseg_hi)
          {
                 addr = (long *)((long)*swap + 4);
                 *addr = ((long)swap - 8); 
          }
          else
          {
                 *swap = (long)dseg_hi;
          }
	  
   }
   
   // some debugging output info
/*
   printf("+++++++++++++++++++++++++++++\n");
   printf("call to mm_free() completed\n");
   printf("Attempted to Free: %p\n", ptr);
   printf("dseg_lo: %p\n", dseg_lo);
   printf("dseg_hi: %p\n", dseg_hi);
*/				  
}

