/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "My Roommate's an Idiot",
    /* First member full name */
    "Kevin Forde",
    /* First member email address */
    "kforde",
    /* Second member full name (leave blank if none) */
    "Omar Zevallos",
    /* Second member email address (blank if none) */
    "omarz"
};

/*****************************************************************************
                                  213.Malloc
                      a My Roommate's an Idiot production
		            Kevin Forde  - kforde
           		    Omar Zevallos - omarz

   Datastructure 
   ------------- We've implemented the malloc package using implicit lists.
   Within each block, the first 8 bytes are the "header" where, in the first
   byte, the size of the block is stored. In the fourth block, an allocation
   flag is stored where 0 means the block is allocated, 1 means it is free.
   Key "phrases" look out for are

       *((int *) heap)       => size of the current block as an int
       *((int *) (heap + 4)) => allocation flag of current block as an int
       *((int *) heap) + 8   => the beginning of the next block

   Other manipulation that looks like the above "phrases" can be understood
   readily if the above are understood.
       
   Algorithm
   --------- The implemented algorithm goes through a basic initialization 
   of the whole heap, allocates the requested sizes in three phases (detailed
   below), and then frees the requested pointers utilizing monodirectional 
   (or "lazy") coalescing. The detailed process of the funtions follows...

   Initialization - int mm_init (void)
      This function simply creates a heap with a region as large as twice
      the current system pagesize. However, if there is a problem creating
      the initial heap of this size, and the helper function mem_sbrk(size)
      has a problem reserving this memory for the heap, then -1 is returned
      and the process ends. However, if there is no problem, then the first
      and fourth bytes of the header of the heap (see Datastructure) are
      filled in with their respective values. Upon successful completion, 0
      is returned and the process continues.

   Allocation - void *mm_malloc (size_t size)
      Within this function, the key algorithm of the process takes place in
      three main phases (described in more detail below). First, however, 
      local variables are declared and alignment is checked. Then the first 
      phase traverses through the heap looking for the first free block 
      that will fit the requested. If that block is found, then it is
      returned. However, if it is not found, then the second phase starts
      where the current free space is coalesced so as to possibly combine 
      smaller blocks of free space into fewer blocks with more free space,
      possibly coalescing two blocks into one large enough for the requested
      size. If a sufficiently large block is allocated, then return the
      pointer to that block. However, If the second phase doesn't fit a
      block of the appropriate size, then the third phase starts where 
      mem_sbrk(size) is called to expand the memory by the size required to
      fit the allocated block. The allocation occurs here, or if we've run 
      out of memory, then the expansion of the memory cannot complete 
      successfully and the requested size cannot be allocated, so NULL is 
      returned.

   Freeing - void mm_free (void *ptr)
      This process utilizes monodirectional coalescing whereby if the next
      block's allocation flag (see Datastructure) is 1, then the current
      pointer is freed and combined with the next block to create a larger
      block. This is done simply by changing the size of the pointer now
      being freed to it's own size plus the size of the next block. The
      allocation flag of the current pointer is set to 1 either way.
      
   Phases
   ------
      Phase 1 : Find First Adequate Free Block
	        The traversal of the heap occurs through a for-loop where
		the check that occurs makes certain that the block is
		still within the bounds of the initialized region. The 
		allocation byte is then checked, and if already allocaeted,
		the for-loop iterates and tries the next block. If the block
		is free, the size of that block is checked. If it matches 
		precisely, then the block is allocated and mm_malloc(size) 
		returns the pointer. If the size of the block is less than 
		the current size of the free block, enough space is allocated 
		and the remaining free space is re-allocated as a new, smaller 
		free block. The pointer is returned if the fit is found. If
		not, then the second phase occurs.
  
      Phase 2 : Coalesce to Make an Adequate Free Block
                Since a large-enough free block couldn't be found on the
		first traversal, the free blocks in the heap are coalesced,
		much like in mm_free(ptr) (see Freeing). If an adequate block
		is created to be allocated to the requested size, then it is
		immediately allocated and coalescing stops by the returning
		of the pointer. The differences in this coalescing and the
		method used in mm_free(ptr) is that in this phase, coalescing
		can stop at any time (ie, when a large-enough free block is
		made) and if the current pointer cannot be coalesced, then
		the an attempt is made on the next block (via the for-loop).
		If coalescing is not successful, then more memory is required. 
                

      Phase 3 : Expand Memory to Make an Adequate Free Block
                The first check this phase does is to see if the last block
		is already free. If it is, then we try to expand the memory 
		by the amount we require so as to coalesce the two blocks 
		required. However, if the last block as been allocated, then
		we need to expand the memory by the amount requested plus
		enough for the header. If this memory-expansion operation is
		successful, then we traverse the list a method VERY similar
		to Phase 1. If the memory-expansion fails, however, then
		there is no way to fit the requested size, so the process
		cannot successfully complete, and NULL is returned.


******************************************************************************/


int mm_init (void)
{
  void *heap;

  int size = 2 * mem_pagesize();

  heap = mem_sbrk(size);

  if (!heap)
    return -1;

  *((int *) heap) = size - 8;
  *((int *) (heap + 4)) = 1;

  return 0;
}

void *mm_malloc (size_t size)
{
  void *heap;
  void *coalHeap;
  void *ifMemExp;
  
  int req_size;
  
  if((size % 8) != 0)
    size += 8 - (size % 8);
  req_size = size + 8;
  
  /*------------------------------------------*
   * Phase 1 : Find First Adequate Free Block *
   *------------------------------------------*/
  for (heap = dseg_lo; 
       (heap + *((int *) heap)) + 8 < (void *) dseg_hi; 
       heap += *((int *) heap) + 8)
    {
      if ( *((int *) (heap + 4)) )
	{
	  if ( *((int *) heap) == size )
	    {
	      *((int *) (heap + 4)) = 0;

	      return (heap + 8);
	    }
	  else if ( *((int *) heap) >= req_size )
	    {
	      *((int *) (heap + req_size)) = *((int *) heap) - req_size;
	      *((int *) (heap + req_size + 4)) = 1;
	      *((int *) heap) = size;
	      *((int *) (heap + 4)) = 0;

	      return (heap + 8);
	    }	 
	}
    }
  
  /*---------------------------------------------------*
   * Phase 2 : Coalesce to Make an Adequate Free Block *
   *---------------------------------------------------*/
  for(coalHeap = dseg_lo;
      ((coalHeap + *((int *) coalHeap)) + 8 < (void *) dseg_hi); 
      coalHeap += (8 + *((int *) coalHeap)))
    {
      if( *((int *) (coalHeap + 4)) )
	{
	  if( *((int *)(coalHeap + *((int *) coalHeap) +12)) )
	    {
	      *((int *) coalHeap) += *((int *) (coalHeap +8 + *((int *) coalHeap))) + 8;
	      if( *((int *) coalHeap) == size )
		{
		  *((int *) (coalHeap + 4)) = 0;
		  
		  return (coalHeap + 8);
		}
	      else if( *((int *) coalHeap) >= req_size )
		{
		  *((int *) (coalHeap + req_size)) = *((int *) coalHeap) - req_size;
		  *((int *) (coalHeap + req_size + 4)) = 1;
		  *((int *) coalHeap) = size;
		  *((int *) (coalHeap + 4)) = 0;
		  
		  return (coalHeap + 8);
		}
	    }
	  else coalHeap += 8 + *((int *) coalHeap);
	}
    }
  
  /*--------------------------------------------------------*
   * Phase 3 : Expand Memory to Make an Adequate Free Block *
   *--------------------------------------------------------*/
  if ( *((int *) (heap + 4)) )
    ifMemExp = mem_sbrk(size);
  else
    ifMemExp = mem_sbrk(req_size);
  
  if (!ifMemExp)
    return NULL;
  else
    {
      if ( *((int *) (heap + 4)) )
	*((int *) heap) += size;
      else
	{
	  heap += *((int *) heap) + 8;
	  *((int *) (heap + 4)) = 1;
	  *((int *) heap) = size;
	}
      
      for (; heap < (void *) dseg_hi; heap += (*((int *) heap) + 8))
	{
	  if( *((int *) (heap + 4)) )
	    { 
	      if( *((int *) heap) == size )
		{
		  *((int *) (heap + 4)) = 0;
		  
		  return (heap + 8);
		}
	      else if( *((int *) heap) >= req_size )
		{
		  *((int *) (heap + req_size)) = *((int *) heap) - req_size;
		  *((int *) (heap + req_size + 4)) = 1;
		  *((int *) heap) = size;
		  *((int *) (heap + 4)) = 0;
		  
		  return (heap + 8);
		}	 
	    }
	}
      
      return NULL;
    }    
}

void mm_free (void *ptr)
{
  ptr = ptr - 8;
  
  if( *((int *)(ptr + *((int *) ptr) + 12)) )
    {
      *((int *) ptr) += *((int *) (ptr + 8 + *((int *) ptr))) + 8;
      *((int *) (ptr + 4)) = 1;
    }
  else 
    *((int *) (ptr + 4)) = 1;
}
