/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *

control data:

for all blocks, first word:
  high 31 bits contain length of block (inc control data)
    in bytes
  low bit is flag: 1 if this AND prev block are allocated, 0 otherwise

if block is free
  if block is 4 words long
    linked list
      length   next           prev
    +-------+-------+-------+-------+

  if block >= 6 words long
    make binary tree and start of linked list
      length   left   right    L.L.           parent
    +-------+-------+-------+-------+--//---+-------+

    ...except that parent points not to the parent block, 
       but to the memorylocation that points back to this block
    so if this the right child of block shown below:
      length   left   right    L.L.           parent
    +-------+-------+-------+-------+--//---+-------+
                        ^
                parent points here

      binary tree sorted by length of blocks


 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define NUM_CLASSES 16

team_t team = {
    /* Team name to be displayed on webpage */
    "100% SVI",
    /* First member full name */
    "Shawn T Van Ittersum",
    /* First member email address */
    "shawnv",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};


void add_to_free_list(void ***ptr)
{
  /* insert this node at start of list */

  *ptr = *((void***)(dseg_lo));  /* set next to old first node */

  *(ptr+2) = dseg_lo;  /* set prev */

  if (*ptr)
    *((*ptr)+2) = ptr;  /* set next's prev */

  *((void***)(dseg_lo)) = ptr;  /* we are now first node of list */
}


void ***remove_from_free_list(void ***ptr)
{
  *(*(ptr+2)) = *ptr;  /* set prev's next */

  if (*ptr)
    *((*ptr)+2) = *(ptr+2);  /* set next's prev */

  return ptr;
}


unsigned int bytes_to_ALB(unsigned int numBytes)
{
  return (numBytes+7) & (~7);
}

unsigned int words_to_ALB(unsigned int numWords)
{
  return ((numWords+1)<<2) & (~7);
}

unsigned int ALB_to_bytes(unsigned int ALB)
{
  return (ALB & (~7));
}

unsigned int ALB_to_words(unsigned int ALB)
{
  return ALB_to_bytes(ALB)>>2;
}


int mm_init (void)
{
  int i;

  if (dseg_hi < dseg_lo)
    if (!mem_sbrk(mem_pagesize()))
      return -1;
  
  for (i=0;i<NUM_CLASSES;i++) {
    *((void **) (dseg_lo+i*4)) = 0;
  }

  /* root of tree */
  *((void **) (dseg_lo+NUM_CLASSES*4)) = dseg_lo+(NUM_CLASSES+2)*4;
  
  /* free block starts here, with length word */
  *((void **) (dseg_lo+ (NUM_CLASSES+1)*4)) = bytes_to_ALB(mem_usage()+1-(NUM_CLASSES+2)*4);
  /* free block
  *((void **) (dseg_lo+(NUM_CLASSES+2)*4)) = 0;   /* left child */
  *((void **) (dseg_lo+(NUM_CLASSES+3)*4)) = 0;   /* right child */
  *((void **) (dseg_lo+(NUM_CLASSES+4)*4)) = 0;   /* linked list */
  *((void **) (dseg_hi-7)) = dseg_lo+NUM_CLASSES*4;  /* parent (root) */

  *((void **) (dseg_hi-3)) = 0;   /* not allocated at end */
                                /* 4 bytes wasted at end */

  /* largest free block in tree */
  *((void **) (dseg_lo+4)) = dseg_lo+(NUM_CLASSES+2)*4;

  return 0;
}


void  add_to_free_tree(void ***tree, size_t size, void **node)
{
  int length;
  
  if (!node)
    return;

  if (! (*tree)) {
    *tree = node;
    *(node+ALB_to_words(*(node-1))-2) = tree;  /*set new parent */
    return;
  }

  length = ALB_to_words(*((*tree)-1));

  if (size >= length)
    add_to_free_tree((*tree)+1,size,node);
  else   /* size < length */
    add_to_free_tree(*tree,size,node);
}


/*  assumption:  size is multiple of 2 (words) */
void  add_to_free(size_t size, void **node)
{ 
  if (size > 5) {
    *((unsigned int *)(node-1)) = words_to_ALB(size);
    *node = 0;       /* no left child */
    *(node+1) = 0;   /* no right child */
    add_to_free_tree((void **)(dseg_lo+NUM_CLASSES*4), size, node);
  }
  else if (size == 4) {
    *((unsigned int *)(node-1)) = words_to_ALB(4);
    add_to_free_list(node);
  }
  else {   /* size == 2 */
    *(node-1) = words_to_ALB(size) + 1;   /* can't use; allocate */
    *((unsigned int *)(node+size-1)) += 1;
  } 

}


void *find_least_node(void **node)
{
  if (*node)
    return find_least_node(*node);
  
  return node;
}


void remove_from_free_tree(void ****node)
{
  void ****temp;
  
  if (! (*node)) {         /* no left child */
    /* set parent to point to right child */
    *(*(node+ALB_to_words(*((unsigned int *)(node-1)))-2)) = *(node+1);

    if (*(node+1))
      /* set right child's parent to be this node's parent */
      *((*(node+1))+ALB_to_words(*((unsigned int *)((*(node+1))-1)))-2) = 
	*(node+ALB_to_words(*((unsigned int *)(node-1)))-2);
  }
  else if (! *(node+1)) {  /* no right child */
    /* set parent to point to left child */
    *(*(node+ALB_to_words(*((unsigned int *)(node-1)))-2)) = *node;

    /* set left child's parent to be this node's parent */
    *((*node)+ALB_to_words(*((unsigned int *)((*node)-1)))-2) = 
      *(node+ALB_to_words(*((unsigned int *)(node-1)))-2);
  }
  else {
    /* find least node on right side, move it to top */
    temp = find_least_node(*(node+1));

    /* set temp's parent to point to right child of temp */
    *(*(temp+ALB_to_words(*((unsigned int *)(temp-1)))-2)) = *(temp+1);
    
    if (*(temp+1))     /* temp has a right child */
      /* set temp's right child's parent to be temp's parent */
      *((*(temp+1))+ALB_to_words(*((unsigned int *)((*(temp+1))-1)))-2) = 
	*(temp+ALB_to_words(*((unsigned int *)(temp-1)))-2);

    *temp = *node;           /* copy our left child to temp*/
    /* set left child's parent to be temp */
    *((*node)+ALB_to_words(*((unsigned int *)((*node)-1)))-2) = 
      temp;
    
    *(temp+1) = *(node+1);   /* copy our right child to temp*/

    /* if right child was temp, then it's not there anymore */
    if (*(node+1))  /* check right child */
      /* set right child's parent to be temp+1 */
      *((*(node+1))+ALB_to_words(*((unsigned int *)((*(node+1))-1)))-2) = 
	temp+1;

    /* set our parent to point to temp */
    *(*(node + ALB_to_words(*((unsigned int *)(node-1)))-2)) = temp;

    /* set temp's parent to be our parent */
    *(temp + ALB_to_words(*((unsigned int *)(temp-1)))-2) = 
      *(node + ALB_to_words(*((unsigned int *)(node-1)))-2);
  }
}


inline void remove_from_free(void ***node)
{
  if (ALB_to_words(*(node-1)) == 4)
    remove_from_free_list(node);
  else
    remove_from_free_tree(node);

}
  

/* precondition: node is known to be 16+ bytes */

void *find_best_fit(size_t size,void **node)
{
  int length;
  void **temp;
  
  if (!node)
    return 0;
  
  length = ALB_to_words(*((unsigned int *)(node-1)));
  
  if (length < size) {    /* this node not big enough */
    if (*(node+1))   /* try right child */
      return find_best_fit(size, *(node+1));
    else
      return 0;   /* no right child */
  }
  
  if (length > size)
    if (*node)   /* try left child */
      if (temp = find_best_fit(size, *node))
	return temp;

  remove_from_free_tree(node);

  if (length > size)
    add_to_free(length-size,node + size);
  else   /* mark next block as this/prev allocated */
    (*((unsigned int *)(node+length-1))) += 1;
  
  
  /* mark this block as this/prev allocated */
  *((unsigned int *)(node-1)) = words_to_ALB(size) + 1;  /* 0x1 is allocated flag */

  return node;
}


void *mm_malloc (size_t size)
{
  int numWords;
  void **result;
  void **temp;
  
  numWords = ALB_to_words(size+4+7);   /* +4 bytes to hold ALB */

  if (numWords < 5) {               /* try a 16-byte block */
    if (*((void **) dseg_lo)) {     /* are there 16-byte blocks left? */
      result = *((void **)dseg_lo);

      remove_from_free_list(result);

      /* mark next block as this/prev allocated */
      (*((unsigned int *)(result+3))) += 1;
      
      /* mark this block as this/prev allocated */
      *((unsigned int *)(result-1)) = words_to_ALB(4) + 1;  /* 0x1 is allocated flag */

      return result;
    }
  }
  /* else look in free tree */
  while (! (result = find_best_fit(numWords,
					   *((void **)(dseg_lo+NUM_CLASSES*4))))) {

    /* no free blocks big enough; add another page */
    
    if (!mem_sbrk(mem_pagesize()))
      return NULL;   /* no more memory */

    *((void **)(dseg_hi-3)) = 0;    /* new last-page boundary */

    if (!((*((unsigned int *)(dseg_hi-3-mem_pagesize())))&1)) { /* previous block not allocated */
      temp = *(*((void ***)(dseg_hi-7-mem_pagesize())));   /* coalesce */
      remove_from_free(temp);
      add_to_free(ALB_to_words((*(temp-1))+mem_pagesize()),temp);
    }
    else {    /* create new free block */
      add_to_free(ALB_to_words(mem_pagesize()),
		  dseg_hi+1-mem_pagesize());
      
    }
    
  }   /* then try looking again */
  
  return result;
}

void mm_free (void *ptr)
{
  void **node = ptr;
  int length;

  length = ALB_to_words(*(node-1));

  if (!((*((unsigned int *)(node+length-1)))&1)) {    /* next block not allocated */
    remove_from_free(node+length);
    length += ALB_to_words(*(node+length-1));
  }
  if (!((*((unsigned int *)(node-1)))&1)) { /* prev block not allocated */
    node = *(*((void ***)(node-2)));
    length += ALB_to_words(*(node-1));
    remove_from_free(node);
  }
  *((unsigned int *)(node-1)) = words_to_ALB(length);
  *((unsigned int *)(node+length-1)) = *((unsigned int *)(node+length-1)) & (~1);
  add_to_free(length,node);
}

