/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

/* size of atomic memory chunk (guaranteed to be at least as large as a word) */
#define CHUNK_SIZE 8
#define CHUNK_SIZE_MASK (~((block_size_t)0x07));

#define ALOC_MASK ((block_size_t)0x01)

typedef void *block_ptr;
typedef unsigned long block_size_t;

team_t team = {
    /* Team name to be displayed on webpage */
    "Meat Helmets",
    /* First member full name */
    "Neal Burns",
    /* First member email address */
    "nburns@cs.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

void *allocate_block(block_ptr block, int aloc_size);
int expand_heap(block_ptr block);

int mm_init (void)
{
  block_ptr block_start;
  block_size_t *block_size;
  block_ptr *block_prev;
  signed long len;

  block_start = dseg_lo;

  len = (signed long)((block_ptr)dseg_hi - block_start);

  if(len < 0) len = 0; /* eliminate negative sizes (why does this happen anyway??) */
  len &= CHUNK_SIZE_MASK; /* round down to nearest multiple of CHUNK_SIZE */

  if(len <= (2*CHUNK_SIZE)) { /* heap must be larger than 2 chunks */
    mem_sbrk(mem_pagesize()); /* expand heap by one page */
    len = (signed long)((block_ptr)dseg_hi - block_start);
    len &= CHUNK_SIZE_MASK;
  }

  block_size = (block_size_t *)block_start;
  block_prev = (block_ptr *)(block_start+4);

  /* create first block */
  len -= 2 * CHUNK_SIZE;
  *block_size = (block_size_t)len;
  *block_prev = NULL;

  /* create terminating empty block */
  block_size = (block_size_t *)(block_start + CHUNK_SIZE + len);
  block_prev = (block_ptr *)(block_start + CHUNK_SIZE + len + 4);
  *block_size = 0;
  *block_prev = block_start;

  return 0;
}

void *mm_malloc (size_t size)
{
  void *retval = NULL;
  block_size_t effective_size, cur_size=0;
  int cur_aloc_flag;
  block_ptr loc;

  /* round up to nearest multiple of CHUNK_SIZE */
  effective_size = (size + (CHUNK_SIZE - 1)) & CHUNK_SIZE_MASK;

  loc = dseg_lo;
  while(loc) {
    cur_size = *((block_size_t*)loc) & CHUNK_SIZE_MASK;
    cur_aloc_flag = *((block_size_t*)loc) & ALOC_MASK;

    if(!cur_aloc_flag && (cur_size >= effective_size)) {
      retval = allocate_block(loc, effective_size);
      break;
    }
    /* current block was inappropriate... */
    if(!cur_aloc_flag && ((cur_size == 0) || (*((block_size_t*)(loc+CHUNK_SIZE+cur_size)) == 0))) {
      if(!expand_heap(loc))
	loc = NULL; /* set error state */
    }
    else
      loc += cur_size + CHUNK_SIZE;
  }

  return retval;
}

void mm_free (void *ptr)
{
  block_ptr prev_block, cur_block, next_block, next_next_block;

  cur_block = (block_ptr)(ptr-CHUNK_SIZE);

  *((block_size_t*)cur_block) ^= ALOC_MASK; /* unset allocated bit */

  prev_block = *((block_ptr*)(cur_block+4));
  next_block = cur_block + CHUNK_SIZE + (*((block_size_t*)cur_block));

  /* is prev_block allocated? */
  if(prev_block && !(*((block_size_t*)prev_block) & ALOC_MASK)) {
    *((block_size_t*)prev_block) += CHUNK_SIZE + *((block_size_t*)cur_block);
    *((block_ptr*)(next_block+4)) = prev_block;
    cur_block = prev_block;
  }

  /* is next_block allocated? */
  if(*((block_size_t*)next_block) && !((*((block_size_t*)next_block) & ALOC_MASK))) {
    next_next_block = next_block + CHUNK_SIZE + (*((block_size_t*)next_block));
    *((block_size_t*)cur_block) += CHUNK_SIZE + *((block_size_t*)next_block);
    *((block_ptr*)(next_next_block+4)) = cur_block;
  }
}

/* allocate block at 'block' with desired length 'aloc_size' and return start of usable memory */
void *allocate_block(block_ptr block, int aloc_size)
{
  block_ptr new_block;
  block_size_t block_size = *((block_size_t*)block);
  block_ptr next_block;

  if((block_size - aloc_size) <= CHUNK_SIZE) {
    *((block_size_t*)block) |= ALOC_MASK; /* set allocated */
    return block + CHUNK_SIZE;
  }

  next_block = block + CHUNK_SIZE + block_size;

  /* need to split... */
  *((block_size_t*)block) = aloc_size | ALOC_MASK;
  new_block = block + CHUNK_SIZE + aloc_size;
  *((block_size_t*)new_block) = block_size - aloc_size - CHUNK_SIZE;
  *((block_ptr*)(new_block+4)) = block;

  *((block_ptr*)(next_block+4)) = new_block; /* update next block to point back to new block */

  return block + CHUNK_SIZE;
}

/* expand 'block', return nonzero on success, zero otherwise */
int expand_heap(block_ptr block)
{
  signed long add_len;
  block_ptr empty_block;

  if(!mem_sbrk(mem_pagesize())) /* expand heap by one page */
    return 0;

  add_len = (signed long)((block_ptr)dseg_hi - block);
  add_len &= CHUNK_SIZE_MASK;

  /* adjust block size */
  add_len -= 2 * CHUNK_SIZE;
  *((block_size_t*)block) = (block_size_t)add_len;

  /* recreate empty block */
  empty_block = block + CHUNK_SIZE + add_len;
  *((block_size_t*)empty_block) = 0;
  *((block_ptr*)(empty_block+4)) = block;

  return 1;
}
