/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "N/A",
    /* First member full name */
    "Tsz Fung Albert Li",
    /* First member email address */
    "tali@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Yik Lam Yu",
    /* Second member email address (blank if none) */
    "yiklam@andrew.cmu.edu"
};

/*Algorithm:



 */


/**************Start of program ******************************************/

/*This is the structure of the freeblock. size = size of the current free block prev is the pointer which points to the previous free block on the free list, and next is the pointer which points to the next free block on the free list.Flag is embedded in the last bit of size field, when the previous block in the heap is allocated, flag is 1 which means that the last bit of the size is 1, if the previous block is free, the flag is 0.
-----------------------------------------------
|flag|      |      |                      |    |
|----| prev | next |       free space     |size|
|size|      |      |                      |    |
-----------------------------------------------
<-----struct ------>
   of a free block
*/
struct fb_header { 
  int size; 
  struct fb_header *prev; 
  struct fb_header *next; 
};


/*This function is used to change the next block's allocated flag to allocated if the current block is allocated.*/
void setFlag(struct fb_header *p)
{
 (*((int *) ((char *) (p) + ((p->size) & ~(1))  ))) ++;
}

/*This function is used to change the next block's allocated flag to free if the current block is free*/
void deFlag(struct fb_header *p)
{
 ((*((int *) ((char *) (p) + ((p->size) & ~(1)))))) = ((*((int *) ((char *) (p) + ((p->size) & ~(1)))))) & ~(1);
}



/*This function will move the pointer (which is pointing to the current block) to the next block by adding the current pointer with the size of the current block*/
struct fb_header * toNextBlock(char *p)
{
  return ((struct fb_header *) (p +  ((((struct fb_header *) (p))->size) & ~(1)) ));

}


/*Check whether the current block is allocated by checking the next block's allocated flag, if the flag =1, the current block is allocated, otherwise, flag =0*/
int isAllocated(struct fb_header *p)
{
  return (((toNextBlock((char *) (p)))->size) & (1));
}

/*check whether the next block is allocated by checking the block after the next block's allocated flag. if the flag =1, the next block is allocated, otherwise,it is free*/
int nextIsAllocated(struct fb_header *p)
{
  if (((toNextBlock((char *) (p)))->size) <8) return 1;
  else 
    return (((toNextBlock((char *) (toNextBlock((char *) (p)))))-> size) & (1));
}


/*Traverse through the free list, and find the free block with the best size, where best size > requested size, and return the pointer to that best free block.If all the free block are too small to be allocated, the function will return NULL*/
struct fb_header * getBest(struct fb_header head, int size)
{
  struct fb_header * best,* curPtr;
  int bestsizediff = ~ (1 << 31);
  curPtr = head.next;
  best = curPtr;
  
  while (curPtr !=NULL)
    {
      if (((curPtr->size) & (~(1))) == size) return curPtr;
      else if (((curPtr->size) & (~(1))) > size) 
	{
	  if ((((curPtr->size) & (~(1))) - size) < (bestsizediff))
	  	{
			best = curPtr;
			bestsizediff=((curPtr->size) & (~(1)))-size;
		}
	}
      curPtr = curPtr->next;
    }
  
  if (best==NULL) return NULL;
  else if (((best->size) & (~(1))) < size) return NULL;
  else return best;
}

/*Insert the free block into the head of the free list.*/
void Insert(struct fb_header *p, struct fb_header *fb)
{
  fb->next = p->next;
  fb->prev = p;
  if (fb->next) 
    (fb->next)->prev = fb;
  p->next = fb;
} 

/*Remove the current block from the free list*/
void Remove(struct fb_header *curPtr)
{
  ((curPtr->prev) ->next) = (curPtr->next);
  if (curPtr->next) (curPtr->next)->prev = curPtr->prev;
}


/*calculate the appropriate index when the size is given. The first 64 bins are multiples of 8, then there are 32 bins that are 256 apart, 16 bins 512 apart,8 bins that are 1024 apart, 4 bins that are 2048 apart, 2 bins that are 4096 apart,and the last bin which contains all free blocks of size >4096*/
int cal_index(size) 
{
  if (size<9) return 1;
  else if (size<= 508) return ((size+3) >>3);
  else if (size <= 2556) return (((size-509) >> 6) +64);
  else if (size <= 10748) return (((size-2557) >> 9) + 96);
  else if (size <= 43516) return (((size-10749) >> 12) + 112);
  else if (size <= 174588) return (((size-43517) >> 15) + 120);
  else if (size <= 698876) return (((size-174589) >> 18) + 124);
  else return 127;
}

/*Given the pointer of a free block, this function uses the size to find the  right index, and put the free blcok back to the right free list*/
void putback(struct fb_header * newfb_ptr)
{
  int index;

  index = cal_index(newfb_ptr->size-4);
  Insert((struct fb_header *)(dseg_lo +((index-1)*12) +4),newfb_ptr);
}


/*Given a pointer to a free block and the requested size, this will split the free block into the 2 blocks, one is the aligned size for the allocated request, and the remaining block will remain free. The remaining free block will be put back on the appropriate free list*/
void Split(struct fb_header *curPtr, int size)
{
  int flag = ((curPtr->size) & 1);
  struct fb_header * newfb_ptr;
  int newfb_size;

  newfb_size = ((curPtr->size) & ~(1)) - size;
  curPtr->size = size + flag;
  newfb_ptr = ((struct  fb_header *)(((char *)(curPtr)) + size));
  (*((int *)(((char *)(newfb_ptr)) + newfb_size - 4))) = newfb_size;

  newfb_ptr->size = newfb_size;
  putback(newfb_ptr);
}

/*This function is needed when there is no best block found after 3 tries, and the largest size's block is not enough to be allocageted. This will ask the system to give more memory by calling mem_sbrk, and check whether there's any free block at the last part of the heap. If there is, that free block will merge with the newly requested memory, otherwise, the function wil just request memory from system and update the appropriate fields.Then the function will return the pointer to the free block*/
struct fb_header * Expand(int size)
{
  /*get the last byte and find the allocation flag*/ 
  int flag, lastb_size;
  struct fb_header * curPtr, * lastb_ptr;
  
  curPtr = (struct fb_header *)(dseg_hi - 3);
  lastb_ptr = curPtr;
  flag = ((*(int *) (dseg_hi - 3)) & (1));
  if (flag)
    {
      if (mem_sbrk(16384)==NULL) return NULL;
      curPtr ->size= 16385;
      lastb_ptr = curPtr;
      (*(int *)(dseg_hi - 7)) = 16384;
    }
  else 
    {
      lastb_size = (*(int *)(dseg_hi - 7));
      lastb_ptr = ((struct fb_header *)(((char*)(curPtr)) - lastb_size));
      while ((*(int *)(dseg_hi - 7)) < size)
	{
	  if(mem_sbrk(16384)==NULL) return NULL;
	  lastb_ptr ->size = lastb_ptr->size + 16384;
	  (*(int *)(dseg_hi - 7)) = ((lastb_ptr->size) & ~(1));
	}

    }
  *((int *)(dseg_hi-3)) = 4;
  return lastb_ptr;
}


/*This will initialize the heap, and the array which needs to store the information of the free lists. If there is problem initializing, this will return -1. If the initialization is completed successfully, this will return 0*/
int mm_init (void)
{ 
  struct fb_header *fb;
  struct fb_header *ha = (struct fb_header *)(dseg_lo-8); 
  int i, index; 

  if ((mem_sbrk(16384)) == NULL) return -1;
  else
    {
      for (i=1;i<= 127;i++)
	{
	  ha[i].next = NULL;
	  ha[i].prev = NULL;
	  ha[i].size = 12;
	}
      *((int *)(dseg_lo + 1532)) = 14849; /*size of one large free block*/
      *((int *)(dseg_hi - 7)) = 14848;
      *((int *)(dseg_hi-3)) = 4;
      
      fb = (struct fb_header *) (dseg_lo + 1532);
      index = cal_index(14848);
      
      Insert(&ha[index], fb);
    }

  (int *) (*((int *)(dseg_lo)))= (int *) (dseg_lo + 1532);
  return 0;
}


/*This function is called to allocate the memory from the heap, and return the pointer to the block of the memory that is to be allocated.The general algorithm is described at the top of the file. The main idea is to go to the right bin by calculating the index using the requested size, do a best fit search, if there is such a best free block, the pointer to that block will be returned. If there isn't such a block, a few bigger bins will be checked, and if there still no best free block, it will check the largest bin and see whether the larest bin's free block is big enough to be allocated. If it is not, the function will check the last block at the end of the heap and see whether the size is big enough to be allocated. If it is still not possible to allcoate, it will expand the memory by caling mem_sbrk and get extra pages of memory until such a free block can be allocated.*/
void *mm_malloc (size_t size)
{
   
  int index;
  int rem_time = 127;
  struct fb_header * ret_ptr=NULL;

  struct fb_header *ha = (struct fb_header *)(dseg_lo-8);
  
  index = cal_index(size);

  while ((ret_ptr==NULL) && (rem_time>0) && (index<127))
    {
      ret_ptr = getBest(ha[index], size +4);
      rem_time--;
      index++;
    }

  if (ret_ptr==NULL)
    {
      /* go to the largest chunk */
      ret_ptr = getBest(ha[127], size+4);

    }

  size = size +4;
  size = ((size + 7) >> 3) << 3;

  if (ret_ptr==NULL) ret_ptr= Expand(size) ;

  if (ret_ptr !=NULL)
    {
      if (!((((*(int *)(dseg_hi - 7)) >> 14 ) <<14 ) == (*(int *)(dseg_hi - 7)))) Remove(ret_ptr); /* if not divisible by 16384 */
      
      if (((ret_ptr->size) - size )> 15)
	Split(ret_ptr,size);
    }
			
  
  if (ret_ptr!= NULL) setFlag(ret_ptr);
  
  if (ret_ptr!=NULL) (char *) (ret_ptr) = (char *) (ret_ptr) + 4;
  return ret_ptr;
}


/*This function will take in a pointer, and free that block by coaleascing it with any free block in front or behind, and put it back to the appropriate free list.First, it will check whether the next block is free, if it is, the current block will merge with the next block, and form a larger free block. Then it will check whether the previous is free, if it is, the current block will merge with the previous block and form a larger free block. After all the coaleascing is completed, this block will be marked free by getting to the next block's allcoated flag and mark as free, and this block will be put back into the free list, by finding the right index and insert it to the free list.*/
void mm_free (void *ptr)
{
  char *newptr= ptr -4;
  * (int *) ((char *) (toNextBlock(newptr)) -4) = (((struct fb_header *) (newptr))-> size) & ~(1); 
  deFlag ((struct fb_header *) (newptr));
  putback((struct fb_header *) (newptr));
}
