/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Bob's Team",
    /* First member full name */
    "Robert F. Vitek",
    /* First member email address */
    "rfv",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};


int mm_init (void)
{
    int * ptr;

    mem_sbrk(28672);         // set initial heap size
    ptr = (int*)(dseg_lo);   
    *ptr = 28672;            // set first int of heap to size of free block

    return 0;
}

void *mm_malloc (size_t size)
{
  int *ptr, *p; 
  int newsize, oldsize, nsize;
    ptr = (int*)(dseg_lo);
    p = ptr;

    while (p < (int*)dseg_hi) {     // loop until the end of the heap
      if (!(*p & 1)) {              // skip block if already allocated
        if (size <= *p) {           // skip block if too small
          break;
	}
        else {                      // if heap is no longer big enough make
          mem_sbrk(28672);          // it bigger
          *p = *p+28672;
          break;
	}
      }
      p = p+((*p&0xFFFFFFFE)/4);    // move up to next block
    };

    nsize = size;
    while ((nsize%8) != 0) {nsize = nsize+1;};  //align block by 8 bytes

    newsize = nsize+8;     //add 8 bytes for block header information
    oldsize = *p & -2;     //get size of old free block

    *p = newsize | 1;      //set new size of allocated block

    if (newsize < oldsize)                   //if there is still room left 
      *(p+(newsize/4)) = oldsize - newsize;   // mark it as a free block
    else {
      mem_sbrk(28672);                              //if at the end increase
      *(p+newsize/4) = oldsize - newsize + 28672;   //heap size
    }

    return (p+2);   //return pointer to new allocated block
}

void mm_free (void *ptr)
{
    int * p;
    p = (int*)ptr;
    *p = *p & -2;   //change 1 to 0 - clear "allocated" flag
}

