/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "n2",
    /* First member full name */
    "Norman Chen",
    /* First member email address */
    "nkc",
    /* Second member full name (leave blank if none) */
    "Norbert Hu",
    /* Second member email address (blank if none) */
    "nhu"
};

#define GET_SIZE(x)  (*((unsigned long *)(x)) & ~0x7)
#define GET_FLAGS(x) (*((unsigned long *)(x)) & 0x7)

#define ADD_SIZE  0x4000
#define INIT_SIZE 0X2020

//#define DEBUG
//#define DEBUG_FREE

char *mmseg_lo = NULL;
char *mmseg_hi = NULL;
unsigned long mmseg_size = 0;
unsigned long mmpage_size = 0;
char *mmseg_currptr = NULL;

int mm_init (void)
{

#ifdef DEBUG
  printf("mm_init start\n");
#endif

  mmpage_size = INIT_SIZE;  // 2 * mem_pagesize();
  
  mem_sbrk(mmpage_size);

#ifdef DEBUG
  printf("  dseg_lo = %x\n", dseg_lo);
  printf("  dseg_hi = %x\n", dseg_hi);
  printf("  dseg_size = %x\n", dseg_size);
#endif

  mmseg_lo = (char *)(((((unsigned long)dseg_lo) + 3) / 4) * 4);
 
  if ((((unsigned long)mmseg_lo) & 0x3) == 0) {
    mmseg_lo = (char *)(((unsigned long)mmseg_lo) + 4);
  }

#ifdef DEBUG
  printf("  mmseg_lo = %x\n", mmseg_lo);
#endif

  mmseg_hi = (char *)((((unsigned long)dseg_hi) / 8) * 8);

  if ((((unsigned long)dseg_hi) & 0x7) < 4) {
    mmseg_hi = (char *)(((unsigned long)mmseg_hi) - 8);
  }

#ifdef DEBUG
  printf("  mmseg_hi = %x\n", mmseg_hi);
#endif

  mmseg_size = (unsigned long)mmseg_hi - (unsigned long)mmseg_lo + 4;

  *((unsigned long *)mmseg_lo) = mmseg_size;
  *((unsigned long *)mmseg_hi) = mmseg_size;

#ifdef DEBUG
  printf("  mmseg_size = %x\n", mmseg_size);
#endif

  mmseg_currptr = mmseg_lo;

#ifdef DEBUG
  printf("mm_init end\n\n");
#endif

  return 0;
}

void *mm_malloc (size_t size)
{
  int loop = 1;
  unsigned long ssize = 0;
  unsigned long tempsegsize = 0;
  unsigned long currsegsize = 0;
  unsigned long currsegflags = 0;
  char *startseg = NULL;
  char *tempseg = NULL;
  char *returnseg = NULL;

#ifdef DEBUG
  printf("mm_malloc start\n");
#endif
  
  ssize = (((size + 7) / 8) * 8);

#ifdef DEBUG
  printf("  mmseg_lo = %x\n", mmseg_lo);
  printf("  mmseg_hi = %x\n", mmseg_hi);
  printf("  size = %x\n", size);
  printf("  ssize = %x\n", ssize);
#endif

  startseg = mmseg_currptr;

  while (loop) {
    currsegsize = GET_SIZE(mmseg_currptr);
    currsegflags = GET_FLAGS(mmseg_currptr);

#ifdef DEBUG
    printf("> mmseg_currptr = %x\n", mmseg_currptr);
    printf("  currsegsize = %x\n", currsegsize);
    printf("  currsegflags = %x\n", currsegflags);
#endif

    if (currsegflags) {

#ifdef DEBUG
      printf("  allocated segment\n");
#endif

      mmseg_currptr = mmseg_currptr + currsegsize;

      if (mmseg_currptr > mmseg_hi) {
	mmseg_currptr = mmseg_lo;
      }

      if (mmseg_currptr == startseg) {
	tempsegsize = (ssize + 8) * 2;

	if (tempsegsize < ADD_SIZE) {
	  tempsegsize = ADD_SIZE;
	}

	tempseg = mem_sbrk(tempsegsize);

	if (tempseg) {

#ifdef DEBUG
	  printf("  added %x bytes to heap\n", tempsegsize);
#endif

	  tempseg = mmseg_hi + 4 - GET_SIZE(mmseg_hi);
	  if (GET_FLAGS(tempseg) == 0) {

#ifdef DEBUG
	    printf("  combining with %x bytes from seg %x\n", 
		   GET_SIZE(tempseg),
		   tempseg);
#endif
	    
	    mmseg_size = mmseg_size + tempsegsize;
	    mmseg_hi = mmseg_hi + tempsegsize;

	    tempsegsize = tempsegsize + GET_SIZE(tempseg);
	  }
	  else {
	    tempseg = mmseg_hi + 4;

	    mmseg_size = mmseg_size + tempsegsize;
	    mmseg_hi = mmseg_hi + tempsegsize;
	  }

	  mmseg_currptr = tempseg;

	  *((unsigned long *)(tempseg)) = tempsegsize;
	  tempseg = tempseg + tempsegsize;
	  *((unsigned long *)(tempseg - 4)) = tempsegsize;
	}
	else {

#ifdef DEBUG
	  printf("  failed to add %x bytes to heap\n", tempsegsize);
#endif

	  loop = 0;
	}
      }
    }
    else {

#ifdef DEBUG
      printf("  free segment\n");
#endif

      if ((ssize + 8) > currsegsize) {

#ifdef DEBUG
	printf("  too small\n");
#endif

	mmseg_currptr = mmseg_currptr + currsegsize;

	if (mmseg_currptr > mmseg_hi) {
	  mmseg_currptr = mmseg_lo;
	}

	if (mmseg_currptr == startseg) {
	  tempsegsize = (ssize + 8) * 2;

	  if (tempsegsize < ADD_SIZE) {
	    tempsegsize = ADD_SIZE;
	  }

	  tempseg = mem_sbrk(tempsegsize);

	  if (tempseg) {

#ifdef DEBUG
	    printf("  added %x bytes to heap\n", tempsegsize);
#endif

	    tempseg = mmseg_hi + 4 - GET_SIZE(mmseg_hi);

#ifdef DEBUG
	    printf("  checking previous segment at %x\n", tempseg);
#endif

	    if (GET_FLAGS(tempseg) == 0) {

#ifdef DEBUG
	      printf("  combining with %x bytes from seg %x\n", 
		     GET_SIZE(tempseg),
		     tempseg);
#endif

	      mmseg_size = mmseg_size + tempsegsize;
	      mmseg_hi = mmseg_hi + tempsegsize;

	      tempsegsize = tempsegsize + GET_SIZE(tempseg);
	    }
	    else {
	      tempseg = mmseg_hi + 4;

	      mmseg_size = mmseg_size + tempsegsize;
	      mmseg_hi = mmseg_hi + tempsegsize;
	    }
	  
	    mmseg_currptr = tempseg;

	    *((unsigned long *)(tempseg)) = tempsegsize;
	    tempseg = tempseg + tempsegsize;
	    *((unsigned long *)(tempseg - 4)) = tempsegsize;
	  }
	  else {

#ifdef DEBUG
	    printf("  failed to add %x bytes to heap\n", tempsegsize);
#endif

	    loop = 0;
	  }
	}
      }
      else {
	if ((currsegsize - ssize - 8) < 16) {

#ifdef DEBUG
	  printf("  using whole segment ");
#endif

	  returnseg = mmseg_currptr + 4;

	  *((unsigned long *)(mmseg_currptr)) = currsegsize | 0x1;

#ifdef DEBUG
	  printf("(%x - ", mmseg_currptr);
#endif

	  mmseg_currptr = mmseg_currptr + currsegsize;

#ifdef DEBUG
	  printf("%x)\n", mmseg_currptr - 1);
#endif

	  *((unsigned long *)(mmseg_currptr - 4)) = currsegsize | 0x1;

	  if (mmseg_currptr > mmseg_hi) {
	    mmseg_currptr = mmseg_lo;
	  }

	  loop = 0;
	}
	else {

#ifdef DEBUG
	  printf("  partitioning to ");
#endif

	  returnseg = mmseg_currptr + 4;

	  tempsegsize = ssize + 8;

	  *((unsigned long *)(mmseg_currptr)) = tempsegsize | 0x1;

#ifdef DEBUG
	  printf("(%x [%x] - ", mmseg_currptr, GET_SIZE(mmseg_currptr));
#endif

	  mmseg_currptr = mmseg_currptr + tempsegsize;

	  *((unsigned long *)(mmseg_currptr - 4)) = tempsegsize | 0x1;

#ifdef DEBUG
	  printf("%x [%x]) %x bytes and ", 
		 mmseg_currptr - 1, 
		 GET_SIZE(mmseg_currptr - 4),
		 tempsegsize);
#endif

	  currsegsize = currsegsize - tempsegsize;
	  
	  *((unsigned long *)(mmseg_currptr)) = currsegsize;
	  *((unsigned long *)(mmseg_currptr + currsegsize - 4)) = currsegsize;

#ifdef DEBUG
	  printf("(%x [%x] - ", mmseg_currptr, GET_SIZE(mmseg_currptr));
	  printf("%x [%x]) %x bytes\n", 
		 mmseg_currptr + currsegsize - 1,
		 GET_SIZE(mmseg_currptr + currsegsize - 4),
		 currsegsize);
#endif

	  if (mmseg_currptr > mmseg_hi) {
	    mmseg_currptr = mmseg_lo;
	  }

	  loop = 0;
	}
      }
    }
  }

#ifdef DEBUG
  printf("  returnseg %x\n", returnseg);
  printf("mm_malloc end\n\n");
#endif

  return returnseg;
}

void mm_free (void *ptr)
{
  char * lseg = NULL;
  char * rseg = NULL;
  char * ptrseg = ptr - 4;

#ifdef DEBUG_FREE
  printf("mm_free start\n");

  printf("  mmseg_lo = %x\n", mmseg_lo);
  printf("  mmseg_hi = %x\n", mmseg_hi);
  printf("  ptr = %x\n", ptr);
#endif

  lseg = ptrseg - GET_SIZE(ptrseg - 4);

#ifdef DEBUG_FREE
  printf("  testing left seg at %x (%x - %x)\n", 
	 lseg,
	 ptrseg,
	 GET_SIZE(ptrseg - 4));
#endif

  if ((lseg < mmseg_lo) || (GET_FLAGS(lseg) != 0)) {
    lseg = ptrseg;

#ifdef DEBUG_FREE
    printf("  moving left seg back to %x\n", lseg);
#endif
  }

  rseg = ptrseg + GET_SIZE(ptrseg);

#ifdef DEBUG_FREE
  printf("  testing right seg at %x\n", rseg);
#endif

  if ((rseg < mmseg_hi) && (GET_FLAGS(rseg) == 0)) {

    rseg = rseg + GET_SIZE(rseg);

#ifdef DEBUG_FREE
    printf("  extending right seg to %x\n", rseg);
#endif
  }

  *((unsigned long *)lseg) = rseg - lseg;
  *((unsigned long *)(rseg - 4)) = rseg - lseg;

#ifdef DEBUG_FREE
  printf("  creating new free seg (%x - %x) with %x bytes\n", 
	 lseg, 
	 rseg - 1, 
	 rseg - lseg);

  printf("mm_free end\n\n");

  printf("waiting for user...");
  getchar();
#endif

  mmseg_currptr = lseg;
}

