/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Old Hag",
    /* First member full name */
    "Rhys L Wong",
    /* First member email address */
    "rlw",
    /* Second member full name (leave blank if none) */
    "Ming Fai Wong",
    /* Second member email address (blank if none) */
    "mingfai"
};


/*********** define structs needed to hold control data for allocator ****************/

/*	+----------------------+
	| prevsize     | inuse |
	+--------------+-------+
	| size         | inuse |
	+--------------+-------+
	|//////////////////////|
	|///USER DATA//////////|
	+----------------------+--
	| prevsize     | inuse |
	+--------------+-------+
	| size         | inuse |
	+--------------+-------+
	|     prev pointer     |
	+----------------------+
	|     next pointer     |
	+----------------------+

       +----------------------------------+
(prev) v                                  v
      BIN <-> [..] <-> [..] <-> [..] <-> [..]
		(next)
	
		smallest						largest

		insert into bin from the back, but take chunks from the front
		so that we have an LRU system.
*/

struct memchunk;
typedef struct memchunk *memchunkptr;

struct ptrpair {
	memchunkptr prev;
	memchunkptr next;
};	

struct memchunk {

	int prevsize;		/* size of previous chunk */
	int size;		/* size of this chunk */
	memchunkptr prev;
	memchunkptr next;	 /* pointers to previous and next chunks in free list */
};

struct globalInfo {
	memchunkptr top;		/* pointer to topmost chunk */
	/*unsigned int binblock;*/	/* int indicating which groups of bins has free chunks */
	struct ptrpair bin[128];	/* the bins */
	int counter;
};
typedef struct globalInfo *globalsptr;


/* routine which given the request size, returns which bin it belongs to */

#define bin_num(sz) (                           \
	((sz>>9) ==    0) ?       (sz>> 3) :    \
	((sz>>9) <=    4) ?  56 + (sz>> 6) :    \
	((sz>>9) <=   20) ?  91 + (sz>> 9) :    \
	((sz>>9) <=   84) ? 110 + (sz>>12) :    \
	((sz>>9) <=  340) ? 119 + (sz>>15) :    \
	((sz>>9) <= 1364) ? 124 + (sz>>18) : 126	)



int mm_init (void)
{

	globalsptr globals;
	memchunkptr top;
	int controlsize;	/* amt. space taken up by control data */
	int i;

	if (!mem_sbrk( mem_pagesize() )) return -1;	/* declare one page to hold data */

	controlsize = (sizeof(*globals) + 7) & (~7);

	globals = (globalsptr)dseg_lo;	/* declare the global control data struct */
	globals->top = (memchunkptr)(dseg_lo + controlsize);	
	/*globals->binblock = 0;*/
	for ( i = 0; i < 128; ++i ) {
		globals->bin[i].prev = (memchunkptr)(((char *)&(globals->bin[i])) - 8);
		globals->bin[i].next = (memchunkptr)(((char *)&(globals->bin[i])) - 8);
	}
	/* the bins can now be referenced like memchunks -- pointers start from 3rd word within
	structure */

	top = globals->top;					/* initialize the top chunk */
	top->prevsize = 1;					/* always set previous block used */
	top->size = mem_pagesize() - sizeof(*globals);		/* set top chunk to remaining slack */

	globals->counter = 0;

	return 0;
}

/* mask out the inuse bit to return the size fields of a chunk (including overhead) */
#define chunksize(chunkptr) ((chunkptr->size)&(~1))
#define prevchunksize(chunkptr) ((chunkptr->prevsize)&(~1))

/* return pointers to next and previous chunks in memory */
#define nextchunk(chunkptr) ((memchunkptr)(((char *)chunkptr)+chunksize(chunkptr)))
#define prevchunk(chunkptr) ((memchunkptr)(((char *)chunkptr)-prevchunksize(chunkptr)))

/* given a chunk, return a pointer to start of malloc pointer (ie, skip past the overhead) */
#define usrmemptr(chunkptr) (((void *)chunkptr) + 8)


void printchunk (memchunkptr curr_chunk) {
	printf ("[chunk addr=%d prevsize=%d size=%d prevptr=%d nextptr=%d]\n", curr_chunk, curr_chunk->prevsize, curr_chunk->size, curr_chunk->prev, curr_chunk->next);
}

void printbin (memchunkptr binptr) {

	memchunkptr curr_chunk;

	for ( curr_chunk = binptr->next; curr_chunk != binptr;
			curr_chunk = curr_chunk->next ) {
		printf ("\t : ");
		printchunk(curr_chunk);
	}
	printf("--end of binlist--\n");
}



/* remove a chunk from the free list */
void chunk_unlink(memchunkptr chunkptr)
{
	memchunkptr prevnode = chunkptr->prev;
	memchunkptr nextnode = chunkptr->next;

	assert( ((chunkptr->size) & 1) == 0 );
	assert( (((nextchunk(chunkptr))->prevsize) & 1) == 0 );

	prevnode->next = chunkptr->next;
	nextnode->prev = chunkptr->prev;
}

/* add a chunk to the free list */
void chunk_link(memchunkptr binptr,memchunkptr ptr,int prevsize,int size)
{
	/* we add from the back of the free list */
	memchunkptr curr_chunk;	

	for (curr_chunk = binptr->prev;	
			curr_chunk != binptr && chunksize(curr_chunk) > size;
			curr_chunk = curr_chunk->prev ) { }
																	\
	ptr->next = curr_chunk->next;
	ptr->prev = curr_chunk;	
	curr_chunk->next = ptr;
	ptr->next->prev = ptr;

	ptr->prevsize = (prevsize|1);	/*our predecessor will ALWAYS be allocated */
	ptr->size = (size & (~1));

	/* set next chunk's prevsize to reflect NOT in use!!!!! */
	(nextchunk(ptr))->prevsize = (size & (~1));
}															

void *mm_malloc (size_t size)
{
	globalsptr globals;
	int curr_bin;
	memchunkptr curr_chunk;
	memchunkptr head;
	memchunkptr splitbin;
	int slack;
	int temp;

	if (!size) return dseg_lo;	/* do nothing when allocating size=0 */
	size += 8;			/* expand the request size to account for 8-byte header */
	size = (size + 7) & (~7);	/* pad up to multiple of 8 bytes */
	
	curr_bin = bin_num( size );

	globals = (globalsptr)dseg_lo;

	for ( curr_bin = bin_num( size ); curr_bin < 128; curr_bin++ ) {

		head = (memchunkptr)(((char *)&(globals->bin[curr_bin])) - 8); /* pointer to the bin */
		for ( curr_chunk = head->next; curr_chunk != head; curr_chunk = curr_chunk->next ) {

			slack = curr_chunk->size - size;
			if ( slack >= 16 ) { 
				/* must split */
				chunk_unlink(curr_chunk);
				curr_chunk->size = (size | 1);
				temp = bin_num(slack);
				splitbin = (memchunkptr)(((char *)&(globals->bin[temp])) - 8); /* pointer to the bin */
				chunk_link(splitbin,(memchunkptr)(((char *)curr_chunk) + size),size,slack);

				return usrmemptr(curr_chunk);
				
			} else if ( slack >= 0 ) {
				/* allocate, no need to split */
				chunk_unlink(curr_chunk);
				curr_chunk->size |= 1;
				(nextchunk(curr_chunk))->prevsize |= 1;

				return usrmemptr(curr_chunk);
			}
			/* chunk is too small, continue searching */
		}
	}
	/* no free chunk fits - grab from top */
	curr_chunk = globals->top;
	slack = curr_chunk->size - size;

	if ( slack <= 0 ) {
		/* must expand heap area */
		temp = ((-slack) + 4095) & (~4095);
		if (!temp) temp = 4096;
		
		if (!mem_sbrk( temp )) return 0;	/* fail if cannot satisfy request */

		slack += temp;
	}

	curr_chunk->size = (size | 1);
	globals->top = (memchunkptr)(((char *)curr_chunk) + size);
	globals->top->prevsize = (size | 1);
	globals->top->size = slack;

	return usrmemptr(curr_chunk);
}

void mm_free (void *ptr)
{
	globalsptr globals = (globalsptr)dseg_lo;
	memchunkptr curr_chunk = (memchunkptr)(ptr - 8);
	memchunkptr startpos;
	memchunkptr binptr;
	int newchunksize;

	if (ptr == 0) return;	/* do nothing on free(NULL) */

	startpos = curr_chunk;
	newchunksize = chunksize(curr_chunk);

	if ( ((curr_chunk->prevsize) & 1) == 0 ) {	/* if previous block free... */
		newchunksize += prevchunksize(curr_chunk);
		startpos = prevchunk(curr_chunk);	/* unlink previous block */
		chunk_unlink(startpos);
	}

	if (nextchunk(curr_chunk) == globals->top) {
		/* update chunksize and consolidate with top and return */
		curr_chunk->size += globals->top->size;
		curr_chunk->size &= (~1);
		globals->top = curr_chunk;
		return;
	}

	if ( ((nextchunk(curr_chunk)->size) & 1) == 0 ) { /* next block is free */
		chunk_unlink(nextchunk(curr_chunk));			/* unlink next block */
		newchunksize += chunksize(nextchunk(curr_chunk));	/* update chunksize */
	}

	/* link block with startpos and chunksize */
	binptr = (memchunkptr)(((char *)&(globals->bin[bin_num(newchunksize)])) - 8); /* pointer to the bin */
	chunk_link(binptr,startpos,startpos->prevsize,newchunksize);
}

