/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Insomnia",
    /* First member full name */
    "Matthew Ghio",
    /* First member email address */
    "mg5n+@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

#define end_heap (*((char **)(dseg_lo)))
#define free_list (*((char **)(dseg_lo+4)))
#define alloc_list (*((char **)(dseg_lo+8)))
#define last_alloc_struct (*((char **)(dseg_lo+12)))

int mm_init (void)
{
    int pagesize=mem_pagesize();
    
    mem_sbrk(pagesize);
    /*printf("%x %x %x\n",dseg_lo,dseg_lo+1,dseg_hi);*/
    
    end_heap=dseg_lo+16;
    free_list=0;
    alloc_list=0;
    last_alloc_struct=0;
    
    return 0;
}

void *mm_malloc (size_t size)
{
    int aligned_size=(size+7)&(~7);
    int pagesize=mem_pagesize();
    char *new_alloc;
    int *ptr;
    
    if (!aligned_size) return NULL;
    if(free_list!=NULL)
    {
        ptr=(int *)free_list;
        while(ptr!=NULL)
        {
          if(ptr[2]>=aligned_size+16)
          {
            /* Remove from free list */
            if((void *)ptr==(void *)free_list)
            {
              free_list=ptr[1];
            }
            else
            {
              ((int *)(ptr[0]))[1]=ptr[1];
              if(ptr[1]) ((int *)(ptr[1]))[0]=ptr[0];
            }

            if(last_alloc_struct) {
              *((int *)(last_alloc_struct+8))=ptr;
            }else{
              if(alloc_list==NULL) alloc_list=ptr;
            }
            /*printf("alloc_freed:%x %x\n",last_alloc_struct,ptr);*/
            last_alloc_struct=ptr;
            ((int *)(last_alloc_struct))[0]=((int)ptr)+16;
            ((int *)(last_alloc_struct))[1]=aligned_size;
            ((int *)(last_alloc_struct))[2]=NULL;
            ((int *)(last_alloc_struct))[3]=NULL;
            return(((void *)ptr)+16);
          }
          ptr=ptr[1];
        }
    }
    
    if(end_heap+aligned_size+16>=dseg_hi)
      if(mem_sbrk((pagesize+size+16)&(~(pagesize-1)))==NULL){/*printf("out of memory\n");print_debug_info();*/return NULL;}
    new_alloc=end_heap;
    end_heap+=aligned_size+16;
    /*printf("alloc:%x\n",new_alloc);*/
    if(last_alloc_struct) {
      *((int *)(last_alloc_struct+8))=new_alloc;
    }else{
      if(alloc_list==NULL) alloc_list=new_alloc;
    }
    /*printf("alloc:%x %x\n",last_alloc_struct,new_alloc);*/
    last_alloc_struct=new_alloc;
    ((int *)(last_alloc_struct))[0]=new_alloc+16;
    ((int *)(last_alloc_struct))[1]=aligned_size;
    ((int *)(last_alloc_struct))[2]=NULL;
    ((int *)(last_alloc_struct))[3]=NULL;
    
    return(new_alloc+16);

    /* The alloc_list is a linked list with structures as follows:
       byte 0-3:address
       byte 4-7:size
       byte 8-11:ptr to next in list
    */
}

void mm_free (void *ptr)
{
    int *current_node=(int *)alloc_list;
    int *previous_node=NULL;
    int *freelist_node=(int *)free_list;
    int len;
    
    while(current_node!=NULL)
    {
        if(*current_node==(int)ptr)
        {
            /*printf("free: found %x at %x\n",ptr,current_node);*/
            /*print_debug_info();fflush(stdout);*/
            /* Remove block from allocated list */
            if(previous_node!=NULL)
            {
              previous_node[2]=current_node[2];
            }
            else
            {
              alloc_list=(char *)(current_node[2]);
            }
            /* If this is the very last block, shorten the alloc list */
            if((void *)current_node==(void *)last_alloc_struct)
              (void *)last_alloc_struct=(void *)previous_node;

            len=current_node[1]+16;
            
            /* If this block is at the end of the heap,
               don't put it on the free list, instead shrink the heap */
            if(len+(char *)current_node==end_heap)
            {
              end_heap=(char *)current_node;
              return;
            }

            if(free_list==NULL)
            {
              /* First entry to empty list */
              free_list=(char *)current_node;
              ((int **)current_node)[0]=NULL;
              ((int **)current_node)[1]=NULL;
              ((int *)current_node)[2]=len;
              return;
            }
            while(freelist_node[2]<len)
            {
              if(freelist_node[1]==0)
              {
                /* Add to end of free list */
                freelist_node[1]=current_node;
                ((int **)current_node)[0]=freelist_node;
                ((int **)current_node)[1]=NULL;
                ((int *)current_node)[2]=len;
                return;
              }
              freelist_node=freelist_node[1];
            }
            if(freelist_node==free_list)
            {
              /* Add to beginning of free list */
              ((int **)current_node)[0]=NULL;
              ((int **)current_node)[1]=free_list;
              ((int *)current_node)[2]=len;
              freelist_node[0]=current_node;
              free_list=current_node;
            }
            else
            {
              /*print_debug_info();fflush(stdout);*/
              
              /* Insert into free list */
              ((int **)current_node)[0]=freelist_node[0];
              ((int *)(freelist_node[0]))[1]=current_node;
              ((int **)current_node)[1]=freelist_node;
              freelist_node[0]=current_node;
              ((int *)current_node)[2]=len;
              /*print_debug_info();fflush(stdout);*/
            }
            return;            
        }
        else
        {
            previous_node=current_node;
            current_node=current_node[2];
        }
    }
    /*printf("Eek! Tried to free unallocated block!\n");*/
}


/*
void print_debug_info (void)
{
  int *ptr;
  
  ptr=alloc_list;
  while(ptr!=NULL)
  {
    printf ("%x %x: %x %x\n",ptr,ptr[0],ptr[1],ptr[2]);
    ptr=ptr[2];
  }
  ptr=free_list;
  while(ptr!=NULL)
  {
    printf ("freelist:%x %x %x %x\n",ptr,ptr[0],ptr[1],ptr[2]);
    ptr=ptr[1];
  }
}
*/
