/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Jesiatha",
    /* First member full name */
    "Eric Heutchy",
    /* First member email address */
    "eheutchy",
    /* Second member full name (leave blank if none) */
    "Ethan Tira-Thompson",
    /* Second member email address (blank if none) */
    "ejt"
};

#define BUCKETS ((unsigned int *)dseg_lo)
#define BUCKSIZE (32 * 4)

inline int ToBucket(int n)
{
	int count = 0;
	while (n) { count++; n >>= 1; }
	if (count < 4) count = 4;
	return count;
}

int mm_init (void)
{
	unsigned int i;
	if ((int)dseg_hi - (int)dseg_lo < BUCKSIZE)
	{
		mem_sbrk(BUCKSIZE + (int)dseg_lo - (int)dseg_hi);
	}

	for (i = 0; i < 32; i++) BUCKETS[i] = 0;

    return 0;
}

void *mm_malloc (size_t size)
{
	char *temp;
	int bucket = ToBucket(size);
	if (0 == BUCKETS[bucket])
	{ // make a bucket
		size = (1 << bucket) + 8;
		temp = dseg_hi;
		if (NULL == mem_sbrk(size)) return NULL;
		*((unsigned int *)temp) = bucket;
		return temp + 8;
	} // make a bucket
	else
	{ // have a bucket
		temp = (char *)BUCKETS[bucket];
		BUCKETS[bucket] = *((unsigned int*)temp);
		return temp;
	} // have a bucket

}

void mm_free (void *ptr)
{
	int bucket;
	unsigned int prior;
	bucket = *((int *)(ptr) - 2);
	prior = BUCKETS[bucket];
	*((unsigned int*)ptr) = prior;
	BUCKETS[bucket] = (unsigned int)ptr;
}

