/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
   This implementation is a doubly linked list of free blocks
   the first 4 bytes of the heap is a pointer to the first free block
   the head of each block has one bit for allocation flag
                              31 bits for size
			      4 bytes for prev free block pointer (not used if allocated)
			      4 bytes or next free block pointer  ( " )
   the tail pointer has four bytes or the size
              
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

typedef struct {   /*head structure.. for easier code readability*/
  int size;
  int *prev;
  int *next;
}FHead;

team_t team = {
    /* Team name to be displayed on webpage */
    "pewp eat0rs",
    /* First member full name */
    "Christon DeWan",
    /* First member email address */
    "cdewan@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Dirk Morris",
    /* Second member email address (blank if none) */
    "dmorris@andrew.cmu.edu"
};


void printblock(FHead *head) /*prints a block*/
{
  int size = head->size;
  printf("***\nBlock starting at address %i\n",(int)head);
  if (size < 0){
    size = size ^(1<<31);
    printf("Size of taken block is %i\n",size); 
  } else {
    printf("Size of free block is %i\n",size);
  }
  if (head->size == *((int *)((int)head + size - 4))) printf ("Boundary tags match.\n****\n");
  else printf ("Boundary tags do *NOT* match.\n****\n");
}

void blockwrite(int *start, int size)                /*sets the allocation flag*/
{*start = *(start + size/4 -1) = size | (1<<31);}  

void freeblockwrite(int *start, int size) /*frees a block and adds it to the free list*/
{
  
  int *base = (int *)dseg_lo;
  FHead *next,*head = (FHead *)start;
  if (size == 0) return;

  *start = *(start + size/4 -1) = size;
  head->next = (int *)(*base);
  head->prev = (int *)0;

  if(*base){
    next = (FHead *)(*base);
    next->prev = start;
  }


  *((int **)base) = start;

}

void removefree(FHead *thisblock) /*removes a free block from the list*/
{
  int *listhead = (int *)dseg_lo;
  FHead *prevblock,*nextblock;
  
  prevblock = (FHead *)(thisblock->prev);
  nextblock = (FHead *)(thisblock->next);
  

  if (prevblock) prevblock->next = (int *)nextblock;
  else *((int **)listhead) = (int *)nextblock;

  if (nextblock) nextblock->prev = (int *)prevblock;

}

void codown(FHead *head) /*coalesce down (previous) */
{ 
  int downsize,fullsize,size,*start = (int *)head;  
  downsize = *(start-1);  
  size = *start;  
  fullsize = size + downsize;
  
  if (downsize < 0) return; /* allocate*/
  if ((int)start <= (int)(dseg_lo) + 4) return;

  /*removefree((FHead *)(start-downsize/4));*/
  removefree((FHead *)start);
  /*freeblockwrite(start-downsize/4, fullsize);*/
  *(start-downsize/4)=*(start+size/4-1)=fullsize;
}

void coup(FHead *head) /*coalesce up (next) */
{

  int *start = (int *)head;
  int size = * start;
  int nextblocksize;
  FHead * next = (FHead *)(start + size/4);
  if (next->size < 0) return; /* allocated */
  if (next >= (FHead *)dseg_hi) return;
  nextblocksize = next->size;
  removefree((FHead *)next);

  /*  removefree((FHead *)start); */
  /*freeblockwrite(start ,size + nextblocksize);*/
  *start=*(start+size/4+nextblocksize/4-1)=size + nextblocksize;  
}

int mm_init (void) /*inits the heap*/
{
  int HEAP_HEAD = 4;
  int startsize;
  int *result;

  startsize = mem_pagesize();
  result = mem_sbrk(startsize-12);

  *(result) = 0;  
  freeblockwrite(result+1,startsize-HEAP_HEAD-12);
  return -(!result);
}

int newPage(int size) /*adds new page to heap or appropraite size and adds it to the free list*/
{
  int newblocksize;
  int *result;
  /*  printf("*NewPage* \n"); */
  newblocksize = mem_pagesize();
  newblocksize = (size + newblocksize -1)/newblocksize*newblocksize;
  result = mem_sbrk(newblocksize);
  
  if (!result) return 0;
  freeblockwrite(result,newblocksize); /*add one to keep 8bit aligned*/
  codown((FHead *)result);
  return 1;
}



void *mm_malloc (size_t size)
{ 
  FHead *thisblock;
  int * listhead;  
  int originalsize;
  size = ((size + 23)/16)*16;
 
  listhead = (int *)dseg_lo;
  thisblock = (FHead *)(*listhead);
    
  if (!thisblock){
    newPage(size);
    thisblock = (FHead *)(*listhead);
  }
  else while(thisblock->size < size) 
       {   
        if (thisblock->next == 0 ) {
	 if (!newPage(size)){ 
	  /*  couldnt allocate more space */
	  return NULL;
	  }
	 thisblock = (FHead *)(*listhead); }
        else {thisblock = (FHead*)(thisblock->next);}
       }


  originalsize = thisblock->size;

  removefree(thisblock);
  blockwrite((int *)thisblock,size);
  freeblockwrite((int *)((int)thisblock + size),originalsize-size);
  return ((void *)((int)thisblock + 4)); 
}

void mm_free (void *ptr)
{
  int size = *((int *)ptr - 1) ^ (1<<31);
  /*    printf("****Freeing block of size:%i\n",size); */

  freeblockwrite((int *)ptr-1,size);
  coup((FHead *)((int)ptr-4));
  codown((FHead *)((int)ptr-4));
  
}

