/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "The KGB",
    /* First member full name */
    "Daniel Froman",
    /* First member email address */
    "dfroman",
    /* Second member full name (leave blank if none) */
    "Margaret Delap",
    /* Second member email address (blank if none) */
    "mid"
};



#define size_align(sz)  ((((sz) & (0x7)) == 0) ? (sz) : (((sz) + 8) & ~(0x7)))
#define in_heap(x)  (((char *)(x) >= dseg_lo) && ((char *)(x) < dseg_hi))
#define smallbin_index(amt)  (((unsigned long)(amt)) >> 3)

#define bin_index(sz)                                                         \
(((((unsigned long)(sz)) >> 9) ==    0) ?       (((unsigned long)(sz)) >>  3):\
 ((((unsigned long)(sz)) >> 9) <=    4) ?  56 + (((unsigned long)(sz)) >>  6):\
 ((((unsigned long)(sz)) >> 9) <=   20) ?  91 + (((unsigned long)(sz)) >>  9):\
 ((((unsigned long)(sz)) >> 9) <=   84) ? 110 + (((unsigned long)(sz)) >> 12):\
 ((((unsigned long)(sz)) >> 9) <=  340) ? 119 + (((unsigned long)(sz)) >> 15):\
 ((((unsigned long)(sz)) >> 9) <= 1364) ? 124 + (((unsigned long)(sz)) >> 18):\
                                          126)
     /* 127 should be top */


typedef struct malloc_chunk {
  size_t size_prev;
  size_t size;
  struct malloc_chunk *fd;
  struct malloc_chunk *bk;
} chunk;

#define NUM_BINS 128
#define MINSIZE 16

typedef struct arena {
  chunk bin[NUM_BINS];
} arena;

#define chunksize(p)  ((p)->size & ~(0x1))
#define next_chunk(p) ((char *)(p) + chunksize(p))
#define prev_chunk(p) ((char *)(p) - chunksize(p))
#define is_allocated(p)  ((p)->size & 0x1)

#define allocate(p)  ((p)->size |= 0x1)
#define deallocate(p) ((p)->size &= ~(0x1))

#define main_arena ((arena *)dseg_lo)

#define top main_arena->bin[127].fd  /* XXX remove */


/* debugged <8:00 */
static void remove_from_free_list(chunk *bin, chunk *victim)
{
  chunk *prev = victim->bk, *next = victim->fd;

#ifdef DEBUG
  printf("remove(%p, %p)\n", bin, victim);
#endif
  if (bin->fd == bin) {} /* empty list */
  else if (victim == prev) /* single list */ {
    bin->bk = bin;
    bin->fd = bin;
  } else { 
    if (bin->fd == victim) { /* non-empty list w/ victim at bin->fd */
      bin->bk = next;
      bin->fd = next;
    }
    next->bk = prev;
    prev->fd = next;
  }
}

/* debugged 8:00 */
static void add_to_free_list(chunk *bin, chunk *p)
{
  chunk *there;   /* what's already on list, if anything */

#ifdef DEBUG
  printf("add(%p, %p)\n", bin, p);
#endif
  if (bin == &(main_arena->bin[NUM_BINS-1])) {    /* overwrite top */
    printf("does this ever happen? apparently not\n");
    remove_from_free_list(bin, bin->fd);
  }
  if (bin->fd == bin) { /* should be true for top */
    bin->fd = p;
    bin->bk = p;
    p->fd = p;
    p->bk = p;
  } else if (bin->bk == bin) 
    printf("Weird.\n");
  else { /* at least one chunk already there */
    there = bin->fd;
    p->fd = there;
    p->bk = there->bk;
    there->bk->fd = p;
    there->bk = p;
  }   
}


static int split_chunk(chunk *victim, size_t size, int is_from_top)
{
  size_t victim_size = chunksize(victim);
  chunk *rem;
  size_t rem_size;
  int index;
  /*
  printf("victim:%p\n", victim);
  printf("victim->fd:%p\n", victim->fd);
  printf("victim->bk:%p\n", victim->bk);
  printf("victim->size:%p\n", victim->size);
  */
#ifdef DEBUG
  printf("split(%p, %d, %d)\n", victim, size, is_from_top);
#endif
  if (size > victim_size)
    return -1;  /* cannot get a block of size size */
  else {
    /* if (size < victim_size - MINSIZE) { */
    /* chunk *new_block; */
    /* victim->size = size | is_allocated(victim); */
    rem = (chunk *)((char *)victim + size);
    rem->size_prev = size;
    rem_size = victim_size - size;
    /* printf("rem_size=%d\n", rem_size); */
    rem->size = rem_size; /* free, so don't set bit */
    if (is_from_top) {
      main_arena->bin[NUM_BINS-1].fd = rem;
      main_arena->bin[NUM_BINS-1].bk = rem;
    } else {
      if (rem_size != 0) {
	if (rem_size < 512)
	  index = smallbin_index(rem_size);
	else 
	  index = bin_index(rem_size);
	/* printf("adding %p to free list from split\n", rem); */
	add_to_free_list(&(main_arena->bin[index]), rem);
      }
    }
    if (size < 512)
      index = smallbin_index(size);
    else
      index = bin_index(size);
    return index;
  }
}

int mm_init (void)
{
  int i;
  size_t top_address;

#ifdef DEBUG
  printf("init()\n");
#endif
  if (!mem_sbrk(mem_pagesize()))
    exit(-1);
  /* if (!mem_sbrk(20*1024*1024)) {
    printf("mem_sbrk failed\n");
    exit(-1); 
  } */
  for (i = 0; i < NUM_BINS-1; i++) {
    main_arena->bin[i].fd = &(main_arena->bin[i]);
    main_arena->bin[i].bk = main_arena->bin[i].fd;
  }
  top_address = size_align((int)dseg_lo + sizeof(arena));
  main_arena->bin[NUM_BINS-1].fd = (chunk*)(top_address);
  main_arena->bin[NUM_BINS-1].bk = main_arena->bin[NUM_BINS-1].fd;
  main_arena->bin[NUM_BINS-1].fd->fd = main_arena->bin[NUM_BINS-1].fd;
  main_arena->bin[NUM_BINS-1].fd->bk = main_arena->bin[NUM_BINS-1].bk;  
  (main_arena->bin[NUM_BINS-1].fd)->size = ((int)dseg_hi - top_address + 1);
  /* printf("size of top%d\n", main_arena->bin[NUM_BINS-1].fd->size); */
  (main_arena->bin[NUM_BINS-1].fd)->size_prev = 0;  /* XXX change */
  return 0;
}

static int more_top (size_t diff) {
  unsigned long pagesize = mem_pagesize();
  chunk *old_top = main_arena->bin[NUM_BINS-1].fd;
  size_t old_top_size = chunksize(old_top);
  size_t new_top_size;
  char* old_dseg_hi = dseg_hi;
  char* brk_ret;
  size_t mod = diff%pagesize;

  /* printf("%p\n", main_arena->bin[NUM_BINS-1].fd); */
#ifdef DEBUG
  printf("more_top(%d)\n", diff);
#endif
  diff = (mod == 0 ? diff : diff + pagesize - mod);
  brk_ret = (char*)(mem_sbrk(diff));
  if (!brk) return -1; /* and pass down error in malloc */
  /* main_arena->bin[NUM_BINS-1].fd = (chunk *)brk_ret; */
  new_top_size = dseg_hi - old_dseg_hi + old_top_size;
  old_top->size = new_top_size;

  return 0;
}

/* if small:
     return fd on free list
     if no chunks yet
       if last bin too small
         if poss. to extend
           extend
	 else exit
       split from last bin & return  -- Last bin like top, or free list?
   else try correctly sized bin until
     find a bin >= size: split and return
     else there aren't any: 
       if last bin too small  -- Or try next bin(s)
         if poss. to extend
           extend
	 else exit
       split from last bin & return
*/

/* #define MAL_DEBUG 1 */

/* assumptions:
   -last bin is like top
   -split_chunk puts remainders on appropriate free list
   */
void *mm_malloc (size_t size) {
  int index;
  chunk *victim;
  void *ptr;
  if (size <= 0) return 0;
  size = size_align(size) + 8;

  /* case small bin */
  if (size < 504) {
    index = smallbin_index(size);
    victim = main_arena->bin[index].fd;
    if ((void *)victim != (void *)&main_arena->bin[index]) {
      remove_from_free_list(&(main_arena->bin[index]), victim);
      victim->size = size;
      allocate(victim);
      ptr = (void *)((char *)victim + 8); 
      return ptr;
    } else {
      /* take from the last bin */
      index = NUM_BINS-1;
      victim = main_arena->bin[NUM_BINS-1].fd;
      if (chunksize(victim) < size) {
	if (more_top(size - chunksize(victim)) == -1) /* more_top fails, die.*/
	  exit(1);
      }
      index = split_chunk(victim, size, 1); /* assuming that works */
      /* done */  /* taken from top, therefore not in free list */
      /* remove_from_free_list(&(main_arena->bin[index]), victim); */
      victim->size = size;
      allocate(victim);
      ptr = (void *)((char *)victim + 8);
      return ptr;
    }
  } else {
    /* may have to break a bin */
    index = bin_index(size);
    victim = main_arena->bin[index].fd;
    do {
      /* printf("v=%p,chunksize(v)=%d, bin=%d\n",victim, chunksize(victim), index); */
      if (chunksize(victim) > 20*1024*1024) {
	/* try to recover from messed up chunk (i.e., ignore it) */
      }
      else if (size <= chunksize(victim)) { 
	index = split_chunk(victim, size, 0); /* assuming that works */
	/* done */
	remove_from_free_list(&(main_arena->bin[index]), victim);
	victim->size = size;
	allocate(victim);
	ptr = (void *)((char *)victim + 8);
	/* printf("malloc:3 returns %p\n", ptr); */
	return ptr;
      }
      victim = victim->fd; 
    } while (victim != main_arena->bin[index].fd);
    index = NUM_BINS-1;
    victim = main_arena->bin[NUM_BINS-1].fd;
    if (chunksize(victim) < size) {
      if (more_top(size - chunksize(victim)) == -1) /* more_top fails, die.*/
	exit(1);
    }
    index = split_chunk(victim, size, 1); /* assuming that works */
    /* done */
    victim->size = size;
    allocate(victim);
    ptr = (void *)((char *)victim + 8);
    return ptr;
  }
}

static void coalesce(chunk *bin, chunk *p){
  chunk *next = (chunk*)(next_chunk(p));
  size_t next_size = chunksize(next);
  chunk *prev = (chunk*)(prev_chunk(p));
  size_t prev_size;  /* don't care unless prev is not used */
  size_t sz_temp = chunksize(p);
  chunk *after_next;

#ifdef DEBUG
  printf("coalesce(%p, %p)\n", bin, p);
#endif
  if (p != main_arena->bin[NUM_BINS].fd) {
    if (next == main_arena->bin[NUM_BINS].fd) {
      sz_temp += next_size;
      if (!is_allocated(prev)) {
	prev_size = chunksize(prev);
	sz_temp += prev_size;
	remove_from_free_list(bin, p); /* p not on that free list any more */
	p = prev;
      }
      p->size = (sz_temp | 0x1); /* Assume chunk before prev is in use */
      main_arena->bin[NUM_BINS].fd = p;
      main_arena->bin[NUM_BINS].bk = p;      /* XXX check */
      return;   /* done. */
    /* else next is not top */
    } else {
      if (!is_allocated(prev)) {
	prev_size = chunksize(prev);
	sz_temp += prev_size;
	remove_from_free_list(bin,p);
	p = prev;  /* Will have to set new free list */
      }
      after_next = (chunk*)(next_chunk(next));
      if (!is_allocated(next)) {
	sz_temp += next_size; /* we already assigned sz_temp */
	remove_from_free_list(bin,p);
	next = (chunk*)((char*)(p) + sz_temp);
      }
      p->size = sz_temp & ~0x1;
      next->size_prev = sz_temp | 0x1;
      printf("adding %p to free list from coalesce\n", p);
      if (sz_temp < 512)
	add_to_free_list(&(main_arena->bin[smallbin_index(sz_temp)]), p);
      else add_to_free_list(&(main_arena->bin[bin_index(sz_temp)]), p);      
    }
  } else /* congratulations, got top. */ 
    /* now you die. should never free top.*/
   { printf("tried to coalesce top, shouldn't happen\n");
     exit(1);
   }
}
    

void mm_free (void *ptr) {
  chunk *victim = (chunk *)((char *)ptr - 8);
  size_t size = chunksize(victim);
  int bin_i = (size < 504) ? smallbin_index(size) : bin_index(size);

#ifdef DEBUG
  printf("free(%p)\n", ptr);
#endif
  if (!is_allocated(victim)) {/* printf("sabotage!\n");*/ return;}
  deallocate(victim);
  add_to_free_list(&(main_arena->bin[bin_i]), victim);
  /* coalesce(&(main_arena->bin[bin_i]), victim); */
}


/* 0x40768998 - 0x4076b686
   0x4076b448 - 0x4076d3a1 */







