/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define HEADERSIZE 13

#define VALUESTART 1


int is_free( int * );
int max( int, int );
int getSize( int *);
void setSize( int *, int );
int firstSlot( int, int );
void allocate( int * );
void unallocate( int * );
void tryPutFree( int *, int );
int  canPut( int *, int );
int  canNeverPut( int *, int );
int basicFree( int *);
void updatePointers();
int  getHeaderPos( int );
int mm_double( int );

team_t team = {
    /* Team name to be displayed on webpage */
    "Fight Club",
    /* First member full name */
    "Christopher N Raubacher",
    /* First member email address */
    "cnr@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Stephen P Opalenski",
    /* Second member email address (blank if none) */
    "stepheno@andrew.cmu.edu"
};

/* checks if a block is free.  returns a 1 if it is. */
inline int is_free( int *pos )
{
  return ((*pos)&(1 << 31)) == 0;
}

/* initilizes memory for mm_malloc*/
int mm_init (void)
{
  int size;
  int *start;
  int counter;

  size = mem_pagesize();

  if ( (dseg_hi - dseg_lo) < size )
    {
      if ( mem_sbrk( size ) == NULL )
	return -1;
    }
  else
    size = (dseg_hi - dseg_lo);

  size = size/4;

  start = (int *)dseg_lo;

  *start = HEADERSIZE;

  for ( counter = 1; counter < HEADERSIZE; counter++ )
    *(start + counter) = HEADERSIZE;

  *(start + *start) = size - HEADERSIZE;

  return 0;
}

/* adjusts pointers to point to new blocks */
void updatePointers()
{
  int pos;
  int mult = 4;
  int *start = (int *)dseg_lo;
  int i = VALUESTART;

  for ( i = VALUESTART; i < HEADERSIZE; i++ )
    {
      mult = mult*2;

      pos = *(start + i);

      while ( (pos < *start)&&( (!is_free( start + pos ) || ( getSize( start + pos ) < mult ) ) ) ) 
	{
	  pos = pos + max( mult, getSize( start + pos ) );
	}
      
	*(start + i) = pos;
    }
}

/* allocates memory in the first available space.  First fit */
int firstSlot( int mult, int counter )
{
  int pos;
  int *start = (int *)dseg_lo;

  pos = *(start + counter);

   while ( (pos < *start) && (!is_free( (start + pos) ) || (getSize(start + pos) < mult ))) 
      pos = pos + max( mult, getSize( (start + pos) ) );


  return pos;
}

/* checks if a block is big enough to fit a certain size request*/
int canPut( int *start, int length )
{
  int tempLength;

  if ( is_free( start ) && getSize( start ) >= length )
    {
      tempLength = *start;
      
      setSize(start,length);

      setSize(start + length - 1, length);

      if ( tempLength > length )
	{
	  setSize(start + length, tempLength - length);
	  setSize(start + tempLength - 1, tempLength - length);
	}
  
      return 1;
    }
  else
    return 0;
}

/* checks to see if a certain size can be placed in a certain sized block */
int canNeverPut( int *start, int length )
{
  if ( !is_free( start ) && getSize( start ) >= length )
    return 1;
  else
    return 0;
}

/* searchs a block of free memory for a space to place the requested size allocation. 
   uses canPut and canNeverPut */
void tryPutFree( int *start, int length )
{
  if ( canPut( start, length ) == 1 )
    return;
  else
    {
      if ( canNeverPut( start, length ) == 1 )
	return;

      if ( length > 8 )
	{
	  tryPutFree( start, length/2 );
	  tryPutFree( start + length/2, length/2 );
	}
    }
}
	     
/* doubles size of heap */
int mm_double( int amount )
{
  int size;
  int shift;
  int *address;
  int *start;

  size = (amount/mem_pagesize() + 1)*mem_pagesize();

  if ( mem_sbrk( size ) == NULL )
    return -1;

  size = size/4;

  start = (int *)dseg_lo;

  shift = *start;
  address = start + shift;

  setSize( address, getSize(address) + size );
    
  return 0;
}


/* allocates free blocks to be filled with stuff */
void allocate( int *pos )
{
  *pos = (*pos)|(1<<31);
}

void unallocate( int *pos )
{
  *pos = (*pos)^(1<<31);
  *(pos + *pos - 1) = *pos;
}

/* returns size of a block*/
int getSize( int *pos )
{
  if ( is_free( pos ) )
    return *pos;
  else
    return (*pos)^(1<<31);
}

/* sets size of a block to a certain value */
void setSize( int *pos, int value )
{
  *pos = value;
}

/* given to ints a and b, max returns the maximum of the two */
int max( int a, int b )
{
  if ( a > b )
    return a;
  else
    return b;
}

/* the main event.  mm_malloc attempts to allocate memory of the requested size */
void *mm_malloc (size_t size)
{
  int pos;
  int *start = (int *)dseg_lo;
  int outerMult, mult;
  int counter;


  mult = 8;

  size = size + 8;

  if ( size%8 != 0 )
    size = size + 8-(size%8);

  size = size/4;

  counter = 1;

  while ( size > mult )
    {
      counter = counter + 1;
      mult = mult*2;
    }

  pos = firstSlot( mult, counter );

  if ( pos >= *start )
    {
      while ( (dseg_lo + 4*pos + 4*mult) > dseg_hi )
	{
	  if ( mm_double( dseg_lo + 4*pos + 4*mult - dseg_hi ) == -1 )
	    return NULL;
	}

      setSize(start + pos + mult, getSize(start + *start) - ((pos - *start) + mult) );
      setSize(start + pos, mult);

      if ( pos > *start )
	{
	  setSize(start + *start, pos - *start );
	  

	  setSize(start + pos - 1, getSize(start + *start) );


	  tryPutFree( (start + pos - mult), mult );
	}

      setSize(start + pos, mult);
       
      *start = pos + mult;

      setSize(start + pos + mult - 1, mult);
    }
  else
    {
      outerMult = getSize(start + pos);

      while ( outerMult >= 2*mult )
	{
	  outerMult = outerMult/2;
	  
	  setSize(start + pos + 2*outerMult - 1, outerMult);
	  setSize(start + pos + outerMult, outerMult);
	  setSize(start + pos + outerMult -1, outerMult);
	  setSize(start + pos, outerMult);
	}

    }

  allocate( start + pos );
  allocate( start + pos + mult -1);


  updatePointers();


  return start + pos + 1;

}

/* Returns the position of the header of a certain block of the requested size */
int getHeaderPos( int size )
{
  if ( size == 8 )
    return 1;
      
  if ( size == 16 )
    return 2;

  if ( size == 32 )
    return 3;
  
  if ( size == 64 )
    return 4;
  
  if ( size == 128 )
    return 5;
  
  if ( size == 256 )
    return 6;
  
  if ( size == 512 )
    return 7;
  
  if ( size == 1024 )
    return 8;
  
  if ( size == 2048 )
    return 9;
  
  if ( size == 4096 )
    return 10;
  
  if ( size == 8192 )
    return 11;
  
  return 12;
}

/* frees memory at the requested position for new allocation */
int basicFree( int *pos)
{
  int size;
  int counter = 1;
  int *start = (int *)dseg_lo;
  int i;
  int oldsize;

  if ( !is_free( pos - 1) )
    {
      size = getSize( pos - 1);
      unallocate( pos - 1 );

      counter = getHeaderPos( size );

      if ( *start == ((pos - 1) - start) + size )
	{
	  oldsize = getSize(start + *start);
	  for ( i = 1; i <= counter; i++ )
	    {	  
	      if ( *(start + i) == *start )
		*(start + i) = ((pos-1)-start);
	    }

	}

      if ( *(start + counter) > ((pos - 1)-start) )
	*(start + counter) = ((pos - 1)-start);
	
      return 1;
    }
  return 0;
}

/* the official way to free memory for new allocation */
void mm_free (void *ptr)
{
  basicFree( (int *)ptr );

}


